/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.schema.completion.CompletionPaintComponent;
import org.netbeans.modules.xml.schema.completion.DocumentationQuery;
import org.netbeans.modules.xml.schema.completion.ToolTipQuery;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public abstract class CompletionResultItem
implements CompletionItem {
    protected boolean shift = false;
    protected String typedChars;
    protected String itemText;
    protected Icon icon;
    protected CompletionPaintComponent component;
    protected AXIComponent axiComponent;
    private CompletionContextImpl context;
    public static final String ICON_ELEMENT = "element.png";
    public static final String ICON_ATTRIBUTE = "attribute.png";
    public static final String ICON_VALUE = "value.png";
    public static final String ICON_LOCATION = "/org/netbeans/modules/xml/schema/completion/resources/";

    public CompletionResultItem(AXIComponent aXIComponent, CompletionContext completionContext) {
        this.context = (CompletionContextImpl)completionContext;
        this.axiComponent = aXIComponent;
        this.typedChars = completionContext.getTypedChars();
    }

    Icon getIcon() {
        return this.icon;
    }

    public AXIComponent getAXIComponent() {
        return this.axiComponent;
    }

    public String getItemText() {
        return this.itemText;
    }

    public abstract String getDisplayText();

    public abstract String getReplacementText();

    public abstract int getCaretPosition();

    public String toString() {
        return this.getItemText();
    }

    Color getPaintColor() {
        return Color.BLUE;
    }

    private void replaceText(final JTextComponent jTextComponent, final String string, final int n, final int n2) {
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        baseDocument.runAtomic(new Runnable(){

            public void run() {
                try {
                    if (CompletionResultItem.this.context.canReplace(string)) {
                        baseDocument.remove(n, n2);
                        baseDocument.insertString(n, string, null);
                    }
                    jTextComponent.setCaretPosition(n + CompletionResultItem.this.getCaretPosition());
                    String string3 = CompletionUtil.getPrefixFromTag(string);
                    if (string3 == null) {
                        return;
                    }
                    if (!CompletionResultItem.this.context.isSpecialCompletion() && !CompletionResultItem.this.context.isPrefixBeingUsed(string3)) {
                        String string2 = CompletionResultItem.this.context.getTargetNamespaceByPrefix(string3);
                        baseDocument.insertString(CompletionUtil.getNamespaceInsertionOffset((Document)baseDocument), " xmlns:" + string3 + "=\"" + string2 + "\"", null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new DocumentationQuery(this));
    }

    public CompletionTask createToolTipTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new ToolTipQuery(this));
    }

    public void defaultAction(JTextComponent jTextComponent) {
        int n = this.typedChars == null ? 0 : this.typedChars.length();
        int n2 = jTextComponent.getCaretPosition() - n;
        if (!this.shift) {
            Completion.get().hideAll();
        }
        if (this.getReplacementText().equals(this.typedChars)) {
            return;
        }
        this.replaceText(jTextComponent, this.getReplacementText(), n2, n);
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public abstract CompletionPaintComponent getPaintComponent();

    public int getPreferredWidth(Graphics graphics, Font font) {
        CompletionPaintComponent completionPaintComponent = this.getPaintComponent();
        return completionPaintComponent.getPreferredSize().width;
    }

    public int getSortPriority() {
        return 0;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this.shift = keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401 && keyEvent.isShiftDown();
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionPaintComponent completionPaintComponent = this.getPaintComponent();
        completionPaintComponent.setFont(font);
        completionPaintComponent.setForeground(color);
        completionPaintComponent.setBackground(color2);
        completionPaintComponent.setBounds(0, 0, n, n2);
        completionPaintComponent.setSelected(bl);
        completionPaintComponent.paintComponent(graphics);
    }
}

