/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.gsf.spi.CommentHandler;
import org.openide.util.Exceptions;

public class ToggleBlockCommentAction
extends ExtKit.ToggleCommentAction {
    static final long serialVersionUID = -1L;
    private final CommentHandler commentHandler;
    private final int COMMENT_START_LENGTH;
    private final int COMMENT_END_LENGTH;

    public ToggleBlockCommentAction(CommentHandler commentHandler) {
        super("");
        this.COMMENT_START_LENGTH = commentHandler.getCommentStartDelimiter().length();
        this.COMMENT_END_LENGTH = commentHandler.getCommentEndDelimiter().length();
        this.commentHandler = commentHandler;
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            Caret caret = jTextComponent.getCaret();
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n = Utilities.isSelectionShowing((Caret)caret) ? jTextComponent.getSelectionStart() : caret.getDot();
            int n2 = Utilities.isSelectionShowing((Caret)caret) ? jTextComponent.getSelectionEnd() : caret.getDot();
            boolean bl = false;
            if (n == n2 && !this.isInComment((Document)baseDocument, n)) {
                try {
                    if (Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n)) {
                        return;
                    }
                    n = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)Utilities.getRowStart((BaseDocument)baseDocument, (int)n));
                    n2 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2)) + 1;
                    bl = true;
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            final int[] nArray = this.commentHandler.getCommentBlocks((Document)baseDocument, n, n2);
            assert (nArray != null);
            this.check(nArray, n, n2);
            final int n3 = n;
            final int n4 = n2;
            final boolean bl2 = bl;
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        int[] nArray2 = ToggleBlockCommentAction.this.getCommentRange(nArray, n3);
                        if (nArray2 == null) {
                            ToggleBlockCommentAction.this.comment(jTextComponent, baseDocument, nArray, n3, n4, bl2);
                        } else if (nArray.length > 0) {
                            ToggleBlockCommentAction.this.uncomment(jTextComponent, baseDocument, nArray, n3, n4, bl2);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
    }

    private void comment(JTextComponent jTextComponent, BaseDocument baseDocument, int[] nArray, int n, int n2, boolean bl) throws BadLocationException {
        int n3 = 0;
        n3 += this.insert((Document)baseDocument, n, this.commentHandler.getCommentStartDelimiter());
        for (int i = 0; i < nArray.length; i += 2) {
            int n4 = nArray[i];
            int n5 = nArray[i + 1];
            n3 += this.remove((Document)baseDocument, n4 + n3, this.COMMENT_START_LENGTH);
            if (n5 > n2) continue;
            n3 += this.remove((Document)baseDocument, n5 + n3 - this.COMMENT_END_LENGTH, this.COMMENT_END_LENGTH);
        }
        if (nArray.length == 0 || nArray[nArray.length - 1] <= n2) {
            n3 += this.insert((Document)baseDocument, n2 + n3, this.commentHandler.getCommentEndDelimiter());
        }
        if (!bl) {
            jTextComponent.setSelectionStart(n);
            jTextComponent.setSelectionEnd(n2 + n3);
        }
    }

    private void uncomment(JTextComponent jTextComponent, BaseDocument baseDocument, int[] nArray, int n, int n2, boolean bl) throws BadLocationException {
        int n3;
        int n4 = 0;
        if (n == n2) {
            assert (nArray.length == 2);
            n = nArray[0];
            n2 = nArray[1];
            bl = true;
        }
        if (nArray[0] < n) {
            n4 += this.insert((Document)baseDocument, n, this.commentHandler.getCommentEndDelimiter());
        }
        int n5 = n + n4;
        for (n3 = 0; n3 < nArray.length; n3 += 2) {
            int n6 = nArray[n3];
            int n7 = nArray[n3 + 1];
            if (n6 >= n) {
                n4 += this.remove((Document)baseDocument, n6 + n4, this.COMMENT_START_LENGTH);
            }
            if (n7 > n2) continue;
            n4 += this.remove((Document)baseDocument, n7 + n4 - this.COMMENT_END_LENGTH, this.COMMENT_END_LENGTH);
        }
        n3 = n2 + n4;
        if (nArray[nArray.length - 1] > n2) {
            n4 += this.insert((Document)baseDocument, n2 + n4, this.commentHandler.getCommentStartDelimiter());
        }
        if (!bl) {
            jTextComponent.setSelectionStart(n5);
            jTextComponent.setSelectionEnd(n3);
        }
    }

    private int insert(Document document, int n, String string) throws BadLocationException {
        document.insertString(n, string, null);
        return string.length();
    }

    private int remove(Document document, int n, int n2) throws BadLocationException {
        document.remove(n, n2);
        return -n2;
    }

    private int[] getCommentRange(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int n3 = nArray[++i];
            if (n2 > n || n3 <= n) continue;
            return new int[]{n2, n3};
        }
        return null;
    }

    private boolean isInComment(Document document, int n) {
        CharSequence charSequence = DocumentUtilities.getText((Document)document);
        int n2 = CharSequenceUtilities.lastIndexOf((CharSequence)charSequence, (CharSequence)this.commentHandler.getCommentStartDelimiter(), (int)n);
        int n3 = CharSequenceUtilities.lastIndexOf((CharSequence)charSequence, (CharSequence)this.commentHandler.getCommentEndDelimiter(), (int)n);
        return n2 > -1 && (n2 > n3 || n3 == -1);
    }

    private void debug(Document document, int[] nArray, int n, int n2) {
        System.out.println("TOGGLE_COMENT [" + n + "-" + n2 + "]");
        for (int i = 0; i < nArray.length; ++i) {
            try {
                int n3 = nArray[i];
                int n4 = nArray[++i];
                if (n3 <= n && n4 > n2) {
                    System.out.print("*");
                }
                System.out.print("[" + n3 + " - " + n4 + "]");
                System.out.println(document.getText(n3, n4 - n3));
                continue;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        System.out.println("----------------");
    }

    private void check(int[] nArray, int n, int n2) {
        if (nArray.length % 2 != 0) {
            throw new IllegalArgumentException("Comments array size must be even, e.g. contain just pairs.");
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            int n4 = nArray[++i];
            if ((n3 >= n || n4 >= n) && (n4 <= n2 || n3 <= n2)) continue;
            throw new IllegalArgumentException("Comment [" + n3 + " - " + n4 + " is out of the range [" + n + " - " + n2 + "]!");
        }
    }
}

