/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.IndexSearcher;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.api.queries.SourceForBinaryQuery;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.RepositoryUpdater;
import org.netbeans.napi.gsfret.source.ClassIndex;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsfTypeProvider
implements TypeProvider,
IndexSearcher.Helper {
    private static final Logger LOGGER = Logger.getLogger(GsfTypeProvider.class.getName());
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private Set<CacheItem> cache;
    private volatile boolean isCancelled = false;

    public void cleanup() {
        this.cache = null;
    }

    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result result) {
        SourceForBinaryQuery.Result result2;
        FileObject[] fileObjectArray;
        Object object;
        long l;
        this.isCancelled = false;
        String string = context.getText();
        SearchType searchType = context.getSearchType();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        if (this.cache == null) {
            int n;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("GoToTypeAction.getTypeNames recreates cache\n");
            }
            l = System.currentTimeMillis();
            object = RepositoryUpdater.getDefault().getScannedSources();
            fileObjectArray = object.getRoots();
            l7 += System.currentTimeMillis() - l;
            Object object2 = new FileObject[1];
            HashSet<CacheItem> object3 = new HashSet<CacheItem>(fileObjectArray.length);
            for (n = 0; n < fileObjectArray.length; ++n) {
                object2[0] = fileObjectArray[n];
                l = System.currentTimeMillis();
                result2 = ClasspathInfo.create(EMPTY_CLASSPATH, EMPTY_CLASSPATH, ClassPathSupport.createClassPath((FileObject[])object2));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("GoToTypeAction.getTypeNames created ClasspathInfo for source: " + FileUtil.getFileDisplayName((FileObject)fileObjectArray[n]) + "\n");
                }
                if (this.isCancelled) {
                    return;
                }
                object3.add(new CacheItem(fileObjectArray[n], (ClasspathInfo)result2, false));
                l8 += System.currentTimeMillis() - l;
            }
            l = System.currentTimeMillis();
            object = RepositoryUpdater.getDefault().getScannedBinaries();
            fileObjectArray = object.getRoots();
            l6 += System.currentTimeMillis() - l;
            object2 = new FileObject[1];
            for (n = 0; n < fileObjectArray.length; ++n) {
                try {
                    l = System.currentTimeMillis();
                    result2 = SourceForBinaryQuery.findSourceRoots((URL)fileObjectArray[n].getURL());
                    if (result2.getRoots().length == 0) continue;
                    l5 += System.currentTimeMillis() - l;
                    l = System.currentTimeMillis();
                    object2[0] = fileObjectArray[n];
                    ClasspathInfo classpathInfo = ClasspathInfo.create(ClassPathSupport.createClassPath((FileObject[])object2), EMPTY_CLASSPATH, EMPTY_CLASSPATH);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("GoToTypeAction.getTypeNames created ClasspathInfo for binary: " + FileUtil.getFileDisplayName((FileObject)fileObjectArray[n]) + "\n");
                    }
                    object3.add(new CacheItem(fileObjectArray[n], classpathInfo, true));
                    l8 += System.currentTimeMillis() - l;
                    continue;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if (!this.isCancelled) {
                this.cache = object3;
            } else {
                return;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("GoToTypeAction.getTypeNames collected : " + this.cache.size() + " elements\n");
        }
        object = new ArrayList(this.cache.size() * 20);
        switch (searchType) {
            case CAMEL_CASE: {
                fileObjectArray = NameKind.CAMEL_CASE;
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                fileObjectArray = NameKind.CASE_INSENSITIVE_PREFIX;
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                fileObjectArray = NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case PREFIX: {
                fileObjectArray = NameKind.PREFIX;
                break;
            }
            case REGEXP: {
                fileObjectArray = NameKind.REGEXP;
                break;
            }
            case EXACT_NAME: {
                fileObjectArray = NameKind.EXACT_NAME;
                break;
            }
            case CASE_INSENSITIVE_EXACT_NAME: {
                fileObjectArray = NameKind.EXACT_NAME;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected name kind: " + searchType);
            }
        }
        for (CacheItem cacheItem : this.cache) {
            Object object2;
            l = System.currentTimeMillis();
            switch (searchType) {
                case CASE_INSENSITIVE_REGEXP: 
                case REGEXP: {
                    result2 = string + "*";
                    result2 = result2.replace("*", ".*").replace('?', '.');
                    object2 = result2;
                    break;
                }
                default: {
                    object2 = string;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("GoToTypeAction.getTypeNames queries usages of: " + cacheItem.classpathInfo + "\n");
            }
            result2 = this.getTypes(cacheItem.classpathInfo, (String)object2, (NameKind)fileObjectArray, EnumSet.of(cacheItem.isBinary ? Index.SearchScope.DEPENDENCIES : Index.SearchScope.SOURCE));
            if (this.isCancelled) {
                return;
            }
            l4 += System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            for (TypeDescriptor typeDescriptor : result2) {
                ((ArrayList)object).add(typeDescriptor);
                if (!this.isCancelled) continue;
                return;
            }
            l3 += System.currentTimeMillis() - l;
        }
        if (!this.isCancelled) {
            l = System.currentTimeMillis();
            l2 += System.currentTimeMillis() - l;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("PERF -  GSS:  " + l7 + " GSB " + l6 + " CP: " + l8 + " SFB: " + l5 + " GTN: " + l4 + "  ADD: " + l3 + "  SORT: " + l2);
            }
            result.addResult((List)object);
        }
    }

    private Set<? extends TypeDescriptor> getTypes(ClasspathInfo classpathInfo, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet) {
        HashSet<GsfTypeDescriptor> hashSet = new HashSet<GsfTypeDescriptor>();
        for (Language language : LanguageRegistry.getInstance()) {
            IndexSearcher indexSearcher = language.getIndexSearcher();
            if (indexSearcher == null) continue;
            ClassIndex classIndex = classpathInfo.getClassIndex(language.getMimeType());
            try {
                Set set = indexSearcher.getTypes((Index)classIndex, string, nameKind, enumSet, (IndexSearcher.Helper)this);
                if (set == null) continue;
                for (IndexSearcher.Descriptor descriptor : set) {
                    GsfTypeDescriptor gsfTypeDescriptor = new GsfTypeDescriptor(descriptor);
                    hashSet.add(gsfTypeDescriptor);
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return hashSet;
    }

    public Icon getIcon(ElementHandle elementHandle) {
        return Icons.getElementIcon(elementHandle.getKind(), elementHandle.getModifiers());
    }

    public void open(FileObject fileObject, ElementHandle elementHandle) {
        Source source = Source.forFileObject(fileObject);
        if (source != null) {
            UiUtils.open(source, elementHandle);
        }
    }

    public String name() {
        return "GSF";
    }

    public String getDisplayName() {
        return LanguageRegistry.getInstance().getLanguagesDisplayName();
    }

    public void cancel() {
        this.isCancelled = true;
    }

    private class GsfTypeDescriptor
    extends TypeDescriptor {
        private IndexSearcher.Descriptor delegated;

        private GsfTypeDescriptor(IndexSearcher.Descriptor descriptor) {
            this.delegated = descriptor;
        }

        public String getSimpleName() {
            return this.delegated.getSimpleName();
        }

        public String getOuterName() {
            return this.delegated.getOuterName();
        }

        public String getTypeName() {
            return this.delegated.getTypeName();
        }

        public String getContextName() {
            String string = this.delegated.getContextName();
            if (string != null) {
                return " (" + string + ")";
            }
            return string;
        }

        public Icon getIcon() {
            return this.delegated.getIcon();
        }

        public String getProjectName() {
            return this.delegated.getProjectName();
        }

        public Icon getProjectIcon() {
            return this.delegated.getProjectIcon();
        }

        public FileObject getFileObject() {
            return this.delegated.getFileObject();
        }

        public int getOffset() {
            return this.delegated.getOffset();
        }

        public void open() {
            this.delegated.open();
        }
    }

    static class CacheItem {
        public final boolean isBinary;
        public final FileObject fileObject;
        public final ClasspathInfo classpathInfo;
        public String projectName;
        public Icon projectIcon;

        public CacheItem(FileObject fileObject, ClasspathInfo classpathInfo, boolean bl) {
            this.isBinary = bl;
            this.fileObject = fileObject;
            this.classpathInfo = classpathInfo;
        }

        public int hashCode() {
            return this.fileObject == null ? 0 : this.fileObject.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CacheItem) {
                CacheItem cacheItem = (CacheItem)object;
                return this.fileObject == null ? cacheItem.fileObject == null : this.fileObject.equals(cacheItem.fileObject);
            }
            return false;
        }

        public FileObject getRoot() {
            return this.fileObject;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (this.projectName == null) {
                try {
                    URL uRL = this.fileObject.getURL();
                    if (ClassIndexManager.isBootRoot(uRL)) {
                        this.projectName = "Ruby Lib";
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        private void initProjectInfo() {
            Project project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
            if (project != null) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                this.projectName = projectInformation.getDisplayName();
                this.projectIcon = projectInformation.getIcon();
            }
        }
    }
}

