/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathProvider;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;

public class GsfTaskProvider
extends PushTaskScanner {
    private TaskScanningScope scope;
    private PushTaskScanner.Callback callback;
    private static final String TASKLIST_ERROR = "nb-tasklist-error";
    private static final String TASKLIST_WARNING = "nb-tasklist-warning";
    private static final String TASKLIST_ERROR_HINT = "nb-tasklist-errorhint";
    private static final String TASKLIST_WARNING_HINT = "nb-tasklist-warninghint";
    private static final Set<RequestProcessor.Task> TASKS = new HashSet<RequestProcessor.Task>();
    private static boolean clearing;
    private static final RequestProcessor WORKER;
    private static GsfTaskProvider INSTANCE;

    public GsfTaskProvider() {
        this(null);
        INSTANCE = this;
    }

    private GsfTaskProvider(String string) {
        super(NbBundle.getMessage(GsfTaskProvider.class, (String)"GsfTasks"), NbBundle.getMessage(GsfTaskProvider.class, (String)"GsfTasksDesc"), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setScope(TaskScanningScope taskScanningScope, PushTaskScanner.Callback callback) {
        GsfTaskProvider.cancelAllCurrent();
        Iterator iterator = TASKS;
        synchronized (iterator) {
            this.scope = taskScanningScope;
            this.callback = callback;
        }
        if (taskScanningScope == null || callback == null) {
            return;
        }
        for (FileObject fileObject : taskScanningScope.getLookup().lookupAll(FileObject.class)) {
            GsfTaskProvider.enqueue(new Work(fileObject, callback));
        }
        for (FileObject fileObject : taskScanningScope.getLookup().lookupAll(Project.class)) {
            ClassPath classPath;
            ClassPathProvider classPathProvider = (ClassPathProvider)fileObject.getLookup().lookup(ClassPathProvider.class);
            if (classPathProvider == null || (classPath = classPathProvider.findClassPath(fileObject.getProjectDirectory(), "classpath/source")) == null) continue;
            for (FileObject fileObject2 : classPath.getRoots()) {
                GsfTaskProvider.enqueue(new Work(fileObject2, callback));
            }
        }
    }

    public static void refresh(FileObject fileObject) {
        if (INSTANCE != null) {
            INSTANCE.refreshImpl(fileObject);
        }
    }

    private synchronized void refreshImpl(FileObject fileObject) {
        if (this.scope == null || this.callback == null) {
            return;
        }
        if (!this.scope.isInScope(fileObject)) {
            if (!fileObject.isFolder()) {
                return;
            }
            for (FileObject fileObject2 : this.scope.getLookup().lookupAll(FileObject.class)) {
                if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) continue;
                GsfTaskProvider.enqueue(new Work(fileObject2, this.callback));
            }
            return;
        }
        GsfTaskProvider.enqueue(new Work(fileObject, this.callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueue(Work work) {
        Set<RequestProcessor.Task> set = TASKS;
        synchronized (set) {
            if (INSTANCE != null && TASKS.size() == 0 && GsfTaskProvider.INSTANCE.callback != null) {
                GsfTaskProvider.INSTANCE.callback.started();
            }
            RequestProcessor.Task task = WORKER.post((Runnable)work);
            TASKS.add(task);
            task.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(org.openide.util.Task task) {
                    Set set = TASKS;
                    synchronized (set) {
                        if (!clearing) {
                            TASKS.remove(task);
                            if (INSTANCE != null && TASKS.size() == 0 && INSTANCE.callback != null) {
                                INSTANCE.callback.finished();
                            }
                        }
                    }
                }
            });
            if (task.isFinished()) {
                TASKS.remove(task);
                if (INSTANCE != null && TASKS.size() == 0 && GsfTaskProvider.INSTANCE.callback != null) {
                    GsfTaskProvider.INSTANCE.callback.finished();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelAllCurrent() {
        Set<RequestProcessor.Task> set = TASKS;
        synchronized (set) {
            clearing = true;
            try {
                for (RequestProcessor.Task task : TASKS) {
                    task.cancel();
                }
                TASKS.clear();
            }
            finally {
                clearing = false;
            }
        }
    }

    private static String severityToTaskListString(org.netbeans.spi.editor.hints.Severity severity) {
        return severity == org.netbeans.spi.editor.hints.Severity.ERROR ? TASKLIST_ERROR_HINT : TASKLIST_WARNING_HINT;
    }

    static {
        WORKER = new RequestProcessor("GSF Task Provider");
    }

    private static final class Work
    implements Runnable {
        private FileObject fileOrRoot;
        private PushTaskScanner.Callback callback;

        public Work(FileObject fileObject, PushTaskScanner.Callback callback) {
            this.fileOrRoot = fileObject;
            this.callback = callback;
        }

        public FileObject getFileOrRoot() {
            return this.fileOrRoot;
        }

        public PushTaskScanner.Callback getCallback() {
            return this.callback;
        }

        public void run() {
            FileObject fileObject = this.getFileOrRoot();
            this.refreshFile(fileObject);
        }

        private void refreshFile(final FileObject fileObject) {
            Object object;
            if (!fileObject.isValid()) {
                return;
            }
            if (fileObject.isFolder()) {
                if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
                    return;
                }
                String string = fileObject.getName();
                if (string.equals("vendor") && fileObject.getParent().getFileObject("nbproject") != null) {
                    return;
                }
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    this.refreshFile(fileObject2);
                }
                return;
            }
            final LanguageRegistry languageRegistry = LanguageRegistry.getInstance();
            List<Language> list = languageRegistry.getApplicableLanguages(fileObject.getMIMEType());
            boolean bl = false;
            for (Language object22 : list) {
                object = object22.getHintsProvider();
                if (object != null) {
                    bl = true;
                    break;
                }
                if (object22.getParser() == null) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            if (fileObject.getSize() > 0x100000L) {
                return;
            }
            final ArrayList arrayList = new ArrayList();
            Source source = Source.forFileObject(fileObject);
            if (source == null) {
                return;
            }
            object = new ArrayList();
            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>((List)object){
                final /* synthetic */ List val$tasks;
                {
                    this.val$tasks = list2;
                }

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    GsfUtilities.getDocument((FileObject)compilationController.getFileObject(), (boolean)true);
                    compilationController.toPhase(Phase.RESOLVED);
                    for (String string : compilationController.getEmbeddedMimeTypes()) {
                        Collection<? extends ParserResult> collection = compilationController.getEmbeddedResults(string);
                        for (ParserResult parserResult : collection) {
                            Object object;
                            Object object2;
                            Language language = languageRegistry.getLanguageByMimeType(string);
                            HintsProvider hintsProvider = language.getHintsProvider();
                            ArrayList arrayList2 = new ArrayList();
                            if (hintsProvider == null) {
                                object2 = parserResult.getDiagnostics();
                                if (object2 != null) {
                                    arrayList2.addAll(object2);
                                }
                            } else {
                                RuleContext ruleContext;
                                object2 = language.getHintsManager();
                                if (object2 == null || (ruleContext = ((GsfHintsManager)((Object)object2)).createRuleContext(compilationController, language, -1, -1, -1)) == null) continue;
                                object = new ArrayList();
                                hintsProvider.computeErrors((HintsProvider.HintsManager)object2, ruleContext, (List)object, arrayList2);
                                hintsProvider.computeHints((HintsProvider.HintsManager)object2, ruleContext, (List)object);
                                if (!fileObject.isValid()) continue;
                                Iterator iterator = object.iterator();
                                while (iterator.hasNext()) {
                                    Hint hint = (Hint)iterator.next();
                                    ErrorDescription errorDescription = ((GsfHintsManager)((Object)object2)).createDescription(hint, ruleContext, false);
                                    if (errorDescription == null) continue;
                                    arrayList.add(errorDescription);
                                }
                            }
                            for (RuleContext ruleContext : arrayList2) {
                                int n;
                                object = (StyledDocument)compilationController.getDocument();
                                if (object == null) continue;
                                int n2 = ruleContext.getStartPosition();
                                if (parserResult.getTranslatedSource() != null) {
                                    n = parserResult.getTranslatedSource().getLexicalOffset(n2);
                                    if (n == -1) {
                                        continue;
                                    }
                                } else {
                                    n = n2;
                                }
                                int n3 = NbDocument.findLineNumber((StyledDocument)object, (int)n) + 1;
                                Task task = Task.create((FileObject)fileObject, (String)(ruleContext.getSeverity() == Severity.ERROR ? GsfTaskProvider.TASKLIST_ERROR : GsfTaskProvider.TASKLIST_WARNING), (String)ruleContext.getDisplayName(), (int)n3);
                                this.val$tasks.add(task);
                            }
                        }
                    }
                }
            };
            try {
                source.runUserActionTask(cancellableTask, true);
            }
            catch (IOException iterator) {
                Exceptions.printStackTrace((Throwable)iterator);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ErrorDescription errorDescription = (ErrorDescription)iterator.next();
                try {
                    Task iOException = Task.create((FileObject)fileObject, (String)GsfTaskProvider.severityToTaskListString(errorDescription.getSeverity()), (String)errorDescription.getDescription(), (int)(errorDescription.getRange().getBegin().getLine() + 1));
                    object.add(iOException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            this.callback.setTasks(fileObject, (List)object);
        }
    }
}

