/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.gsfret;

import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.editor.gsfret.InstantRenamePerformer;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.EditRegions;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditRegionsImpl
extends EditRegions {
    public void edit(final FileObject fileObject, final Set<OffsetRange> set, final int n) throws BadLocationException {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        EditRegionsImpl.this.edit(fileObject, set, n);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
            return;
        }
        JEditorPane[] jEditorPaneArray = DataLoadersBridge.getDefault().getOpenedPanes(fileObject);
        if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
            return;
        }
        JEditorPane jEditorPane = jEditorPaneArray[0];
        Document document = jEditorPane.getDocument();
        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(fileObject.getMIMEType());
        if (language == null) {
            return;
        }
        if (set != null && set.size() > 0) {
            InstantRenamePerformer.performInstantRename(jEditorPane, set, n);
        }
    }
}

