/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.actions;

import java.util.Iterator;
import javax.swing.JEditorPane;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;

public class ContextUtils {
    private ContextUtils() {
    }

    public static CsmOffsetableDeclaration getContext(Node[] nodeArray) {
        if (nodeArray != null && nodeArray.length > 0) {
            return ContextUtils.findDeclaration(nodeArray[0]);
        }
        return null;
    }

    private static CsmOffsetableDeclaration findDeclaration(Node node) {
        JEditorPane jEditorPane;
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)editorCookie)) != null) {
            int n = jEditorPane.getCaret().getDot();
            CsmFile csmFile = CsmUtilities.getCsmFile((Node)node, (boolean)false);
            if (csmFile != null) {
                return ContextUtils.findInnerFileDeclaration(csmFile, n);
            }
        }
        return null;
    }

    private static CsmOffsetableDeclaration findInnerFileDeclaration(CsmFile csmFile, int n) {
        CsmOffsetableDeclaration csmOffsetableDeclaration = null;
        if (csmOffsetableDeclaration == null) {
            for (CsmOffsetableDeclaration csmOffsetableDeclaration2 : csmFile.getDeclarations()) {
                if (!ContextUtils.isInObject((CsmObject)csmOffsetableDeclaration2, n)) continue;
                csmOffsetableDeclaration = ContextUtils.findInnerDeclaration(csmOffsetableDeclaration2, n);
                csmOffsetableDeclaration = csmOffsetableDeclaration != null ? csmOffsetableDeclaration : csmOffsetableDeclaration2;
                break;
            }
        }
        return csmOffsetableDeclaration;
    }

    private static CsmOffsetableDeclaration findInnerDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration, int n) {
        CsmClass csmClass;
        Iterator iterator = null;
        CsmOffsetableDeclaration csmOffsetableDeclaration2 = null;
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) {
            iterator = ((CsmNamespaceDefinition)csmOffsetableDeclaration).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
            csmClass = (CsmClass)csmOffsetableDeclaration;
            iterator = csmClass.getMembers().iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                csmClass = (CsmOffsetableDeclaration)iterator.next();
                if (!ContextUtils.isInObject((CsmObject)csmClass, n)) continue;
                csmOffsetableDeclaration2 = ContextUtils.findInnerDeclaration((CsmOffsetableDeclaration)csmClass, n);
                csmOffsetableDeclaration2 = csmOffsetableDeclaration2 != null ? csmOffsetableDeclaration2 : csmClass;
                break;
            }
        }
        return csmOffsetableDeclaration2;
    }

    private static boolean isInObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return csmOffsetable.getStartOffset() <= n && n <= csmOffsetable.getEndOffset();
    }
}

