/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

public final class PersistentKey {
    private static final byte UID = 1;
    private static final byte NAMESPACE = 2;
    private static final byte DECLARATION = 4;
    private static final byte PROJECT = 8;
    private static final byte STATE = 16;
    private static final byte MASK = 15;
    private Object key;
    private CsmProject project;
    private byte kind;

    private PersistentKey(CsmUID csmUID, boolean bl) {
        this.key = csmUID;
        this.kind = 1;
        if (bl) {
            this.kind = (byte)(this.kind | 0x10);
        }
    }

    private PersistentKey(CharSequence charSequence, CsmProject csmProject, byte by, boolean bl) {
        this.key = charSequence;
        this.project = csmProject;
        this.kind = by;
        if (bl) {
            this.kind = (byte)(this.kind | 0x10);
        }
    }

    public static PersistentKey createGlobalNamespaceKey(CsmProject csmProject) {
        return new PersistentKey(CharSequenceKey.empty(), csmProject, 2, false);
    }

    public static PersistentKey createKey(Object object) {
        if (CsmKindUtilities.isNamespace((Object)object)) {
            CsmNamespace csmNamespace = (CsmNamespace)object;
            CharSequence charSequence = csmNamespace.getQualifiedName();
            CsmProject csmProject = csmNamespace.getProject();
            if (csmProject != null) {
                return new PersistentKey(charSequence, csmProject, 2, false);
            }
        } else if (!CsmKindUtilities.isEnumerator((Object)object)) {
            if (CsmKindUtilities.isOffsetableDeclaration((Object)object)) {
                CsmProject csmProject;
                CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)object;
                CharSequence charSequence = csmOffsetableDeclaration.getName();
                CharSequence charSequence2 = csmOffsetableDeclaration.getUniqueName();
                CsmScope csmScope = csmOffsetableDeclaration.getScope();
                if (CsmKindUtilities.isCompoundClassifier((CsmObject)csmScope) && charSequence.length() > 0) {
                    csmProject = (CsmCompoundClassifier)csmScope;
                    charSequence = csmProject.getName();
                }
                csmProject = csmOffsetableDeclaration.getContainingFile().getProject();
                if (charSequence.length() > 0 && ((Object)charSequence2).toString().indexOf("::::") < 0 && csmProject != null) {
                    return new PersistentKey(charSequence2, csmProject, 4, PersistentKey.getStateBit(object));
                }
            } else if (CsmKindUtilities.isProject((Object)object)) {
                return new PersistentKey(null, (CsmProject)object, 8, false);
            }
        }
        return new PersistentKey(UIDs.get((Object)object), PersistentKey.getStateBit(object));
    }

    private static boolean getStateBit(Object object) {
        if (object instanceof CsmTypedef) {
            CsmClassifier csmClassifier;
            CsmTypedef csmTypedef = (CsmTypedef)object;
            if (((CsmTypedef)object).isTypeUnnamed() && (csmClassifier = csmTypedef.getType().getClassifier()) != null && csmClassifier.getName().length() == 0 && CsmKindUtilities.isCompoundClassifier((CsmObject)csmClassifier)) {
                return true;
            }
        }
        return false;
    }

    public Object getObject() {
        int n = this.kind & 0xF;
        switch (n) {
            case 1: {
                return ((CsmUID)this.key).getObject();
            }
            case 2: {
                return this.project.findNamespace((CharSequence)this.key);
            }
            case 4: {
                return this.project.findDeclaration((CharSequence)this.key);
            }
            case 8: {
                return this.project;
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof PersistentKey) {
            PersistentKey persistentKey = (PersistentKey)object;
            if (this.kind != persistentKey.kind) {
                return false;
            }
            int n = this.kind & 0xF;
            switch (n) {
                case 1: {
                    return this.key.equals(persistentKey.key);
                }
                case 2: 
                case 4: {
                    if (this.project.equals(persistentKey.project)) {
                        return CharSequenceKey.Comparator.compare((CharSequence)this.key, (CharSequence)persistentKey.key) == 0;
                    }
                    return false;
                }
                case 8: {
                    return this.project.equals(persistentKey.project);
                }
            }
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = this.kind & 0xF;
        int n2 = 0;
        if ((this.kind & 0x10) == 16) {
            n2 = 17;
        }
        switch (n) {
            case 1: {
                return this.key.hashCode() + n2;
            }
            case 2: 
            case 4: {
                return this.project.hashCode() ^ this.key.hashCode() + n2;
            }
            case 8: {
                return this.project.hashCode() + n2;
            }
        }
        return 0;
    }

    public String toString() {
        int n = this.kind & 0xF;
        switch (n) {
            case 1: {
                return "UID " + this.key.toString();
            }
            case 2: {
                return "Namespace " + this.key;
            }
            case 4: {
                return "Declaration " + this.key;
            }
            case 8: {
                return "Project " + this.project.getName();
            }
        }
        return super.toString();
    }
}

