/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.classview.ChildrenUpdater;
import org.netbeans.modules.cnd.classview.ClassViewUpdater;
import org.netbeans.modules.cnd.classview.Diagnostic;
import org.netbeans.modules.cnd.classview.HostKeyArray;
import org.netbeans.modules.cnd.classview.ProjectsKeyArray;
import org.netbeans.modules.cnd.classview.RootNode;
import org.netbeans.modules.cnd.classview.SmartChangeEvent;
import org.netbeans.modules.cnd.classview.model.ProjectNode;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.nodes.Node;

class ClassViewModel {
    private static final boolean showLibs = CndUtils.getBoolean((String)"cnd.classview.sys-includes", (boolean)true);
    private ClassViewUpdater updater = new ClassViewUpdater(this);
    private ChildrenUpdater childrenUpdater = new ChildrenUpdater();
    private volatile boolean userActivity = false;
    private RootNode root;

    public ClassViewModel() {
        this.updater.start();
    }

    public RootNode getRoot() {
        if (this.root == null) {
            this.root = this.createRoot();
        }
        return this.root;
    }

    private RootNode createRoot() {
        return new RootNode(this.childrenUpdater);
    }

    public static boolean isShowLibs() {
        return showLibs;
    }

    void openProject(CsmProject csmProject) {
        if (this.root == null) {
            this.root = this.createRoot();
        }
        if (!ClassViewModel.isShowLibs() && csmProject.isArtificial()) {
            return;
        }
        ProjectsKeyArray projectsKeyArray = (ProjectsKeyArray)this.root.getChildren();
        projectsKeyArray.openProject(csmProject);
    }

    void closeProject(CsmProject csmProject) {
        if (this.root == null) {
            return;
        }
        this.childrenUpdater.unregister(csmProject);
        ProjectsKeyArray projectsKeyArray = (ProjectsKeyArray)this.root.getChildren();
        projectsKeyArray.closeProject(csmProject);
    }

    void scheduleUpdate(CsmChangeEvent csmChangeEvent) {
        this.updater.scheduleUpdate(csmChangeEvent);
    }

    void setUserActivity(boolean bl) {
        this.userActivity = bl;
    }

    boolean isUserActivity() {
        return this.userActivity;
    }

    void dispose() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesM: Dispose model");
        }
        this.updater.setStop();
        this.childrenUpdater.unregister();
        if (this.root != null) {
            this.root.destroy();
            this.root = null;
        }
        this.updater = null;
        this.childrenUpdater = null;
    }

    void update(SmartChangeEvent smartChangeEvent) {
        if (this.childrenUpdater != null) {
            this.childrenUpdater.update(smartChangeEvent);
        }
    }

    Node findDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmFunction csmFunction;
        if (this.root == null) {
            return null;
        }
        ProjectsKeyArray projectsKeyArray = (ProjectsKeyArray)this.root.getChildren();
        CsmFile csmFile = csmOffsetableDeclaration.getContainingFile();
        CsmProject csmProject = csmFile.getProject();
        projectsKeyArray.ensureAddNotify();
        ProjectNode projectNode = (ProjectNode)projectsKeyArray.findChild(((Object)csmProject.getName()).toString());
        if (projectNode == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CsmScope csmScope = null;
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
            csmFunction = ((CsmFunctionDefinition)csmOffsetableDeclaration).getDeclaration();
            if (csmFunction != null) {
                csmOffsetableDeclaration = csmFunction;
            }
            arrayList.add(csmOffsetableDeclaration);
            csmScope = csmOffsetableDeclaration.getScope();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) {
            csmFunction = ((CsmNamespaceDefinition)csmOffsetableDeclaration).getNamespace();
            arrayList.add(csmFunction);
            csmScope = csmFunction.getParent();
        } else {
            arrayList.add(csmOffsetableDeclaration);
            csmScope = csmOffsetableDeclaration.getScope();
        }
        while (csmScope != null) {
            if (CsmKindUtilities.isFile((CsmObject)csmScope)) {
                arrayList.add(csmProject.getGlobalNamespace());
                break;
            }
            arrayList.add(csmScope);
            if (CsmKindUtilities.isNamespace((Object)csmScope)) {
                csmFunction = (CsmNamespace)csmScope;
                if (csmFunction.isGlobal()) break;
                csmScope = csmFunction.getParent();
                continue;
            }
            if (!CsmKindUtilities.isClass((CsmObject)csmScope)) break;
            csmFunction = (CsmClass)csmScope;
            csmScope = csmFunction.getScope();
        }
        csmFunction = null;
        HostKeyArray hostKeyArray = (HostKeyArray)projectNode.getChildren();
        for (int i = arrayList.size() - 2; i >= 0; --i) {
            hostKeyArray.ensureInited();
            csmScope = (CsmObject)arrayList.get(i);
            csmFunction = hostKeyArray.findChild((CsmObject)csmScope);
            if (csmFunction == null || !(csmFunction.getChildren() instanceof HostKeyArray)) continue;
            hostKeyArray = (HostKeyArray)csmFunction.getChildren();
        }
        return csmFunction;
    }

    private void dump(Project[] projectArray) {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("Dumping projects:");
            for (int i = 0; i < projectArray.length; ++i) {
                this.dump(projectArray[i]);
            }
        }
    }

    private void dump(Project project) {
        if (Diagnostic.DEBUG) {
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            Diagnostic.trace("Project " + projectInformation.getName() + " (" + projectInformation.getDisplayName() + ')');
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
            Diagnostic.trace("  Source groups are");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                Diagnostic.trace("    " + sourceGroupArray[i].getName() + " (" + sourceGroupArray[i].getDisplayName() + ") " + sourceGroupArray[i].getRootFolder().getName());
            }
        }
    }
}

