/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.SafeDeletePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeDeleteUI
implements RefactoringUI,
RefactoringUIBypass {
    private final SafeDeleteRefactoring refactoring;
    private Object[] elementsToDelete;
    private SafeDeletePanel panel;
    private ResourceBundle bundle;
    private boolean regulardelete = false;

    public SafeDeleteUI(FileObject[] fileObjectArray, Collection<TreePathHandle> collection, boolean bl) {
        this.elementsToDelete = fileObjectArray;
        this.refactoring = new SafeDeleteRefactoring((Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])this.elementsToDelete), Lookups.fixed((Object[])collection.toArray(new Object[collection.size()]))}));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(fileObjectArray));
        this.regulardelete = bl;
    }

    public SafeDeleteUI(TreePathHandle[] treePathHandleArray) {
        this.elementsToDelete = treePathHandleArray;
        this.refactoring = new SafeDeleteRefactoring(Lookups.fixed((Object[])this.elementsToDelete));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(treePathHandleArray[0]));
    }

    public SafeDeleteUI(NonRecursiveFolder nonRecursiveFolder, boolean bl) {
        this.refactoring = new SafeDeleteRefactoring(Lookups.fixed((Object[])new Object[]{nonRecursiveFolder}));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(nonRecursiveFolder.getFolder()));
        this.regulardelete = bl;
    }

    public Problem checkParameters() {
        this.refactoring.setCheckInComments(this.panel.isSearchInComments());
        return this.refactoring.fastCheckParameters();
    }

    public String getDescription() {
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        if (nonRecursiveFolder != null) {
            return NbBundle.getMessage(SafeDeleteUI.class, (String)"DSC_SafeDelPkg", (Object)nonRecursiveFolder);
        }
        return NbBundle.getMessage(SafeDeleteUI.class, (String)"DSC_SafeDel", (Object[])this.elementsToDelete);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SafeDeleteUI.class.getName());
    }

    public String getName() {
        return NbBundle.getMessage(SafeDeleteUI.class, (String)"LBL_SafeDel");
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            this.panel = new SafeDeletePanel(this.refactoring, this.regulardelete, changeListener);
        }
        return this.panel;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean hasParameters() {
        return true;
    }

    public boolean isQuery() {
        return false;
    }

    public Problem setParameters() {
        this.refactoring.setCheckInComments(this.panel.isSearchInComments());
        return this.refactoring.checkParameters();
    }

    public boolean isRefactoringBypassRequired() {
        return this.panel.isRegularDelete();
    }

    public void doRefactoringBypass() throws IOException {
        FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

            public void run() throws IOException {
                for (FileObject fileObject : SafeDeleteUI.this.getRefactoring().getRefactoringSource().lookupAll(FileObject.class)) {
                    DataObject.find((FileObject)fileObject).delete();
                }
                NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)SafeDeleteUI.this.getRefactoring().getRefactoringSource().lookup(NonRecursiveFolder.class);
                if (nonRecursiveFolder != null) {
                    SafeDeleteUI.this.deletePackage(nonRecursiveFolder.getFolder());
                }
            }
        });
    }

    private void deletePackage(FileObject fileObject) {
        FileObject fileObject2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject3 = dataFolder.getPrimaryFile().getParent();
        try {
            DataObject[] dataObjectArray = dataFolder.getChildren();
            boolean bl = true;
            for (int i = 0; dataObjectArray != null && i < dataObjectArray.length; ++i) {
                if (!dataObjectArray[i].getPrimaryFile().isFolder()) {
                    dataObjectArray[i].delete();
                    continue;
                }
                if (!bl || !VisibilityQuery.getDefault().isVisible(dataObjectArray[i].getPrimaryFile())) continue;
                bl = false;
            }
            if (bl) {
                dataFolder.delete();
            }
            while (!fileObject3.equals(fileObject2) && fileObject3.getChildren().length == 0) {
                FileObject fileObject4 = fileObject3.getParent();
                fileObject3.delete();
                fileObject3 = fileObject4;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

