/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.lang.model.element.Element;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SafeDeletePanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient SafeDeleteRefactoring refactoring;
    private boolean regulardelete;
    private ChangeListener parent;
    private boolean initialized = false;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JPanel checkBoxes;
    private JLabel label;
    private JCheckBox searchInComments;
    private JCheckBox safeDelete;

    public SafeDeletePanel(SafeDeleteRefactoring safeDeleteRefactoring, boolean bl, ChangeListener changeListener) {
        this.setName(NbBundle.getMessage(SafeDeletePanel.class, (String)(bl ? "LBL_SafeDel_Delete" : "LBL_SafeDel")));
        this.refactoring = safeDeleteRefactoring;
        this.regulardelete = bl;
        this.parent = changeListener;
        this.initComponents();
    }

    String getMethodDeclaringClass() {
        return this.methodDeclaringClass;
    }

    public void initialize() {
        String string;
        this.searchInComments.setEnabled(true);
        if (this.initialized) {
            return;
        }
        Lookup lookup = this.refactoring.getRefactoringSource();
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
        Collection collection = lookup.lookupAll(FileObject.class);
        final Collection collection2 = lookup.lookupAll(TreePathHandle.class);
        if (nonRecursiveFolder != null) {
            String string2 = nonRecursiveFolder.getFolder().getNameExt().replace('/', '.');
            string = NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDelPkg", (Object)string2);
        } else if (collection.size() > 1 && collection.size() == collection2.size()) {
            string = this.regulardelete ? NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_RegularDelete", (Object)collection2.size()) : NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_Classes", (Object)collection2.size());
        } else if (collection2.size() > 1) {
            string = NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_Classes", (Object)collection2.size());
        } else if (collection2.size() == 1) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)((TreePathHandle)collection2.iterator().next()).getFileObject());
            final String[] stringArray = new String[1];
            try {
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        Element element = ((TreePathHandle)collection2.iterator().next()).resolveElement((CompilationInfo)compilationController);
                        if (element == null) {
                            throw new NullPointerException("Please attach your {nb.userdir}/var/log/messages.log to http://www.netbeans.org/issues/show_bug.cgi?id=115462\nhandle: " + collection2.iterator().next() + "\nclasspath: " + compilationController.getClasspathInfo());
                        }
                        stringArray[0] = element.getSimpleName().toString();
                    }
                }, true);
            }
            catch (IOException iOException) {
                throw (RuntimeException)new RuntimeException().initCause(iOException);
            }
            string = this.regulardelete ? NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_RegularDeleteElement", (Object)stringArray[0]) : NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_Element", (Object)stringArray[0]);
        } else {
            boolean bl;
            FileObject fileObject = (FileObject)collection.iterator().next();
            boolean bl2 = bl = collection != null && collection.size() == 1 && fileObject.isFolder();
            if (bl && !this.regulardelete) {
                String string3 = fileObject.getName();
                string = NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDelFolder", (Object)string3);
            } else {
                string = "";
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SafeDeletePanel.this.regulardelete) {
                    SafeDeletePanel.this.safeDelete = new JCheckBox();
                    Mnemonics.setLocalizedText((AbstractButton)SafeDeletePanel.this.safeDelete, (String)NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDelCheckBox"));
                    SafeDeletePanel.this.safeDelete.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SafeDeletePanel.class, (String)"SafeDeletePanel.safeDelete.AccessibleContext.accessibleDescription"));
                    SafeDeletePanel.this.safeDelete.setMargin(new Insets(2, 14, 2, 2));
                    SafeDeletePanel.this.searchInComments.setEnabled(false);
                    SafeDeletePanel.this.safeDelete.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent itemEvent) {
                            SafeDeletePanel.this.searchInComments.setEnabled(SafeDeletePanel.this.safeDelete.isSelected());
                            SafeDeletePanel.this.parent.stateChanged(null);
                        }
                    });
                    SafeDeletePanel.this.checkBoxes.add((Component)SafeDeletePanel.this.safeDelete, "Center");
                }
                SafeDeletePanel.this.label.setText(string);
                SafeDeletePanel.this.validate();
            }
        });
        this.initialized = true;
    }

    public void requestFocus() {
        super.requestFocus();
    }

    boolean isRegularDelete() {
        if (this.safeDelete != null) {
            return !this.safeDelete.isSelected();
        }
        return false;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.checkBoxes = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.checkBoxes.setLayout(new BorderLayout());
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.checkBoxes.add((Component)this.label, "North");
        this.searchInComments.setSelected(RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)resourceBundle.getString("LBL_SafeDelInComents"));
        this.searchInComments.setMargin(new Insets(2, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SafeDeletePanel.this.searchInCommentsItemStateChanged(itemEvent);
            }
        });
        this.checkBoxes.add((Component)this.searchInComments, "South");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.checkBoxes, "North");
    }

    private void searchInCommentsItemStateChanged(ItemEvent itemEvent) {
        Boolean bl = itemEvent.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", bl);
        this.refactoring.setCheckInComments(bl.booleanValue());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 30, dimension.height + 30);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }
}

