/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UseSuperTypeRefactoring
extends AbstractRefactoring {
    private final TreePathHandle javaClassHandle;
    private ElementHandle<TypeElement> superType;
    private ElementHandle<TypeElement>[] candidateSuperTypes;

    public UseSuperTypeRefactoring(TreePathHandle treePathHandle) {
        super(Lookups.fixed((Object[])new Object[]{treePathHandle}));
        this.javaClassHandle = treePathHandle;
        this.deriveSuperTypes(treePathHandle);
    }

    public TreePathHandle getTypeElement() {
        return this.javaClassHandle;
    }

    public void setTargetSuperType(ElementHandle<TypeElement> elementHandle) {
        this.superType = elementHandle;
    }

    public ElementHandle<TypeElement> getTargetSuperType() {
        return this.superType;
    }

    public ElementHandle<TypeElement>[] getCandidateSuperTypes() {
        return this.candidateSuperTypes;
    }

    private void deriveSuperTypes(final TreePathHandle treePathHandle) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = (TypeElement)treePathHandle.resolveElement((CompilationInfo)compilationController);
                    UseSuperTypeRefactoring.access$002(UseSuperTypeRefactoring.this, UseSuperTypeRefactoring.this.deduceSuperTypes(typeElement, compilationController));
                }
            }, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void reduceParamTypes(Collection collection, Collection collection2) {
    }

    private ElementHandle[] deduceSuperTypes(TypeElement typeElement, CompilationController compilationController) {
        TypeMirror typeMirror = typeElement.asType();
        Types types = compilationController.getTypes();
        TypeMirrorComparator typeMirrorComparator = new TypeMirrorComparator();
        TreeSet<TypeMirror> treeSet = new TreeSet<TypeMirror>(typeMirrorComparator);
        TreeSet<TypeMirror> treeSet2 = new TreeSet<TypeMirror>(typeMirrorComparator);
        treeSet2.add(typeMirror);
        this.getAllSuperIFs(typeMirror, treeSet2, treeSet, compilationController);
        ElementHandle[] elementHandleArray = new ElementHandle[treeSet.size()];
        int n = 0;
        for (TypeMirror typeMirror2 : treeSet) {
            elementHandleArray[n++] = ElementHandle.create((Element)types.asElement(typeMirror2));
        }
        return elementHandleArray;
    }

    private void getAllSuperIFs(TypeMirror typeMirror, Collection<TypeMirror> collection, Collection<TypeMirror> collection2, CompilationController compilationController) {
        Types types = compilationController.getTypes();
        for (TypeMirror typeMirror2 : types.directSupertypes(typeMirror)) {
            collection2.add(typeMirror2);
            if (collection.contains(typeMirror2)) continue;
            this.getAllSuperIFs(typeMirror2, collection, collection2, compilationController);
        }
    }

    static /* synthetic */ ElementHandle[] access$002(UseSuperTypeRefactoring useSuperTypeRefactoring, ElementHandle[] elementHandleArray) {
        useSuperTypeRefactoring.candidateSuperTypes = elementHandleArray;
        return elementHandleArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeMirrorComparator
    implements Comparator<TypeMirror> {
        private TypeMirrorComparator() {
        }

        @Override
        public int compare(TypeMirror typeMirror, TypeMirror typeMirror2) {
            return ((Object)typeMirror).toString().compareTo(((Object)typeMirror2).toString());
        }
    }
}

