/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.netbeans.modules.search.CleanTask;
import org.netbeans.modules.search.PrintDetailsTask;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.ResultViewPanel;
import org.netbeans.modules.search.SearchDisplayer;
import org.netbeans.modules.search.SearchTask;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.OutputWriter;

final class Manager {
    static final int SEARCHING = 1;
    static final int REPLACING = 8;
    static final int EVENT_SEARCH_STARTED = 1;
    static final int EVENT_SEARCH_FINISHED = 2;
    static final int EVENT_SEARCH_INTERRUPTED = 3;
    static final int EVENT_SEARCH_CANCELLED = 4;
    private static final Manager instance = new Manager();
    private boolean moduleBeingUninstalled = false;
    private final List<Runnable> pendingTasks = Collections.synchronizedList(new LinkedList());
    private TaskListener taskListener;
    private final List<Runnable> currentTasks = Collections.synchronizedList(new LinkedList());
    private final List<Runnable> stoppingTasks = Collections.synchronizedList(new LinkedList());
    private boolean searchWindowOpen = false;
    private Reference<OutputWriter> outputWriterRef;
    private Map<Task, Runnable> tasksMap = new HashMap<Task, Runnable>();

    static Manager getInstance() {
        return instance;
    }

    private Manager() {
    }

    void scheduleSearchTask(SearchTask searchTask) {
        assert (EventQueue.isDispatchThread());
        ResultViewPanel resultViewPanel = ResultView.getInstance().initiateResultView(searchTask);
        ResultModel resultModel = searchTask.getResultModel();
        resultViewPanel.setResultModel(resultModel);
        this.pendingTasks.add(searchTask);
        this.processNextPendingTask();
    }

    void scheduleReplaceTask(ReplaceTask replaceTask) {
        assert (EventQueue.isDispatchThread());
        this.pendingTasks.add(replaceTask);
        this.processNextPendingTask();
    }

    void schedulePrintTask(PrintDetailsTask printDetailsTask) {
        assert (EventQueue.isDispatchThread());
        this.pendingTasks.add(printDetailsTask);
        this.processNextPendingTask();
    }

    void scheduleCleanTask(CleanTask cleanTask) {
        assert (EventQueue.isDispatchThread());
        this.pendingTasks.add(cleanTask);
        this.processNextPendingTask();
    }

    String mayStartSearching() {
        String string = this.haveRunningReplaceTask() ? "MSG_Cannot_start_search__replacing" : null;
        return string != null ? NbBundle.getMessage(this.getClass(), (String)string) : null;
    }

    private void notifySearchStarted(SearchTask searchTask) {
        this.notifySearchTaskStateChange(searchTask, 1);
    }

    private void notifySearchFinished(SearchTask searchTask) {
        this.notifySearchTaskStateChange(searchTask, 2);
    }

    private void notifySearchInterrupted(SearchTask searchTask) {
        this.notifySearchTaskStateChange(searchTask, 3);
    }

    private void notifySearchCancelled(SearchTask searchTask) {
        this.notifySearchTaskStateChange(searchTask, 4);
    }

    private void notifySearchTaskStateChange(SearchTask searchTask, int n) {
        Method method;
        try {
            method = ResultView.class.getDeclaredMethod("searchTaskStateChanged", SearchTask.class, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        this.callOnWindowFromAWT(method, new Object[]{searchTask, new Integer(n)});
    }

    private void notifySearchPending(SearchTask searchTask, int n) {
        Method method;
        if (!this.searchWindowOpen) {
            return;
        }
        try {
            method = ResultView.class.getDeclaredMethod("notifySearchPending", SearchTask.class, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        this.callOnWindowFromAWT(method, new Object[]{searchTask, new Integer(n)});
    }

    private void notifyReplaceFinished(ReplaceTask replaceTask) {
        ReplaceTask.ResultStatus resultStatus = replaceTask.getResultStatus();
        if (resultStatus == ReplaceTask.ResultStatus.SUCCESS) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"MSG_Success"));
            if (this.searchWindowOpen) {
                Method method;
                try {
                    method = ResultView.class.getDeclaredMethod("closeAndSendFocusToEditor", ReplaceTask.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalStateException(noSuchMethodException);
                }
                this.callOnWindowFromAWT(method, new Object[]{replaceTask}, false);
            }
        } else {
            String string = resultStatus == ReplaceTask.ResultStatus.PRE_CHECK_FAILED ? "MSG_Issues_found_during_precheck" : "MSG_Issues_found_during_replace";
            String string2 = NbBundle.getMessage(this.getClass(), (String)string);
            this.displayIssuesFromAWT(replaceTask, string2, resultStatus != ReplaceTask.ResultStatus.PRE_CHECK_FAILED);
            if (resultStatus == ReplaceTask.ResultStatus.PRE_CHECK_FAILED) {
                this.offerRescanAfterIssuesFound(replaceTask);
            }
        }
    }

    private void offerRescanAfterIssuesFound(ReplaceTask replaceTask) {
        String string = NbBundle.getMessage(this.getClass(), (String)"MSG_IssuesFound_Rescan_");
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 3);
        String string2 = NbBundle.getMessage(this.getClass(), (String)"LBL_Rerun");
        message.setOptions(new Object[]{string2, NotifyDescriptor.CANCEL_OPTION});
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        if (string2.equals(object)) {
            Method method;
            try {
                method = ResultView.class.getDeclaredMethod("rescan", ReplaceTask.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(noSuchMethodException);
            }
            this.callOnWindowFromAWT(method, new Object[]{replaceTask}, false);
        }
    }

    private void notifyPrintingDetailsFinished() {
        if (!this.searchWindowOpen) {
            return;
        }
        this.callOnWindowFromAWT("showAllDetailsFinished");
    }

    private void activateResultWindow() {
        Method method;
        try {
            method = ResultView.class.getMethod("requestActive", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(method, null);
    }

    private void displayIssuesFromAWT(ReplaceTask replaceTask, String string, boolean bl) {
        Method method;
        try {
            method = ResultView.class.getDeclaredMethod("displayIssuesToUser", ReplaceTask.class, String.class, String[].class, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        this.callOnWindowFromAWT(method, new Object[]{replaceTask, string, replaceTask.getProblems(), bl}, false);
    }

    private void callOnWindowFromAWT(String string) {
        this.callOnWindowFromAWT(string, true);
    }

    private void callOnWindowFromAWT(String string, boolean bl) {
        Method method;
        try {
            method = ResultView.class.getDeclaredMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(method, null, bl);
    }

    private void callOnWindowFromAWT(String string, Object object) {
        this.callOnWindowFromAWT(string, object, true);
    }

    private void callOnWindowFromAWT(String string, Object object, boolean bl) {
        Method method = null;
        Method[] methodArray = ResultView.class.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray;
            Method method2 = methodArray[i];
            if (!method2.getName().equals(string) || (classArray = method2.getParameterTypes()).length != 1) continue;
            Class<?> clazz = classArray[0];
            if (!(object == null && !clazz.isPrimitive() || clazz == Integer.TYPE && object instanceof Integer) && !classArray[0].isInstance(object)) continue;
            method = method2;
        }
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(method, new Object[]{object}, bl);
    }

    private void callOnWindowFromAWT(Method method, Object[] objectArray) {
        this.callOnWindowFromAWT(method, objectArray, true);
    }

    private void callOnWindowFromAWT(final Method method, final Object[] objectArray, boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                ResultView resultView = ResultView.getInstance();
                try {
                    method.invoke((Object)resultView, objectArray);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else if (bl) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify((Throwable)invocationTargetException);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    void searchWindowOpened() {
        this.searchWindowOpen = true;
    }

    void searchWindowClosed() {
        assert (EventQueue.isDispatchThread());
        this.searchWindowOpen = false;
        if (this.moduleBeingUninstalled) {
            return;
        }
        Runnable[] runnableArray = this.currentTasks.toArray(new Runnable[this.currentTasks.size()]);
        for (int i = 0; i < runnableArray.length; ++i) {
            if (!(runnableArray[i] instanceof SearchTask)) continue;
            SearchTask searchTask = (SearchTask)runnableArray[i];
            searchTask.stop(true);
            this.scheduleCleanTask(new CleanTask(searchTask.getResultModel()));
        }
    }

    private void processNextPendingTask() {
        Runnable[] runnableArray = this.pendingTasks.toArray(new Runnable[this.pendingTasks.size()]);
        for (int i = 0; i < runnableArray.length; ++i) {
            boolean bl = this.haveRunningReplaceTask();
            if (runnableArray[i] instanceof SearchTask) {
                if (!this.stoppingTasks.isEmpty()) {
                    this.notifySearchPending((SearchTask)runnableArray[i], 1);
                    continue;
                }
                if (bl) {
                    this.notifySearchPending((SearchTask)runnableArray[i], 8);
                    continue;
                }
                if (!this.pendingTasks.remove(runnableArray[i])) continue;
                this.startSearching((SearchTask)runnableArray[i]);
                continue;
            }
            if (runnableArray[i] instanceof ReplaceTask) {
                if (bl || this.haveRunningSearchTask() || !this.pendingTasks.remove(runnableArray[i])) continue;
                this.startReplacing((ReplaceTask)runnableArray[i]);
                continue;
            }
            if (runnableArray[i] instanceof PrintDetailsTask) {
                if (!this.pendingTasks.remove(runnableArray[i])) continue;
                this.startPrintingDetails((PrintDetailsTask)runnableArray[i]);
                continue;
            }
            if (runnableArray[i] instanceof CleanTask) {
                if (!this.pendingTasks.remove(runnableArray[i])) continue;
                this.startCleaning((CleanTask)runnableArray[i]);
                continue;
            }
            assert (false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveRunningReplaceTask() {
        List<Runnable> list = this.currentTasks;
        synchronized (list) {
            ListIterator<Runnable> listIterator = this.currentTasks.listIterator();
            while (listIterator.hasNext()) {
                if (!(listIterator.next() instanceof ReplaceTask)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveRunningSearchTask() {
        List<Runnable> list = this.currentTasks;
        synchronized (list) {
            ListIterator<Runnable> listIterator = this.currentTasks.listIterator();
            while (listIterator.hasNext()) {
                if (!(listIterator.next() instanceof SearchTask)) continue;
                return true;
            }
        }
        return false;
    }

    private void startSearching(SearchTask searchTask) {
        this.notifySearchStarted(searchTask);
        if (this.outputWriterRef != null) {
            SearchDisplayer.clearOldOutput(this.outputWriterRef);
            this.outputWriterRef = null;
            this.activateResultWindow();
        }
        this.runTask(searchTask);
    }

    private void startReplacing(ReplaceTask replaceTask) {
        this.runTask(replaceTask);
    }

    private void startPrintingDetails(PrintDetailsTask printDetailsTask) {
        if (this.outputWriterRef != null) {
            SearchDisplayer.clearOldOutput(this.outputWriterRef);
            this.outputWriterRef = null;
        }
        this.runTask(printDetailsTask);
    }

    private void startCleaning(CleanTask cleanTask) {
        this.runTask(cleanTask);
    }

    private void runTask(Runnable runnable) {
        assert (runnable != null);
        this.currentTasks.add(runnable);
        RequestProcessor.Task task = RequestProcessor.getDefault().create(runnable);
        this.tasksMap.put((Task)task, runnable);
        task.addTaskListener(this.getTaskListener());
        task.schedule(0);
    }

    void stopSearching(SearchTask searchTask) {
        if (this.pendingTasks.remove(searchTask)) {
            this.notifySearchCancelled(searchTask);
        } else if (this.currentTasks.contains(searchTask)) {
            this.stoppingTasks.add(searchTask);
            searchTask.stop();
        }
    }

    private void taskFinished(Runnable runnable) {
        if (this.moduleBeingUninstalled) {
            this.allTasksFinished();
            return;
        }
        if (runnable instanceof SearchTask) {
            SearchTask searchTask = (SearchTask)runnable;
            this.stoppingTasks.remove(runnable);
            if (searchTask.notifyWhenFinished()) {
                if (searchTask.wasInterrupted()) {
                    this.notifySearchInterrupted(searchTask);
                } else {
                    this.notifySearchFinished(searchTask);
                }
            }
        } else if (runnable instanceof ReplaceTask) {
            ReplaceTask replaceTask = (ReplaceTask)runnable;
            this.notifyReplaceFinished(replaceTask);
        } else if (runnable instanceof PrintDetailsTask) {
            PrintDetailsTask printDetailsTask = (PrintDetailsTask)runnable;
            this.notifyPrintingDetailsFinished();
            this.outputWriterRef = printDetailsTask.getOutputWriterRef();
        }
        this.currentTasks.remove(runnable);
        this.processNextPendingTask();
    }

    private void allTasksFinished() {
    }

    void doCleanup() {
        this.moduleBeingUninstalled = true;
        this.pendingTasks.clear();
        ListIterator<Runnable> listIterator = this.currentTasks.listIterator();
        while (listIterator.hasNext()) {
            Runnable runnable = listIterator.next();
            if (runnable instanceof SearchTask) {
                ((SearchTask)runnable).stop();
                continue;
            }
            if (!(runnable instanceof PrintDetailsTask)) continue;
            ((PrintDetailsTask)runnable).stop();
        }
        this.callOnWindowFromAWT("closeResults");
    }

    private TaskListener getTaskListener() {
        if (this.taskListener == null) {
            this.taskListener = new MyTaskListener();
        }
        return this.taskListener;
    }

    private class MyTaskListener
    implements TaskListener {
        MyTaskListener() {
        }

        public void taskFinished(Task task) {
            Runnable runnable = (Runnable)Manager.this.tasksMap.remove(task);
            if (runnable != null) {
                Manager.this.taskFinished(runnable);
            }
        }
    }
}

