/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.Baseline;
import org.jdesktop.layout.LayoutStyle;

class ButtonWithExtraInfo
extends JRadioButton {
    private String extraInfo;
    private JLabel lblInfo;
    private JLabel lblStart;
    private JLabel lblEnd;
    private boolean infoVisible;
    private Dimension infoPrefSize;
    private int infoBaseline = -1;
    private int infoGap = -1;
    private int startWidth = 0;
    private int endWidth = 0;

    public ButtonWithExtraInfo(String string) {
        this.extraInfo = string;
    }

    private void checkInfoLabel() {
        if (this.lblInfo == null && this.extraInfo != null) {
            this.lblInfo = new JLabel(this.extraInfo);
            this.lblStart = new JLabel("(");
            this.lblEnd = new JLabel(")");
            boolean bl = this.isEnabled();
            this.lblInfo.setEnabled(bl);
            this.lblStart.setEnabled(bl);
            this.lblEnd.setEnabled(bl);
        }
    }

    private void checkInfoGap() {
        if (this.infoGap == -1) {
            this.checkInfoLabel();
            this.infoGap = LayoutStyle.getSharedInstance().getPreferredGap((JComponent)this, (JComponent)this.lblInfo, 0, 3, this.getParent());
            this.startWidth = this.lblStart.getPreferredSize().width;
            this.endWidth = this.lblEnd.getPreferredSize().width;
        }
    }

    private void checkInfoPrefSize() {
        if (this.infoPrefSize == null) {
            this.infoPrefSize = this.lblInfo.getPreferredSize();
            this.infoBaseline = Baseline.getBaseline((JComponent)this.lblInfo, (int)this.infoPrefSize.width, (int)this.infoPrefSize.height);
        }
    }

    public void doLayout() {
        super.doLayout();
        if (this.extraInfo == null) {
            return;
        }
        this.infoVisible = false;
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width > dimension2.width) {
            int n = dimension.width - dimension2.width;
            this.checkInfoGap();
            if (n > this.infoGap + this.startWidth + this.endWidth) {
                this.infoVisible = true;
                Insets insets = this.getInsets();
                this.checkInfoPrefSize();
                assert (this.infoBaseline != -1);
                int n2 = dimension2.width - insets.right + this.infoGap;
                int n3 = Baseline.getBaseline((JComponent)this, (int)dimension.width, (int)dimension.height) - this.infoBaseline;
                int n4 = Math.min(n - this.infoGap - (this.startWidth + this.endWidth), this.infoPrefSize.width);
                int n5 = this.infoPrefSize.height;
                this.lblInfo.setBounds(n2, n3, n4, n5);
                this.lblStart.setSize(this.startWidth, n5);
                this.lblEnd.setSize(this.endWidth, n5);
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.infoVisible) {
            return;
        }
        Point point = this.lblInfo.getLocation();
        graphics.translate(point.x, point.y);
        this.lblStart.paint(graphics);
        graphics.translate(this.startWidth, 0);
        Shape shape = graphics.getClip();
        graphics.setClip(0, 0, this.lblInfo.getWidth(), this.lblInfo.getHeight());
        this.lblInfo.paint(graphics);
        graphics.setClip(shape);
        graphics.translate(this.lblInfo.getWidth(), 0);
        this.lblEnd.paint(graphics);
        graphics.translate(-(point.x + this.startWidth + this.lblInfo.getWidth()), -point.y);
    }
}

