/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.QmakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QtInfoProvider {
    private static final QtInfoProvider DEFAULT = new Default();
    private static final Logger LOGGER = Logger.getLogger(QtInfoProvider.class.getName());

    private QtInfoProvider() {
    }

    public static QtInfoProvider getDefault() {
        return DEFAULT;
    }

    public abstract List<String> getQtIncludeDirectories(MakeConfiguration var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Default
    extends QtInfoProvider {
        private final Map<String, String> cache = new HashMap<String, String>();

        private Default() {
        }

        @Override
        public List<String> getQtIncludeDirectories(MakeConfiguration makeConfiguration) {
            List<String> list;
            String string = this.getBaseQtIncludeDir(makeConfiguration);
            if (string != null) {
                String string2;
                list = new ArrayList();
                list.add(string);
                QmakeConfiguration qmakeConfiguration = makeConfiguration.getQmakeConfiguration();
                if (qmakeConfiguration.isCoreEnabled().getValue()) {
                    list.add(string + File.separator + "QtCore");
                }
                if (qmakeConfiguration.isGuiEnabled().getValue()) {
                    list.add(string + File.separator + "QtGui");
                }
                if (qmakeConfiguration.isNetworkEnabled().getValue()) {
                    list.add(string + File.separator + "QtNetwork");
                }
                if (qmakeConfiguration.isOpenglEnabled().getValue()) {
                    list.add(string + File.separator + "QtOpenGL");
                }
                if (qmakeConfiguration.isPhononEnabled().getValue()) {
                    list.add(string + File.separator + "phonon");
                }
                if (qmakeConfiguration.isQt3SupportEnabled().getValue()) {
                    list.add(string + File.separator + "Qt3Support");
                }
                if (qmakeConfiguration.isSqlEnabled().getValue()) {
                    list.add(string + File.separator + "QtSql");
                }
                if (qmakeConfiguration.isSvgEnabled().getValue()) {
                    list.add(string + File.separator + "QtSvg");
                }
                if (qmakeConfiguration.isXmlEnabled().getValue()) {
                    list.add(string + File.separator + "QtXml");
                }
                if (qmakeConfiguration.isWebkitEnabled().getValue()) {
                    list.add(string + File.separator + "QtWebKit");
                }
                if (IpeUtils.isPathAbsolute((String)(string2 = qmakeConfiguration.getUiDir().getValue()))) {
                    list.add(string2);
                } else {
                    list.add(makeConfiguration.getBaseDir() + File.separator + string2);
                }
            } else {
                list = Collections.emptyList();
            }
            return list;
        }

        private static String getQmakePath(MakeConfiguration makeConfiguration) {
            Tool tool;
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet != null && (tool = compilerSet.getTool(7)) != null && 0 < tool.getPath().length()) {
                return tool.getPath();
            }
            return "qmake";
        }

        private static String getCacheKey(MakeConfiguration makeConfiguration) {
            return makeConfiguration.getDevelopmentHost().getHostKey() + '/' + Default.getQmakePath(makeConfiguration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getBaseQtIncludeDir(MakeConfiguration makeConfiguration) {
            String string;
            String string2 = Default.getCacheKey(makeConfiguration);
            Map<String, String> map = this.cache;
            synchronized (map) {
                if (this.cache.containsKey(string2)) {
                    string = this.cache.get(string2);
                } else {
                    ExecutionEnvironment executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
                    String string3 = Default.getQmakePath(makeConfiguration);
                    if (ConnectionManager.getInstance().isConnectedTo(executionEnvironment)) {
                        string = Default.queryBaseQtIncludeDir(executionEnvironment, string3);
                        if (string != null && executionEnvironment.isRemote()) {
                            string = BasicCompiler.getIncludeFilePrefix((ExecutionEnvironment)executionEnvironment) + string;
                        }
                        this.cache.put(string2, string);
                    } else {
                        string = BasicCompiler.getIncludeFilePrefix((ExecutionEnvironment)executionEnvironment) + Default.guessBaseQtIncludeDir(string3);
                    }
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Qt include dir for {0} = {1}", new Object[]{string2, string});
            }
            return string;
        }

        private static String queryBaseQtIncludeDir(ExecutionEnvironment executionEnvironment, String string) {
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment);
            nativeProcessBuilder.setExecutable(string);
            nativeProcessBuilder.setArguments(new String[]{"-query", "QT_INSTALL_HEADERS"});
            try {
                NativeProcess nativeProcess = nativeProcessBuilder.call();
                String string2 = ProcessUtils.readProcessOutputLine((Process)nativeProcess).trim();
                if (nativeProcess.waitFor() == 0 && 0 < string2.length()) {
                    return string2;
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.INFO, null, interruptedException);
            }
            return null;
        }

        private static String guessBaseQtIncludeDir(String string) {
            String string2;
            String string3 = IpeUtils.getDirName((String)string);
            if (string3 != null && (string2 = IpeUtils.getDirName((String)string3)) != null) {
                return string2 + "/include/qt4";
            }
            return "/usr/include/qt4";
        }
    }
}

