/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.form.project.FormClassLoader;
import org.netbeans.modules.form.project.ProjectClassLoader;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathUtils {
    private static Map<Project, FormClassLoader> loaders = new WeakHashMap<Project, FormClassLoader>();
    static final ClassLoadingType SYSTEM_CLASS = new ClassLoadingType("system");
    static final ClassLoadingType SYSTEM_CLASS_WITH_PROJECT = new ClassLoadingType("system_with_project");
    private static final ClassLoadingType[] CLASS_LOADING_TYPES = new ClassLoadingType[]{SYSTEM_CLASS, SYSTEM_CLASS_WITH_PROJECT};
    private static final String CL_LAYER_BASE = "org-netbeans-modules-form/classloader/";

    public static Class<?> loadClass(String string, FileObject fileObject) throws ClassNotFoundException {
        return Class.forName(string, true, ClassPathUtils.getFormClassLoader(fileObject));
    }

    public static boolean checkUserClass(String string, FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        if (classPath == null) {
            return false;
        }
        String string2 = string.replace('.', '/').concat(".class");
        return classPath.findResource(string2) != null;
    }

    public static void resetFormClassLoader(Project project) {
        loaders.remove(project);
    }

    private static FormClassLoader getFormClassLoader(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FormClassLoader formClassLoader = loaders.get(project);
        ClassLoader classLoader = formClassLoader != null ? formClassLoader.getProjectClassLoader() : null;
        ClassLoader classLoader2 = ProjectClassLoader.getUpToDateClassLoader(fileObject, classLoader);
        if (formClassLoader == null || classLoader2 != classLoader) {
            formClassLoader = new FormClassLoader(classLoader2);
            loaders.put(project, formClassLoader);
        }
        return formClassLoader;
    }

    public static ClassLoader getProjectClassLoader(FileObject fileObject) {
        return ClassPathUtils.getFormClassLoader(fileObject).getProjectClassLoader();
    }

    static ClassLoadingType getClassLoadingType(String string) {
        int n = string.lastIndexOf("[L");
        if (n != -1) {
            string = string.substring(n + 2, string.length() - 1);
        }
        for (ClassLoadingType classLoadingType : CLASS_LOADING_TYPES) {
            if (!ClassPathUtils.isClassLoadingType(string, classLoadingType)) continue;
            return classLoadingType;
        }
        return null;
    }

    public static Class loadClass(ClassSource classSource) throws ClassNotFoundException {
        String string = classSource.getClassName();
        if (string == null) {
            return null;
        }
        ClassLoader classLoader = null;
        if (!classSource.hasEntries()) {
            classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        } else {
            try {
                List<URL> list = classSource.getClasspath();
                if (list.size() <= 0) {
                    return null;
                }
                URL[] uRLArray = new URL[list.size()];
                list.toArray(uRLArray);
                classLoader = ClassPathSupport.createClassPath((URL[])uRLArray).getClassLoader(true);
            }
            catch (Exception exception) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, (Throwable)exception);
                throw illegalArgumentException;
            }
        }
        return classLoader.loadClass(classSource.getClassName());
    }

    public static ClassSource getProjectClassSource(FileObject fileObject, String string) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        AntArtifact[] antArtifactArray = AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar");
        if (antArtifactArray.length == 0) {
            return null;
        }
        for (AntArtifact antArtifact : antArtifactArray) {
            ClassSource.ProjectEntry projectEntry = new ClassSource.ProjectEntry(antArtifact);
            for (URL uRL : ((ClassSource.Entry)projectEntry).getClasspath()) {
                for (FileObject fileObject2 : SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots()) {
                    if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                    return new ClassSource(string, projectEntry);
                }
            }
        }
        if (!fileObject.getExt().equals("class")) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (AntArtifact antArtifact : antArtifactArray) {
            ClassSource.ProjectEntry projectEntry = new ClassSource.ProjectEntry(antArtifact);
            arrayList.add(projectEntry);
        }
        return new ClassSource(string, arrayList);
    }

    public static boolean isOnClassPath(FileObject fileObject, String string) {
        String string2 = string.replace('.', '/') + ".class";
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        if (classPath == null) {
            return false;
        }
        return classPath.findResource(string2) != null;
    }

    public static boolean isJava6ProjectPlatform(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        if (classPath == null) {
            return false;
        }
        return classPath.findResource("javax/swing/GroupLayout.class") != null;
    }

    public static Boolean updateProject(FileObject fileObject, ClassSource classSource) throws IOException {
        if (!classSource.hasEntries()) {
            return Boolean.FALSE;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return Boolean.FALSE;
        }
        return classSource.addToProjectClassPath(fileObject, "classpath/compile");
    }

    public static String getClassSourceDescription(ClassSource classSource) {
        if (classSource == null || !classSource.hasEntries()) {
            String string = classSource.getClassName();
            if (string != null) {
                if (string.startsWith("javax.") || string.startsWith("java.")) {
                    return ClassPathUtils.getBundleString("MSG_StandardJDKSource");
                }
                if (string.startsWith("org.netbeans.")) {
                    return ClassPathUtils.getBundleString("MSG_NetBeansSource");
                }
            }
            return NbBundle.getMessage(ClassPathUtils.class, (String)"MSG_UnspecifiedSource");
        }
        return classSource.getEntries().iterator().next().getDisplayName();
    }

    static String getBundleString(String string) {
        return NbBundle.getBundle(ClassPathUtils.class).getString(string);
    }

    private static boolean isClassLoadingType(String string, ClassLoadingType classLoadingType) {
        List<ClassPattern> list = ClassPathUtils.getClassPatterns(classLoadingType);
        if (list == null) {
            return false;
        }
        for (ClassPattern classPattern : list) {
            switch (classPattern.type) {
                case 0: {
                    if (!string.equals(classPattern.name)) break;
                    return true;
                }
                case 1: {
                    if (!string.startsWith(classPattern.name) || string.lastIndexOf(46) > classPattern.name.length()) break;
                    return true;
                }
                case 2: {
                    if (!string.startsWith(classPattern.name)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static List<ClassPattern> getClassPatterns(ClassLoadingType classLoadingType) {
        List<ClassPattern> list = classLoadingType.patterns;
        if (list == null) {
            list = ClassPathUtils.loadClassPatterns(ClassPathUtils.getClassPatternsFolder(classLoadingType));
            classLoadingType.patterns = list;
        }
        return list;
    }

    private static FileObject getClassPatternsFolder(final ClassLoadingType classLoadingType) {
        FileObject fileObject = classLoadingType.folder;
        if (fileObject == null) {
            fileObject = ClassPathUtils.getClassPatternsFolder(classLoadingType.folderName);
            if (fileObject == null) {
                return null;
            }
            classLoadingType.folder = fileObject;
            fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fileEvent) {
                    classLoadingType.patterns = null;
                    loaders.clear();
                }

                public void fileDeleted(FileEvent fileEvent) {
                    classLoadingType.patterns = null;
                    if (fileEvent.getFile() == classLoadingType.folder) {
                        classLoadingType.folder.removeFileChangeListener((FileChangeListener)this);
                        classLoadingType.folder = null;
                    }
                    loaders.clear();
                }
            });
        }
        return fileObject;
    }

    private static FileObject getClassPatternsFolder(String string) {
        FileObject fileObject = null;
        if (string != null) {
            try {
                fileObject = FileUtil.getConfigFile((String)(CL_LAYER_BASE + string));
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return fileObject;
    }

    private static List<ClassPattern> loadClassPatterns(FileObject fileObject) {
        ArrayList<ClassPattern> arrayList = new ArrayList<ClassPattern>();
        if (fileObject == null) {
            return arrayList;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObjectArray[i].getInputStream()));
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (!(string = string.trim()).equals("")) {
                        ClassPattern classPattern = string.endsWith("**") ? new ClassPattern(string.substring(0, string.length() - 2), 2) : (string.endsWith("*") ? new ClassPattern(string.substring(0, string.length() - 1), 1) : new ClassPattern(string, 0));
                        arrayList.add(classPattern);
                    }
                    string = bufferedReader.readLine();
                }
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return arrayList;
    }

    private static class ClassPattern {
        static final int CLASS = 0;
        static final int PACKAGE = 1;
        static final int PACKAGE_AND_SUBPACKAGES = 2;
        String name;
        int type;

        ClassPattern(String string, int n) {
            this.name = string;
            this.type = n;
        }
    }

    static class ClassLoadingType {
        private String folderName;
        private FileObject folder;
        private List<ClassPattern> patterns;

        private ClassLoadingType(String string) {
            this.folderName = string;
        }
    }
}

