/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.im.InputMethodRequests;
import org.netbeans.modules.form.fakepeer.FakeComponentPeer;
import org.netbeans.modules.form.fakepeer.FakePeerUtils;

class FakeTextComponentPeer
extends FakeComponentPeer {
    private String _text;
    private int _caretPosition = 0;
    private int selStart = -1;
    private int selEnd = -1;

    FakeTextComponentPeer(TextComponent textComponent) {
        super(textComponent);
    }

    Component createDelegate() {
        return new Delegate();
    }

    void initDelegate() {
        this._text = ((TextComponent)this._target).getText();
        super.initDelegate();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setEditable(boolean bl) {
        this.repaint();
    }

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        this._text = string;
        this.repaint();
    }

    public int getSelectionStart() {
        return this.selStart;
    }

    public int getSelectionEnd() {
        return this.selEnd;
    }

    public void select(int n, int n2) {
        this.selStart = n;
        this.selEnd = n2;
    }

    public void setCaretPosition(int n) {
        if (n == 0 || this._text != null && this._text.length() > n) {
            this._caretPosition = n;
        }
    }

    public int getCaretPosition() {
        return this._caretPosition;
    }

    public int getIndexAtPoint(int n, int n2) {
        return 0;
    }

    public Rectangle getCharacterBounds(int n) {
        return null;
    }

    public long filterEvents(long l) {
        return 0L;
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    protected class Delegate
    extends Component {
        Delegate() {
            this.setBackground(SystemColor.window);
            this.setForeground(SystemColor.windowText);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = FakeTextComponentPeer.this._target.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            graphics.setColor(FakeTextComponentPeer.this._target.getBackground());
            FakePeerUtils.drawLoweredBox(graphics, 0, 0, n, n2);
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.x < 1) {
                rectangle.x = 1;
            }
            if (rectangle.y < 1) {
                rectangle.y = 1;
            }
            if (rectangle.width > n - 3) {
                rectangle.width = n - 3;
            }
            if (rectangle.height > n2 - 3) {
                rectangle.height = n2 - 3;
            }
            graphics.setClip(rectangle);
            if (FakeTextComponentPeer.this._target.isEnabled()) {
                graphics.setColor(FakeTextComponentPeer.this._target.getForeground());
            } else {
                graphics.setColor(SystemColor.controlShadow);
            }
        }
    }
}

