/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.editors2.SpinnerModelEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SpinnerEditorEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
NamedPropertyEditor,
FormAwareEditor {
    private boolean initialized;
    private boolean fireChanges;
    private FormProperty property;
    private JPanel customizerPanel;
    private JTextField formatField;
    private JLabel formatLabel;
    private JComboBox typeCombo;
    private JLabel typeLabel;
    private static final String XML_SPINNER_EDITOR = "SpinnerEditor";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_FORMAT = "format";

    private void initGUI() {
        this.initialized = true;
        this.initComponents();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(this.typeToString(0));
        defaultComboBoxModel.addElement(this.typeToString(1));
        defaultComboBoxModel.addElement(this.typeToString(2));
        defaultComboBoxModel.addElement(this.typeToString(3));
        this.typeCombo.setModel(defaultComboBoxModel);
    }

    private int stringToType(String string) {
        int n = -1;
        if (NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Default").equals(string)) {
            n = 0;
        } else if (NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Date").equals(string)) {
            n = 1;
        } else if (NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_List").equals(string)) {
            n = 2;
        } else if (NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Number").equals(string)) {
            n = 3;
        }
        return n;
    }

    private String typeToString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Default");
                break;
            }
            case 1: {
                string = NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Date");
                break;
            }
            case 2: {
                string = NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_List");
                break;
            }
            case 3: {
                string = NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Number");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return string;
    }

    public String getAsText() {
        String string = null;
        Object object = this.getValue();
        if (object instanceof FormSpinnerEditor) {
            FormSpinnerEditor formSpinnerEditor = (FormSpinnerEditor)object;
            string = this.typeToString(formSpinnerEditor.getType());
            String string2 = formSpinnerEditor.getFormat();
            if (string2 != null) {
                string = string + " " + string2;
            }
        } else {
            string = this.typeToString(0);
        }
        return string;
    }

    public void setAsText(String string) {
        String string2;
        String string3;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n = string.indexOf(32);
        if (n == -1) {
            string3 = string;
            string2 = null;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        int n2 = this.stringToType(string3);
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        if (n2 != 0) {
            FormSpinnerEditor formSpinnerEditor = new FormSpinnerEditor(this.property, n2, string2);
            this.setValue(formSpinnerEditor);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Object object;
        this.fireChanges = false;
        if (!this.initialized) {
            this.initGUI();
        }
        if ((object = this.getValue()) instanceof FormSpinnerEditor) {
            FormSpinnerEditor formSpinnerEditor = (FormSpinnerEditor)object;
            this.typeCombo.setSelectedIndex(formSpinnerEditor.getType());
            String string = formSpinnerEditor.getFormat();
            if (string != null) {
                this.formatField.setText(string);
            }
        } else {
            this.typeCombo.setSelectedIndex(0);
        }
        this.fireChanges = true;
        return this.customizerPanel;
    }

    private void initComponents() {
        this.customizerPanel = new JPanel();
        this.typeLabel = new JLabel();
        this.typeCombo = new JComboBox();
        this.formatLabel = new JLabel();
        this.formatField = new JTextField();
        this.typeLabel.setText(NbBundle.getMessage(SpinnerEditorEditor.class, (String)"LBL_SpinnerEditorEditor_Type"));
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpinnerEditorEditor.this.typeComboActionPerformed(actionEvent);
            }
        });
        this.formatLabel.setText(NbBundle.getMessage(SpinnerEditorEditor.class, (String)"LBL_SpinnerEditorEditor_Format"));
        this.formatField.setColumns(15);
        this.formatField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SpinnerEditorEditor.this.formatFieldFocusLost(focusEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.customizerPanel);
        this.customizerPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.typeLabel).add((Component)this.formatLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.typeCombo, 0, 126, Short.MAX_VALUE).add((Component)this.formatField)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.typeLabel).add((Component)this.typeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.formatLabel).add((Component)this.formatField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void formatFieldFocusLost(FocusEvent focusEvent) {
        this.updateValueFromUI();
    }

    private void typeComboActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        int n = this.typeCombo.getSelectedIndex();
        boolean bl2 = bl = n % 2 == 1;
        if (bl != this.formatField.isEditable()) {
            this.formatField.setText("");
            this.formatField.setEditable(bl);
        }
        this.updateValueFromUI();
    }

    private void updateValueFromUI() {
        if (!this.fireChanges) {
            return;
        }
        Object object = this.valueFromUI();
        if (object == null) {
            object = this.property.getDefaultValue();
        }
        this.updateModelProperty(object);
        this.setValue(object);
    }

    private void updateModelProperty(Object object) {
        RADProperty rADProperty;
        RADProperty rADProperty2;
        if (object instanceof FormSpinnerEditor && this.property instanceof RADProperty && (rADProperty2 = (RADProperty)(rADProperty = (RADProperty)this.property).getRADComponent().getPropertyByName("model")) != null) {
            try {
                Object object2 = rADProperty2.getRealValue();
                FormSpinnerEditor formSpinnerEditor = (FormSpinnerEditor)object;
                int n = formSpinnerEditor.getType();
                if (n == 1 && !(object2 instanceof SpinnerDateModel)) {
                    SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
                    rADProperty2.setValue(new SpinnerModelEditor.FormSpinnerModel(spinnerDateModel, spinnerDateModel.getValue(), true, false, false));
                } else if (n == 3 && !(object2 instanceof SpinnerNumberModel)) {
                    SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
                    rADProperty2.setValue(new SpinnerModelEditor.FormSpinnerModel(spinnerNumberModel, spinnerNumberModel.getValue()));
                } else if (n == 2 && !(object2 instanceof SpinnerListModel)) {
                    SpinnerListModel spinnerListModel = new SpinnerListModel();
                    rADProperty2.setValue(new SpinnerModelEditor.FormSpinnerModel(spinnerListModel, spinnerListModel.getValue()));
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
            }
        }
    }

    private FormSpinnerEditor valueFromUI() {
        FormSpinnerEditor formSpinnerEditor;
        int n = this.typeCombo.getSelectedIndex();
        if (n == 0) {
            formSpinnerEditor = null;
        } else {
            String string = this.formatField.getText();
            if (n % 2 == 0) {
                string = null;
            }
            formSpinnerEditor = new FormSpinnerEditor(this.property, n, string);
        }
        return formSpinnerEditor;
    }

    public void readFromXML(Node node) throws IOException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem(ATTR_TYPE).getNodeValue();
        int n = Integer.parseInt(string);
        Node node2 = namedNodeMap.getNamedItem(ATTR_FORMAT);
        String string2 = null;
        if (node2 != null) {
            string2 = node2.getNodeValue();
        }
        this.setValue(new FormSpinnerEditor(this.property, n, string2));
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_SPINNER_EDITOR);
        Object object = this.getValue();
        if (!(object instanceof FormSpinnerEditor)) {
            element.setAttribute(ATTR_TYPE, "0");
        } else {
            FormSpinnerEditor formSpinnerEditor = (FormSpinnerEditor)object;
            element.setAttribute(ATTR_TYPE, "" + formSpinnerEditor.getType());
            String string = formSpinnerEditor.getFormat();
            if (string != null) {
                element.setAttribute(ATTR_FORMAT, formSpinnerEditor.getFormat());
            }
        }
        return element;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"CTL_SpinnerEditorEditor_DisplayName");
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.property = formProperty;
    }

    public void updateFormVersionLevel() {
        this.property.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
    }

    public String getJavaInitializationString() {
        Object object = this.getValue();
        if (!(object instanceof FormSpinnerEditor)) {
            return super.getJavaInitializationString();
        }
        FormSpinnerEditor formSpinnerEditor = (FormSpinnerEditor)object;
        CodeVariable codeVariable = formSpinnerEditor.getProperty().getRADComponent().getCodeExpression().getVariable();
        int n = formSpinnerEditor.getType();
        String string = null;
        switch (n) {
            case 1: {
                String string2 = formSpinnerEditor.getFormat().replace("\"", "\\\"");
                string = "new javax.swing.JSpinner.DateEditor(" + codeVariable.getName() + ", \"" + string2 + "\")";
                break;
            }
            case 2: {
                string = "new javax.swing.JSpinner.ListEditor(" + codeVariable.getName() + ")";
                break;
            }
            case 3: {
                String string3 = formSpinnerEditor.getFormat().replace("\"", "\\\"");
                string = "new javax.swing.JSpinner.NumberEditor(" + codeVariable.getName() + ", \"" + string3 + "\")";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return string;
    }

    static class FormSpinnerEditor
    extends FormDesignValueAdapter {
        public static final int TYPE_DEFAULT = 0;
        public static final int TYPE_DATE = 1;
        public static final int TYPE_LIST = 2;
        public static final int TYPE_NUMBER = 3;
        private int type;
        private String format;
        private RADProperty property;

        FormSpinnerEditor(FormProperty formProperty, int n, String string) {
            this.property = (RADProperty)formProperty;
            this.type = n;
            this.format = string;
        }

        public int getType() {
            return this.type;
        }

        public String getFormat() {
            return this.format;
        }

        RADProperty getProperty() {
            return this.property;
        }

        public Object getDesignValue() {
            Object object = null;
            switch (this.type) {
                case 0: {
                    object = this.property.getDefaultValue();
                    break;
                }
                case 1: {
                    object = new JSpinner.DateEditor((JSpinner)this.property.getRADComponent().getBeanInstance(), this.format);
                    break;
                }
                case 2: {
                    object = new JSpinner.ListEditor((JSpinner)this.property.getRADComponent().getBeanInstance());
                    break;
                }
                case 3: {
                    object = new JSpinner.NumberEditor((JSpinner)this.property.getRADComponent().getBeanInstance(), this.format);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return object;
        }

        public Object copy(FormProperty formProperty) {
            return new FormSpinnerEditor(formProperty, this.type, this.format);
        }
    }
}

