/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PrimitiveTypeArrayEditor
extends PropertyEditorSupport
implements FormAwareEditor,
XMLPropertyEditor {
    private Class valueType;
    private FormProperty formProperty;
    private static String ARR_BEGIN = "[";
    private static String ARR_END = "]";
    private static String NULL_STR = "null";
    private static String XML_PROP_NAME = "PropertyValue";
    private static String XML_ATT_NAME = "value";
    private char[] escChars = new char[]{'\t', '\b', '\n', '\r', '\f', '\'', '\"', '\\'};
    private String[] escCharsStr = new String[]{"\\t", "\\b", "\\n", "\\r", "\\f", "\\'", "\\\"", "\\\\"};

    private String[] splitCharArray(String string) {
        boolean bl = false;
        String string2 = "";
        int n = 32;
        int n2 = 32;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'' && n != 92) {
                if (!bl) {
                    bl = true;
                    string2 = "";
                } else {
                    bl = false;
                    arrayList.add(string2);
                    string2 = "";
                }
            } else if (c == '\'' && n == 92 && n2 == 92) {
                bl = false;
                arrayList.add(string2);
                string2 = "";
            } else if (bl) {
                string2 = string2 + c;
            }
            n2 = n;
            n = c;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Object[] toCharObjectArray(Object object) {
        char[] cArray = (char[])object;
        Object[] objectArray = new String[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            objectArray[i] = new String(this.convertChar2String(cArray[i]));
        }
        return objectArray;
    }

    private String convertChar2String(char c) {
        for (int i = 0; i < this.escChars.length; ++i) {
            if (c != this.escChars[i]) continue;
            return "'" + this.escCharsStr[i] + "'";
        }
        return "'" + String.valueOf(c) + "'";
    }

    private char convertString2Char(String string) throws ParseException {
        if (string.length() > 1) {
            for (int i = 0; i < this.escCharsStr.length; ++i) {
                if (!string.equals(this.escCharsStr[i])) continue;
                return this.escChars[i];
            }
            throw new ParseException("", 0);
        }
        if (string.length() == 1) {
            return string.charAt(0);
        }
        throw new ParseException("", 0);
    }

    private String arr2Text(Object[] objectArray, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            stringBuilder.append(ARR_BEGIN);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object);
            if (bl && this.valueType.equals(float[].class)) {
                stringBuilder.append("f");
            }
            if (i == objectArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        if (!bl) {
            stringBuilder.append(ARR_END);
        }
        return stringBuilder.toString();
    }

    private Object text2Arr(String string) throws ParseException {
        int n;
        String[] stringArray;
        String string2 = string.trim();
        if (string2.length() == 0 || string2.toLowerCase().equals(NULL_STR)) {
            return null;
        }
        if (string.length() < 2) {
            stringArray = new String[]{};
        } else {
            int n2 = string.indexOf(ARR_BEGIN);
            if (n2 + 1 < (n = string.indexOf(ARR_END))) {
                String string3 = string.substring(string.indexOf(ARR_BEGIN) + 1, string.indexOf(ARR_END));
                stringArray = !this.valueType.equals(char[].class) ? string3.split(",") : this.splitCharArray(string3);
            } else {
                stringArray = new String[]{};
            }
        }
        if (this.valueType.equals(boolean[].class)) {
            boolean[] blArray = new boolean[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                blArray[n] = Boolean.parseBoolean(stringArray[n].trim());
            }
            return blArray;
        }
        if (this.valueType.equals(byte[].class)) {
            byte[] byArray = new byte[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                byArray[n] = Byte.parseByte(stringArray[n].trim());
            }
            return byArray;
        }
        if (this.valueType.equals(short[].class)) {
            short[] sArray = new short[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                sArray[n] = Short.parseShort(stringArray[n].trim());
            }
            return sArray;
        }
        if (this.valueType.equals(int[].class)) {
            int[] nArray = new int[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                nArray[n] = Integer.parseInt(stringArray[n].trim());
            }
            return nArray;
        }
        if (this.valueType.equals(long[].class)) {
            long[] lArray = new long[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                lArray[n] = Long.parseLong(stringArray[n].trim());
            }
            return lArray;
        }
        if (this.valueType.equals(float[].class)) {
            float[] fArray = new float[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                fArray[n] = Float.parseFloat(stringArray[n].trim());
            }
            return fArray;
        }
        if (this.valueType.equals(double[].class)) {
            double[] dArray = new double[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                dArray[n] = Double.parseDouble(stringArray[n].trim());
            }
            return dArray;
        }
        if (this.valueType.equals(char[].class)) {
            char[] cArray = new char[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                cArray[n] = this.convertString2Char(stringArray[n]);
            }
            return cArray;
        }
        return null;
    }

    public String getAsText() {
        if (this.getValue() != null) {
            Object[] objectArray = new Object[]{};
            objectArray = this.valueType.equals(char[].class) ? this.toCharObjectArray(this.getValue()) : Utilities.toObjectArray((Object)this.getValue());
            return this.arr2Text(objectArray, false);
        }
        return NULL_STR;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        try {
            this.setValue(this.text2Arr(string));
        }
        catch (Exception exception) {
            String string2 = NbBundle.getBundle(PrimitiveTypeArrayEditor.class).getString("MSG_ERR_ParseError");
            throw new IllegalArgumentException(String.format(string2, string, this.valueType.getSimpleName()), exception);
        }
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.valueType = formProperty.getValueType();
        this.formProperty = formProperty;
    }

    public void updateFormVersionLevel() {
        this.formProperty.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB65, FormModel.FormVersion.NB65);
    }

    public String getJavaInitializationString() {
        Object[] objectArray = this.valueType.equals(char[].class) ? this.toCharObjectArray(this.getValue()) : Utilities.toObjectArray((Object)this.getValue());
        return "new " + this.valueType.getSimpleName() + " {" + this.arr2Text(objectArray, true) + "}";
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_PROP_NAME.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(XML_ATT_NAME).getNodeValue();
            this.setAsText(string);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_PROP_NAME);
        element.setAttribute(XML_ATT_NAME, this.getAsText());
        return element;
    }
}

