/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormRefactoringUpdate;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RefactoringInfo {
    private AbstractRefactoring refactoring;
    private ChangeType changeType;
    private FileObject[] origFiles;
    private Map<FileObject, String> originalFiles;
    private Map<FileObject, FormRefactoringUpdate> fileToUpdateMap = new HashMap<FileObject, FormRefactoringUpdate>();

    RefactoringInfo(AbstractRefactoring abstractRefactoring, ChangeType changeType, FileObject[] fileObjectArray, String[] stringArray) {
        this.refactoring = abstractRefactoring;
        this.changeType = changeType;
        HashMap<FileObject, String> hashMap = new HashMap<FileObject, String>();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            hashMap.put(fileObjectArray[i], stringArray[i]);
        }
        this.originalFiles = Collections.unmodifiableMap(hashMap);
        this.origFiles = new FileObject[fileObjectArray.length];
        System.arraycopy(fileObjectArray, 0, this.origFiles, 0, fileObjectArray.length);
    }

    AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public boolean containsOriginalFile(FileObject fileObject) {
        return this.originalFiles.containsKey(fileObject);
    }

    public FileObject[] getOriginalFiles() {
        return this.origFiles;
    }

    String getOldName(FileObject fileObject) {
        return this.originalFiles.get(fileObject);
    }

    String getNewName() {
        return this.getNewName(null);
    }

    String getNewName(FileObject fileObject) {
        if (this.refactoring instanceof RenameRefactoring) {
            return ((RenameRefactoring)this.refactoring).getNewName();
        }
        if (this.refactoring instanceof MoveRefactoring && fileObject != null && this.containsOriginalFile(fileObject)) {
            return this.getTargetName((MoveRefactoring)this.refactoring, fileObject.getName());
        }
        return null;
    }

    private String getTargetName(MoveRefactoring moveRefactoring, String string) {
        ClassPath classPath;
        FileObject fileObject;
        URL uRL = (URL)moveRefactoring.getTarget().lookup(URL.class);
        File file = null;
        try {
            if (uRL != null) {
                file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
        LinkedList<String> linkedList = null;
        while (file != null && !file.exists()) {
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
            }
            linkedList.addFirst(file.getName());
            file = file.getParentFile();
        }
        FileObject fileObject2 = fileObject = file != null ? FileUtil.toFileObject((File)file) : null;
        if (fileObject != null && fileObject.isFolder() && (classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) != null) {
            String string2 = classPath.getResourceName(fileObject, '.', false);
            StringBuilder stringBuilder = new StringBuilder();
            if (string2 != null) {
                stringBuilder.append(string2);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('.');
                }
            }
            if (linkedList != null && !linkedList.isEmpty()) {
                for (String string3 : linkedList) {
                    stringBuilder.append(string3);
                    stringBuilder.append('.');
                }
            }
            stringBuilder.append(string);
            return stringBuilder.toString();
        }
        return null;
    }

    public FormRefactoringUpdate getUpdateForFile(FileObject fileObject) {
        FormRefactoringUpdate formRefactoringUpdate = this.fileToUpdateMap.get(fileObject);
        if (formRefactoringUpdate == null) {
            assert (RefactoringInfo.isJavaFileOfForm(fileObject));
            formRefactoringUpdate = new FormRefactoringUpdate(this, fileObject);
            this.fileToUpdateMap.put(fileObject, formRefactoringUpdate);
        }
        return formRefactoringUpdate;
    }

    static boolean isJavaFile(FileObject fileObject) {
        return "text/x-java".equals(fileObject.getMIMEType());
    }

    static boolean isJavaFileOfForm(FileObject fileObject) {
        return RefactoringInfo.isJavaFile(fileObject) && fileObject.existsExt("form");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        VARIABLE_RENAME,
        CLASS_RENAME,
        CLASS_MOVE,
        CLASS_COPY,
        CLASS_DELETE,
        PACKAGE_RENAME,
        FOLDER_RENAME,
        EVENT_HANDLER_RENAME,
        OTHER_FORM_CHANGE;

    }
}

