/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.preview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.preview.SequenceTimeSpinner;
import org.netbeans.modules.vmd.game.view.ColorConstants;
import org.netbeans.modules.vmd.game.view.ImagePreviewComponent;

public class SequencePreviewPanel
extends JPanel
implements SequenceListener,
ComponentListener,
PropertyChangeListener,
ActionListener {
    public static final boolean DEBUG = false;
    public static final Color COLOR_BORDER_PLAIN = ColorConstants.COLOR_OUTLINE_PLAIN;
    public static final Color COLOR_BORDER_SELECTED = ColorConstants.COLOR_OUTLINE_SELECTED;
    public static final Color COLOR_TEXT_PLAIN = ColorConstants.COLOR_OUTLINE_SELECTED;
    public static final Color COLOR_TEXT_SELECTED = ColorConstants.COLOR_OUTLINE_SELECTED;
    private boolean isPlaying = false;
    private boolean isPlayingForward = true;
    private int sequenceIndex;
    private DefaultComboBoxModel actionsModel = new DefaultComboBoxModel();
    private SequenceContainer sequenceContainer;
    private Sequence sequence;
    private Timer timer;
    private ImagePreviewComponent imagePreview;
    private JButton buttonPause;
    private JButton buttonPlayBackward;
    private JButton buttonPlayForward;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JLabel labelName;
    private JPanel panelSequenceAnimatedPreview;
    private JPanel panelSpinner;

    public SequencePreviewPanel(Sequence sequence) {
        this.initComponents();
        this.sequenceContainer = this.sequenceContainer;
        this.imagePreview = new ImagePreviewComponent(true, true, true);
        this.panelSequenceAnimatedPreview.add((Component)this.imagePreview, "Center");
        this.addComponentListener(this);
        this.setSequence(sequence);
        this.updateActions();
        this.buttonPlayForward.addActionListener(this);
        this.buttonPlayBackward.addActionListener(this);
        this.buttonPause.addActionListener(this);
        this.buttonPlayBackward.setBackground(this.buttonPlayBackward.getParent().getBackground());
        this.buttonPause.setBackground(this.buttonPause.getParent().getBackground());
        this.buttonPlayForward.setBackground(this.buttonPlayForward.getParent().getBackground());
        this.buttonPause.setEnabled(this.isPlaying);
    }

    public void setSequenceContainer(SequenceContainer sequenceContainer) {
        this.sequenceContainer = sequenceContainer;
        this.updateActions();
    }

    private Dimension getFrameSize() {
        if (this.sequence == null) {
            return new Dimension(10, 10);
        }
        return this.sequence.getFrameSize();
    }

    public void setSelected(boolean bl) {
        if (bl) {
            this.labelName.setForeground(ColorConstants.COLOR_TEXT_SELECTED);
        } else {
            this.labelName.setForeground(ColorConstants.COLOR_TEXT_PLAIN);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonPlayForward) {
            this.isPlaying = true;
            this.isPlayingForward = true;
        } else if (actionEvent.getSource() == this.buttonPlayBackward) {
            this.isPlaying = true;
            this.isPlayingForward = false;
        } else if (actionEvent.getSource() == this.buttonPause) {
            this.isPlaying = false;
        }
        this.buttonPause.setEnabled(this.isPlaying);
        this.buttonPlayForward.setEnabled(!this.isPlayingForward || !this.isPlaying);
        this.buttonPlayBackward.setEnabled(this.isPlayingForward || !this.isPlaying);
    }

    public void setImportant(boolean bl) {
        if (bl) {
            this.labelName.setFont(this.labelName.getFont().deriveFont(1));
        } else {
            this.labelName.setFont(this.labelName.getFont().deriveFont(0));
        }
        this.updateActions();
    }

    private void updateActions() {
        this.actionsModel.removeAllElements();
        List<Action> list = this.sequenceContainer != null ? this.sequenceContainer.getActionsForSequence(this.sequence) : this.sequence.getActions();
        for (Action action : list) {
            this.actionsModel.addElement(action);
        }
    }

    public void setSequence(Sequence sequence) {
        if (this.sequence != null) {
            this.sequence.removeSequenceListener(this);
            this.sequence.removePropertyChangeListener(this);
            this.timer.cancel();
            int n = sequence.getFrameCount() - 1;
        }
        this.sequence = sequence;
        this.labelName.setText(this.sequence.getName());
        this.labelName.setToolTipText(this.sequence.getName());
        this.panelSpinner.add((Component)new SequenceTimeSpinner(this.sequence), "Center");
        this.panelSpinner.revalidate();
        this.timer = new Timer();
        StaticTile staticTile = this.sequence.getFrame(0);
        this.imagePreview.setPreviewable(staticTile);
        this.sequence.addSequenceListener(this);
        this.timer.schedule((TimerTask)new AnimationTimerTask(), 0L, (long)this.sequence.getFrameMs());
        this.sequence.addPropertyChangeListener(this);
    }

    public void requestPreviewFrame(int n) {
        if (!this.isPlaying && this.sequence.getFrame(n) != null) {
            this.imagePreview.setPreviewable(this.sequence.getFrame(n));
        }
    }

    private void sequenceChanged() {
        this.setSequence(this.sequence);
    }

    private void incrementSequenceIndex() {
        int n = this.sequenceIndex + 1;
        this.sequenceIndex = n >= this.sequence.getFrameCount() ? 0 : n;
    }

    private void decrementSequenceIndex() {
        int n = this.sequenceIndex - 1;
        this.sequenceIndex = n < 0 ? this.sequence.getFrameCount() - 1 : n;
    }

    private void currentFrameChanged() {
    }

    private void setCurrentFrameIndex(int n) {
        StaticTile staticTile = null;
        do {
            try {
                staticTile = this.sequence.getFrame(n);
            }
            catch (Exception exception) {
                --n;
            }
        } while (staticTile == null);
        this.sequenceIndex = n;
        this.imagePreview.setPreviewable(staticTile);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.sequence) {
            if (propertyChangeEvent.getPropertyName().equals("sequence.prop.frames.ms")) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new AnimationTimerTask(), 0L, (long)this.sequence.getFrameMs());
            }
            if (propertyChangeEvent.getPropertyName().equals("sequence.prop.name")) {
                this.labelName.setText(this.sequence.getName());
            }
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void frameAdded(Sequence sequence, int n) {
        this.sequenceChanged();
    }

    public void frameRemoved(Sequence sequence, int n) {
        this.sequenceChanged();
    }

    public void framesChanged(Sequence sequence) {
        this.sequenceChanged();
    }

    public void frameModified(Sequence sequence, int n) {
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.labelName = new JLabel();
        this.jPanel4 = new JPanel();
        this.buttonPlayBackward = new JButton();
        this.buttonPause = new JButton();
        this.buttonPlayForward = new JButton();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.panelSequenceAnimatedPreview = new JPanel();
        this.jPanel8 = new JPanel();
        this.panelSpinner = new JPanel();
        this.setBorder(new LineBorder(COLOR_BORDER_PLAIN, 2, true));
        this.jPanel5.setMinimumSize(new Dimension(300, 126));
        this.jPanel5.setLayout(new GridLayout(1, 0));
        this.jPanel2.setLayout(new BorderLayout());
        this.labelName.setFont(new Font("Dialog", 1, this.labelName.getFont().getSize() + 3));
        this.labelName.setForeground(ColorConstants.COLOR_TEXT_PLAIN);
        this.labelName.setHorizontalAlignment(0);
        this.labelName.setText("<NONE>");
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.labelName, -2, 130, -2));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.labelName, -2, 106, -2));
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.jPanel4.setMaximumSize(new Dimension(174, 34));
        this.jPanel4.setLayout(new GridLayout(1, 0));
        this.buttonPlayBackward.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/sequece/resources/playrev.png")));
        this.jPanel4.add(this.buttonPlayBackward);
        this.buttonPause.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/sequece/resources/pause.gif")));
        this.jPanel4.add(this.buttonPause);
        this.buttonPlayForward.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/sequece/resources/play.png")));
        this.jPanel4.add(this.buttonPlayForward);
        this.jPanel2.add((Component)this.jPanel4, "Last");
        this.jPanel5.add(this.jPanel2);
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel7.setLayout(new GridBagLayout());
        this.panelSequenceAnimatedPreview.setBackground(new Color(255, 255, 255));
        this.panelSequenceAnimatedPreview.setBorder(BorderFactory.createLineBorder(ColorConstants.COLOR_OUTLINE_PLAIN));
        this.panelSequenceAnimatedPreview.setMaximumSize(new Dimension(80, 80));
        this.panelSequenceAnimatedPreview.setMinimumSize(new Dimension(80, 80));
        this.panelSequenceAnimatedPreview.setPreferredSize(new Dimension(80, 80));
        this.panelSequenceAnimatedPreview.setLayout(new BorderLayout());
        this.jPanel7.add((Component)this.panelSequenceAnimatedPreview, new GridBagConstraints());
        this.jPanel6.add((Component)this.jPanel7, "Center");
        this.jPanel8.setMaximumSize(new Dimension(174, 44));
        this.jPanel8.setMinimumSize(new Dimension(174, 44));
        this.panelSpinner.setBackground(new Color(255, 255, 255));
        this.panelSpinner.setMaximumSize(new Dimension(100, 20));
        this.panelSpinner.setMinimumSize(new Dimension(100, 20));
        this.panelSpinner.setPreferredSize(new Dimension(100, 20));
        this.panelSpinner.setLayout(new BorderLayout());
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel8);
        this.jPanel8.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.panelSpinner, -1, 112, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.panelSpinner, -2, 20, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel6.add((Component)this.jPanel8, "Last");
        this.jPanel5.add(this.jPanel6);
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jPanel5, -2, 264, -2));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jPanel5, -2, -1, -2));
    }

    private class AnimationTimerTask
    extends TimerTask {
        private AnimationTimerTask() {
        }

        public void run() {
            if (!SequencePreviewPanel.this.isPlaying || !SequencePreviewPanel.this.isShowing()) {
                return;
            }
            SequencePreviewPanel.this.setCurrentFrameIndex(SequencePreviewPanel.this.sequenceIndex);
            SequencePreviewPanel.this.currentFrameChanged();
            if (SequencePreviewPanel.this.isPlayingForward) {
                SequencePreviewPanel.this.incrementSequenceIndex();
            } else {
                SequencePreviewPanel.this.decrementSequenceIndex();
            }
        }
    }
}

