/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.integration;

import com.sun.source.util.TreePath;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeGlobalLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeWriter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.game.integration.components.GameTypes;
import org.netbeans.modules.vmd.game.model.AnimatedTileCD;
import org.netbeans.modules.vmd.game.model.CodeUtils;
import org.netbeans.modules.vmd.game.model.TiledLayerCD;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameCodeSupport {
    public static Presenter createAddImportPresenter(final List<String> list) {
        return new CodeGlobalLevelPresenter(){

            protected void performGlobalGeneration(StyledDocument styledDocument) {
                this.addImports(styledDocument);
            }

            private void addImports(StyledDocument styledDocument) {
                try {
                    JavaSource.forDocument((Document)styledDocument).runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                        public void cancel() {
                        }

                        public void run(WorkingCopy workingCopy) throws Exception {
                            workingCopy.toPhase(JavaSource.Phase.PARSED);
                            for (String string : list) {
                                SourceUtils.resolveImport((CompilationInfo)workingCopy, (TreePath)new TreePath(workingCopy.getCompilationUnit()), (String)string);
                            }
                        }
                    }).commit();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        };
    }

    public static Presenter createSequenceCodePresenter() {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateFieldSectionCode(MultiGuardedSection multiGuardedSection) {
                CodeWriter codeWriter = multiGuardedSection.getWriter();
                DesignComponent designComponent = this.getComponent();
                String string = MidpTypes.getString((PropertyValue)designComponent.readProperty("sequncecd.prop.name"));
                int n = MidpTypes.getInteger((PropertyValue)designComponent.readProperty("sequncecd.prop.framems"));
                codeWriter.write("public int " + string + "Delay = " + n + ";\n");
                codeWriter.write("public int[] " + string + " = {");
                int[] nArray = GameTypes.getFrames(designComponent.readProperty("sequncecd.prop.frames"));
                for (int i = 0; i < nArray.length; ++i) {
                    if (i > 0) {
                        codeWriter.write(", ");
                    }
                    codeWriter.write(Integer.toString(nArray[i]));
                }
                codeWriter.write("};\n");
            }
        };
    }

    public static Presenter createImageResourceCodePresenter(final List<String> list) {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateFieldSectionCode(MultiGuardedSection multiGuardedSection) {
                CodeWriter codeWriter = multiGuardedSection.getWriter();
                DesignComponent designComponent = this.getComponent();
                String string = MidpTypes.getString((PropertyValue)designComponent.readProperty("imageresourcecd.prop.name"));
                codeWriter.write("private Image " + string + ";\n");
                list.add("javax.microedition.lcdui.Image");
            }

            protected void generateClassBodyCode(StyledDocument styledDocument) {
                DesignComponent designComponent = this.getComponent();
                MultiGuardedSection multiGuardedSection = MultiGuardedSection.create((StyledDocument)styledDocument, (String)(designComponent.getComponentID() + "-getter"));
                String string = MidpTypes.getString((PropertyValue)designComponent.readProperty("imageresourcecd.prop.name"));
                String string2 = MidpTypes.getString((PropertyValue)designComponent.readProperty("imageresourcecd.prop.imagepath"));
                multiGuardedSection.getWriter().write("public Image " + CodeUtils.createGetterMethodName(string) + "() throws java.io.IOException {\n");
                multiGuardedSection.getWriter().write("if (" + string + " == null) {\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-preInit");
                multiGuardedSection.getWriter().write(" // write pre-init user code here\n").commit();
                multiGuardedSection.switchToGuarded();
                multiGuardedSection.getWriter().write(string + " = Image.createImage(\"" + string2 + "\");\n");
                multiGuardedSection.getWriter().write("}\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-postInit");
                multiGuardedSection.getWriter().write(" // write post-init user code here\n").commit();
                multiGuardedSection.switchToGuarded();
                multiGuardedSection.getWriter().write("return this." + string + ";\n");
                multiGuardedSection.getWriter().write("}\n");
                multiGuardedSection.getWriter().write("\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.close();
            }
        };
    }

    public static Presenter createSceneCodePresenter(final List<String> list) {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateClassBodyCode(StyledDocument styledDocument) {
                DesignComponent designComponent = this.getComponent();
                MultiGuardedSection multiGuardedSection = MultiGuardedSection.create((StyledDocument)styledDocument, (String)(designComponent.getComponentID() + "-updateLayerManager"));
                String string = MidpTypes.getString((PropertyValue)designComponent.readProperty("scenecd.prop.name"));
                multiGuardedSection.getWriter().write("public void updateLayerManagerFor" + CodeUtils.capitalize(string) + "(LayerManager lm) throws java.io.IOException {\n");
                list.add("javax.microedition.lcdui.game.LayerManager");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-preUpdate");
                multiGuardedSection.getWriter().write(" // write pre-update user code here\n").commit();
                multiGuardedSection.switchToGuarded();
                List list2 = designComponent.readProperty("scenecd.prop.sceneitems").getArray();
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(list2);
                Collections.sort(arrayList, new Comparator<PropertyValue>(){

                    @Override
                    public int compare(PropertyValue propertyValue, PropertyValue propertyValue2) {
                        DesignComponent designComponent = propertyValue.getComponent();
                        int n = MidpTypes.getInteger((PropertyValue)designComponent.readProperty("sceneitemcd.prop.z.order"));
                        DesignComponent designComponent2 = propertyValue2.getComponent();
                        int n2 = MidpTypes.getInteger((PropertyValue)designComponent2.readProperty("sceneitemcd.prop.z.order"));
                        return new Integer(n).compareTo(n2);
                    }
                });
                for (PropertyValue propertyValue : arrayList) {
                    DesignComponent designComponent2 = propertyValue.getComponent();
                    DesignComponent designComponent3 = designComponent2.readProperty("sceneitemcd.prop.layer").getComponent();
                    String string2 = MidpTypes.getString((PropertyValue)designComponent3.readProperty("layercd.prop.name"));
                    Point point = GameTypes.getPoint(designComponent2.readProperty("sceneitemcd.prop.position"));
                    boolean bl = MidpTypes.getBoolean((PropertyValue)designComponent2.readProperty("sceneitemcd.prop.visible"));
                    multiGuardedSection.getWriter().write(CodeUtils.createGetterMethodName(string2) + "().setPosition(" + point.x + ", " + point.y + ");\n");
                    multiGuardedSection.getWriter().write(CodeUtils.createGetterMethodName(string2) + "().setVisible(" + bl + ");\n");
                    multiGuardedSection.getWriter().write("lm.append(" + CodeUtils.createGetterMethodName(string2) + "());\n");
                }
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-postUpdate");
                multiGuardedSection.getWriter().write(" // write post-update user code here\n").commit();
                multiGuardedSection.switchToGuarded();
                multiGuardedSection.getWriter().write("}\n");
                multiGuardedSection.getWriter().write("\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.close();
            }
        };
    }

    public static Presenter createSpriteCodePresenter(final List<String> list) {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateFieldSectionCode(MultiGuardedSection multiGuardedSection) {
                DesignComponent designComponent = this.getComponent();
                String string = MidpTypes.getString((PropertyValue)designComponent.readProperty("layercd.prop.name"));
                multiGuardedSection.getWriter().write("private Sprite " + string + ";\n");
                list.add("javax.microedition.lcdui.game.Sprite");
            }

            protected void generateClassBodyCode(StyledDocument styledDocument) {
                DesignComponent designComponent = this.getComponent();
                MultiGuardedSection multiGuardedSection = MultiGuardedSection.create((StyledDocument)styledDocument, (String)(designComponent.getComponentID() + "-getter"));
                String string = MidpTypes.getString((PropertyValue)designComponent.readProperty("layercd.prop.name"));
                DesignComponent designComponent2 = designComponent.readProperty("layercd.prop.imageresource").getComponent();
                String string2 = MidpTypes.getString((PropertyValue)designComponent2.readProperty("imageresourcecd.prop.name"));
                int n = MidpTypes.getInteger((PropertyValue)designComponent.readProperty("layercd.prop.tile.width"));
                int n2 = MidpTypes.getInteger((PropertyValue)designComponent.readProperty("layercd.prop.tile.height"));
                DesignComponent designComponent3 = designComponent.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
                String string3 = MidpTypes.getString((PropertyValue)designComponent3.readProperty("sequncecd.prop.name"));
                multiGuardedSection.getWriter().write("public Sprite " + CodeUtils.createGetterMethodName(string) + "() throws java.io.IOException {\n");
                multiGuardedSection.getWriter().write("if (" + string + " == null) {\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-preInit");
                multiGuardedSection.getWriter().write(" // write pre-init user code here\n").commit();
                multiGuardedSection.switchToGuarded();
                multiGuardedSection.getWriter().write(string + " = new Sprite(" + CodeUtils.createGetterMethodName(string2) + "(), " + n + ", " + n2 + ");\n");
                multiGuardedSection.getWriter().write(string + ".setFrameSequence(" + string3 + ");\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-postInit");
                multiGuardedSection.getWriter().write(" // write post-init user code here\n").commit();
                multiGuardedSection.switchToGuarded();
                multiGuardedSection.getWriter().write("}\n");
                multiGuardedSection.getWriter().write("\treturn " + string + ";\n");
                multiGuardedSection.getWriter().write("}\n");
                multiGuardedSection.getWriter().write("\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.close();
            }
        };
    }

    private static Set<Integer> getAnimatedTileIndexesFromTiledLayer(DesignComponent designComponent) {
        assert (designComponent.getType().equals((Object)TiledLayerCD.TYPEID));
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int[][] nArray = GameTypes.getTiles(designComponent.readProperty("tiledlayercd.prop.tiles"));
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                int n = nArray[i][j];
                if (n >= 0) continue;
                hashSet.add(n);
            }
        }
        return hashSet;
    }

    private static Set<DesignComponent> getAnimatedTilesFromTiledLayer(DesignComponent designComponent) {
        HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>();
        Set<Integer> set = GameCodeSupport.getAnimatedTileIndexesFromTiledLayer(designComponent);
        DesignComponent designComponent2 = designComponent.readProperty("layercd.prop.imageresource").getComponent();
        Collection collection = designComponent2.getComponents();
        for (DesignComponent designComponent3 : collection) {
            if (!designComponent3.getType().equals((Object)AnimatedTileCD.TYPEID) || !set.contains(MidpTypes.getInteger((PropertyValue)designComponent3.readProperty("animatedtilecd.prop.index")))) continue;
            hashSet.add(designComponent3);
        }
        return hashSet;
    }

    public static Presenter createTiledLayerCodePresenter(final List<String> list) {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateFieldSectionCode(MultiGuardedSection multiGuardedSection) {
                DesignComponent designComponent = this.getComponent();
                String string = MidpTypes.getString((PropertyValue)designComponent.readProperty("layercd.prop.name"));
                multiGuardedSection.getWriter().write("private TiledLayer " + string + ";\n");
                list.add("javax.microedition.lcdui.game.TiledLayer");
                Set set = GameCodeSupport.getAnimatedTilesFromTiledLayer(designComponent);
                for (DesignComponent designComponent2 : set) {
                    String string2 = MidpTypes.getString((PropertyValue)designComponent2.readProperty("animatedtilecd.prop.name"));
                    multiGuardedSection.getWriter().write("public int " + string2 + CodeUtils.capitalize(string) + ";\n");
                }
            }

            protected void generateClassBodyCode(StyledDocument styledDocument) {
                Object object3;
                DesignComponent designComponent = this.getComponent();
                MultiGuardedSection multiGuardedSection = MultiGuardedSection.create((StyledDocument)styledDocument, (String)(designComponent.getComponentID() + "-getter"));
                String string = MidpTypes.getString((PropertyValue)designComponent.readProperty("layercd.prop.name"));
                int[][] nArray = GameTypes.getTiles(designComponent.readProperty("tiledlayercd.prop.tiles"));
                DesignComponent designComponent2 = designComponent.readProperty("layercd.prop.imageresource").getComponent();
                String string2 = MidpTypes.getString((PropertyValue)designComponent2.readProperty("imageresourcecd.prop.name"));
                int n = MidpTypes.getInteger((PropertyValue)designComponent.readProperty("layercd.prop.tile.width"));
                int n2 = MidpTypes.getInteger((PropertyValue)designComponent.readProperty("layercd.prop.tile.height"));
                multiGuardedSection.getWriter().write("public TiledLayer " + CodeUtils.createGetterMethodName(string) + "() throws java.io.IOException {\n");
                multiGuardedSection.getWriter().write("if (" + string + " == null) {\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-preInit");
                multiGuardedSection.getWriter().write(" // write pre-init user code here\n").commit();
                multiGuardedSection.switchToGuarded();
                int n3 = 0;
                if (nArray.length > 0) {
                    n3 = nArray[0].length;
                }
                multiGuardedSection.getWriter().write(string + " = new TiledLayer(" + n3 + ", " + nArray.length + ", " + CodeUtils.createGetterMethodName(string2) + "(), " + n + ", " + n2 + ");\n");
                Set set = GameCodeSupport.getAnimatedTilesFromTiledLayer(designComponent);
                for (Object object2 : set) {
                    object3 = MidpTypes.getString((PropertyValue)object2.readProperty("animatedtilecd.prop.name"));
                    DesignComponent designComponent3 = object2.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
                    String string3 = MidpTypes.getString((PropertyValue)designComponent3.readProperty("sequncecd.prop.name"));
                    multiGuardedSection.getWriter().write((String)object3 + CodeUtils.capitalize(string) + " = " + string + ".createAnimatedTile(" + string3 + "[0]);\n");
                }
                HashMap hashMap = new HashMap();
                for (Object object3 : set) {
                    hashMap.put(MidpTypes.getInteger((PropertyValue)object3.readProperty("animatedtilecd.prop.index")), MidpTypes.getString((PropertyValue)object3.readProperty("animatedtilecd.prop.name")));
                }
                multiGuardedSection.getWriter().write("int[][] tiles = {\n");
                for (int i = 0; i < nArray.length; ++i) {
                    multiGuardedSection.getWriter().write("{ ");
                    object3 = nArray[i];
                    for (int j = 0; j < ((Object)object3).length; ++j) {
                        Object object4;
                        if (j > 0) {
                            multiGuardedSection.getWriter().write(", ");
                        }
                        if ((object4 = object3[j]) >= 0) {
                            multiGuardedSection.getWriter().write(Integer.toString((int)object3[j]));
                            continue;
                        }
                        String string4 = (String)hashMap.get((int)object4);
                        multiGuardedSection.getWriter().write(string4 + CodeUtils.capitalize(string));
                    }
                    if (i < nArray.length - 1) {
                        multiGuardedSection.getWriter().write(" },\n");
                        continue;
                    }
                    multiGuardedSection.getWriter().write(" }\n");
                }
                multiGuardedSection.getWriter().write("};\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-midInit");
                multiGuardedSection.getWriter().write(" // write mid-init user code here\n").commit();
                multiGuardedSection.switchToGuarded();
                multiGuardedSection.getWriter().write("for (int row = 0; row < " + nArray.length + "; row++) {\n");
                multiGuardedSection.getWriter().write("for (int col = 0; col < " + n3 + "; col++) {\n");
                multiGuardedSection.getWriter().write(string + ".setCell(col, row, tiles[row][col]);\n");
                multiGuardedSection.getWriter().write("}\n");
                multiGuardedSection.getWriter().write("}\n");
                multiGuardedSection.getWriter().write("}\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-postInit");
                multiGuardedSection.getWriter().write(" // write post-init user code here\n").commit();
                multiGuardedSection.switchToGuarded();
                multiGuardedSection.getWriter().write("\treturn " + string + ";\n");
                multiGuardedSection.getWriter().write("}\n");
                multiGuardedSection.getWriter().write("\n");
                multiGuardedSection.getWriter().commit();
                multiGuardedSection.close();
            }
        };
    }
}

