/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageAttachments;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageBody;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageElement;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageHeader;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.TargetElement;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMQName;
import org.netbeans.modules.websvc.wsitmodelext.security.AsymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.Attachments;
import org.netbeans.modules.websvc.wsitmodelext.security.Body;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.EncryptedElements;
import org.netbeans.modules.websvc.wsitmodelext.security.EncryptedParts;
import org.netbeans.modules.websvc.wsitmodelext.security.Header;
import org.netbeans.modules.websvc.wsitmodelext.security.Lax;
import org.netbeans.modules.websvc.wsitmodelext.security.LaxTsFirst;
import org.netbeans.modules.websvc.wsitmodelext.security.LaxTsLast;
import org.netbeans.modules.websvc.wsitmodelext.security.Layout;
import org.netbeans.modules.websvc.wsitmodelext.security.RequiredElements;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.SignedElements;
import org.netbeans.modules.websvc.wsitmodelext.security.SignedParts;
import org.netbeans.modules.websvc.wsitmodelext.security.Strict;
import org.netbeans.modules.websvc.wsitmodelext.security.SymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TransportBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.Trust10;
import org.netbeans.modules.websvc.wsitmodelext.security.Trust13;
import org.netbeans.modules.websvc.wsitmodelext.security.TrustElement;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss10;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss11;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.XPath;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.EncryptBeforeSigning;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.EncryptSignature;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.IncludeTimestamp;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportIssuedTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefEncryptedKey;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefIssuerSerial;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefKeyIdentifier;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefThumbprint;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.OnlySignEntireHeadersAndBody;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.RequireClientEntropy;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.RequireServerEntropy;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.RequireSignatureConfirmation;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.KeyStore;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.TrustStore;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireDerivedKeys;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireInternalReference;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireIssuerSerialReference;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyModelHelper {
    private static HashMap<ConfigVersion, SecurityPolicyModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private SecurityPolicyModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final synchronized SecurityPolicyModelHelper getInstance(ConfigVersion configVersion) {
        SecurityPolicyModelHelper securityPolicyModelHelper = instances.get(configVersion);
        if (securityPolicyModelHelper == null) {
            securityPolicyModelHelper = new SecurityPolicyModelHelper(configVersion);
            instances.put(configVersion, securityPolicyModelHelper);
        }
        return securityPolicyModelHelper;
    }

    public static boolean isSecurityEnabled(WSDLComponent wSDLComponent) {
        Policy policy = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        if (policy != null) {
            ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
            return extensibilityElement != null;
        }
        return false;
    }

    public void disableSecurity(WSDLComponent wSDLComponent, boolean bl) {
        Collection collection;
        Object object;
        assert (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation);
        this.setSecurityBindingType(wSDLComponent, null);
        SecurityTokensModelHelper.getInstance(this.configVersion).setSupportingTokens(wSDLComponent, null, 100);
        if (wSDLComponent instanceof Binding) {
            ProprietarySecurityPolicyModelHelper.setStreamingSecurity((Binding)wSDLComponent, true);
        }
        this.disableWss(wSDLComponent);
        this.disableTrust(wSDLComponent);
        this.removeTargets(wSDLComponent);
        Policy policy = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        if (policy != null && bl) {
            object = (KeyStore)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, KeyStore.class, false);
            collection = (TrustStore)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, TrustStore.class, false);
            if (object != null) {
                PolicyModelHelper.removeElement((WSDLComponent)object);
            }
            if (collection != null) {
                PolicyModelHelper.removeElement((WSDLComponent)collection);
            }
        }
        if (wSDLComponent instanceof Binding) {
            object = (Binding)wSDLComponent;
            collection = object.getBindingOperations();
            for (BindingOperation bindingOperation : collection) {
                this.disableSecurity((WSDLComponent)bindingOperation, bl);
            }
        } else {
            object = (BindingOperation)wSDLComponent;
            collection = object.getBindingInput();
            BindingOutput bindingOutput = object.getBindingOutput();
            if (collection != null) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)collection);
            }
            if (bindingOutput != null) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)bindingOutput);
            }
        }
        if (((RMModelHelper)(object = RMModelHelper.getInstance(this.configVersion))).isRMEnabled(wSDLComponent)) {
            ((RMModelHelper)object).setSequenceBinding((Binding)wSDLComponent, null);
        }
        PolicyModelHelper.cleanPolicies(wSDLComponent);
    }

    public WssElement enableWss(WSDLComponent wSDLComponent, boolean bl) {
        if (wSDLComponent == null) {
            return null;
        }
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation || wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
            wSDLComponent = policyModelHelper.createPolicy(wSDLComponent, true);
        }
        if (bl) {
            if (SecurityPolicyModelHelper.isWss10(wSDLComponent)) {
                this.disableWss(wSDLComponent);
            }
            if (!SecurityPolicyModelHelper.isWss11(wSDLComponent)) {
                return (WssElement)policyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.WSS11.getQName(this.configVersion), Wss11.class, false);
            }
            return SecurityPolicyModelHelper.getWss11(wSDLComponent);
        }
        if (SecurityPolicyModelHelper.isWss11(wSDLComponent)) {
            this.disableWss(wSDLComponent);
        }
        if (!SecurityPolicyModelHelper.isWss10(wSDLComponent)) {
            return (WssElement)policyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.WSS10.getQName(this.configVersion), Wss10.class, false);
        }
        return SecurityPolicyModelHelper.getWss10(wSDLComponent);
    }

    public TrustElement enableTrust(WSDLComponent wSDLComponent, ConfigVersion configVersion) {
        if (wSDLComponent == null) {
            return null;
        }
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation || wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
            wSDLComponent = policyModelHelper.createPolicy(wSDLComponent, true);
        }
        if (!SecurityPolicyModelHelper.isTrust(wSDLComponent, configVersion)) {
            if (configVersion == ConfigVersion.CONFIG_1_0) {
                return (TrustElement)policyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.TRUST10.getQName(this.configVersion), Trust10.class, false);
            }
            return (TrustElement)policyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.TRUST13.getQName(this.configVersion), Trust13.class, false);
        }
        return SecurityPolicyModelHelper.getTrust(wSDLComponent, configVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableWss(WSDLComponent wSDLComponent) {
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        WSDLModel wSDLModel = wSDLComponent.getModel();
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation || wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
            wSDLComponent = policyModelHelper.createPolicy(wSDLComponent, true);
        }
        Wss10 wss10 = SecurityPolicyModelHelper.getWss10(wSDLComponent);
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent);
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            if (wss10 != null) {
                ((WSDLComponent)wss10.getParent()).removeExtensibilityElement((ExtensibilityElement)wss10);
            }
            if (wss11 != null) {
                ((WSDLComponent)wss11.getParent()).removeExtensibilityElement((ExtensibilityElement)wss11);
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableTrust(WSDLComponent wSDLComponent) {
        boolean bl;
        WSDLModel wSDLModel = wSDLComponent.getModel();
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation || wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
            wSDLComponent = policyModelHelper.createPolicy(wSDLComponent, true);
        }
        if (!(bl = wSDLModel.isIntransaction())) {
            wSDLModel.startTransaction();
        }
        TrustElement trustElement = SecurityPolicyModelHelper.getTrust(wSDLComponent, this.configVersion);
        try {
            if (trustElement != null) {
                ((WSDLComponent)trustElement.getParent()).removeExtensibilityElement((ExtensibilityElement)trustElement);
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }

    static boolean isWss10(WSDLComponent wSDLComponent) {
        return SecurityPolicyModelHelper.getWss10(wSDLComponent) != null;
    }

    public static boolean isWss11(WSDLComponent wSDLComponent) {
        return SecurityPolicyModelHelper.getWss11(wSDLComponent) != null;
    }

    static boolean isTrust(WSDLComponent wSDLComponent, ConfigVersion configVersion) {
        return SecurityPolicyModelHelper.getTrust(wSDLComponent, configVersion) != null;
    }

    static Wss10 getWss10(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            wSDLComponent = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        }
        return (Wss10)PolicyModelHelper.getTopLevelElement(wSDLComponent, Wss10.class, false);
    }

    public static Wss11 getWss11(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            wSDLComponent = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        }
        return (Wss11)PolicyModelHelper.getTopLevelElement(wSDLComponent, Wss11.class, false);
    }

    static TrustElement getTrust(WSDLComponent wSDLComponent, ConfigVersion configVersion) {
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            wSDLComponent = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        }
        if (configVersion.equals((Object)ConfigVersion.CONFIG_1_0)) {
            return (TrustElement)PolicyModelHelper.getTopLevelElement(wSDLComponent, Trust10.class, false);
        }
        return (TrustElement)PolicyModelHelper.getTopLevelElement(wSDLComponent, Trust13.class, false);
    }

    public static boolean isRequireSignatureConfirmation(WSDLComponent wSDLComponent) {
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss11, RequireSignatureConfirmation.class);
    }

    static boolean isAttributeEnabled(ExtensibilityElement extensibilityElement, Class clazz) {
        if (extensibilityElement != null) {
            Policy policy = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)extensibilityElement, Policy.class, false);
            return PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, clazz, false) != null;
        }
        return false;
    }

    public void enableIncludeTimestamp(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(wSDLComponent, SecurityPolicyQName.INCLUDETIMESTAMP.getQName(this.configVersion), IncludeTimestamp.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, IncludeTimestamp.class, true);
        }
    }

    public void enableEncryptSignature(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(wSDLComponent, SecurityPolicyQName.ENCRYPTSIGNATURE.getQName(this.configVersion), EncryptSignature.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, EncryptSignature.class, true);
        }
    }

    void enableSignEntireHeadersAndBody(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(wSDLComponent, SecurityPolicyQName.ONLYSIGNENTIREHEADERSANDBODY.getQName(this.configVersion), OnlySignEntireHeadersAndBody.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, OnlySignEntireHeadersAndBody.class, true);
        }
    }

    public void enableEncryptBeforeSigning(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(wSDLComponent, SecurityPolicyQName.ENCRYPTBEFORESIGNING.getQName(this.configVersion), EncryptBeforeSigning.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, EncryptBeforeSigning.class, true);
        }
    }

    public void enableMustSupportRefIssuerSerial(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)wssElement, SecurityPolicyQName.MUSTSUPPORTREFISSUERSERIAL.getQName(this.configVersion), MustSupportRefIssuerSerial.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, MustSupportRefIssuerSerial.class, true);
        }
    }

    public void enableMustSupportRefKeyIdentifier(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)wssElement, SecurityPolicyQName.MUSTSUPPORTREFKEYIDENTIFIER.getQName(this.configVersion), MustSupportRefKeyIdentifier.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, MustSupportRefKeyIdentifier.class, true);
        }
    }

    public static boolean isRequireDerivedKeys(WSDLComponent wSDLComponent) {
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wSDLComponent, RequireDerivedKeys.class);
    }

    public void enableRequireDerivedKeys(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(wSDLComponent, SecurityPolicyQName.REQUIREDERIVEDKEYS.getQName(this.configVersion), RequireDerivedKeys.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireDerivedKeys.class, true);
        }
    }

    public void enableRequireIssuerSerialReference(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(wSDLComponent, SecurityPolicyQName.REQUIREISSUERSERIALREFERENCE.getQName(this.configVersion), RequireIssuerSerialReference.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireIssuerSerialReference.class, true);
        }
    }

    public void enableRequireInternalReference(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(wSDLComponent, SecurityPolicyQName.REQUIREINTERNALREFERENCE.getQName(this.configVersion), RequireInternalReference.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireInternalReference.class, true);
        }
    }

    public void enableMustSupportRefEncryptedKey(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)wssElement, SecurityPolicyQName.MUSTSUPPORTREFENCRYPTEDKEY.getQName(this.configVersion), MustSupportRefEncryptedKey.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, MustSupportRefEncryptedKey.class, true);
        }
    }

    public void enableMustSupportRefThumbprint(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)wssElement, SecurityPolicyQName.MUSTSUPPORTREFTHUMBPRINT.getQName(this.configVersion), MustSupportRefThumbprint.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, MustSupportRefThumbprint.class, true);
        }
    }

    public void enableRequireSignatureConfirmation(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)wssElement, SecurityPolicyQName.REQUIRESIGNATURECONFIRMATION.getQName(this.configVersion), RequireSignatureConfirmation.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, RequireSignatureConfirmation.class, true);
        }
    }

    public void enableRequireClientEntropy(TrustElement trustElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)trustElement, SecurityPolicyQName.REQUIRECLIENTENTROPY.getQName(this.configVersion), RequireClientEntropy.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trustElement, RequireClientEntropy.class, true);
        }
    }

    public void enableRequireServerEntropy(TrustElement trustElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)trustElement, SecurityPolicyQName.REQUIRESERVERENTROPY.getQName(this.configVersion), RequireServerEntropy.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trustElement, RequireServerEntropy.class, true);
        }
    }

    public void enableMustSupportIssuedTokens(TrustElement trustElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)trustElement, SecurityPolicyQName.MUSTSUPPORTISSUEDTOKENS.getQName(this.configVersion), MustSupportIssuedTokens.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trustElement, MustSupportIssuedTokens.class, true);
        }
    }

    public static Vector<Vector> getTargets(WSDLComponent wSDLComponent) {
        Vector vector;
        Object object;
        Object object22;
        Object object32;
        Object object4;
        Header header2;
        Object object5;
        Vector<Vector> vector2 = new Vector<Vector>();
        Policy policy = null;
        policy = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        if (policy == null) {
            return vector2;
        }
        List list = Collections.emptyList();
        List list2 = Collections.emptyList();
        List list3 = Collections.emptyList();
        List list4 = Collections.emptyList();
        EncryptedParts encryptedParts = (EncryptedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, EncryptedParts.class, false);
        EncryptedElements encryptedElements = (EncryptedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, EncryptedElements.class, false);
        if (encryptedParts != null) {
            list = encryptedParts.getExtensibilityElements(Body.class);
            list2 = encryptedParts.getExtensibilityElements(Attachments.class);
            list3 = encryptedParts.getExtensibilityElements(Header.class);
        }
        if (encryptedElements != null) {
            list4 = encryptedElements.getExtensibilityElements(XPath.class);
        }
        if (list != null && !list.isEmpty()) {
            object5 = new Vector();
            ((Vector)object5).add(0, new MessageBody());
            ((Vector)object5).add(1, Boolean.FALSE);
            ((Vector)object5).add(2, Boolean.TRUE);
            ((Vector)object5).add(3, Boolean.FALSE);
            vector2.add((Vector)object5);
        }
        if (list2 != null && !list2.isEmpty()) {
            object5 = new Vector<MessageBody>();
            ((Vector)object5).add(0, new MessageAttachments());
            ((Vector)object5).add(1, Boolean.FALSE);
            ((Vector)object5).add(2, Boolean.TRUE);
            ((Vector)object5).add(3, Boolean.FALSE);
            vector2.add((Vector)object5);
        }
        for (Header header2 : list3) {
            object4 = SecurityPolicyModelHelper.getListModelForHeader(header2);
            if (object4 == null) continue;
            object32 = new Vector();
            ((Vector)object32).add(0, object4);
            ((Vector)object32).add(1, Boolean.FALSE);
            ((Vector)object32).add(2, Boolean.TRUE);
            ((Vector)object32).add(3, Boolean.FALSE);
            vector2.add((Vector)object32);
        }
        for (Header header2 : list4) {
            object4 = SecurityPolicyModelHelper.getListModelForXPath((XPath)header2);
            if (object4 == null) continue;
            object32 = new Vector();
            ((Vector)object32).add(0, object4);
            ((Vector)object32).add(1, Boolean.FALSE);
            ((Vector)object32).add(2, Boolean.TRUE);
            ((Vector)object32).add(3, Boolean.FALSE);
            vector2.add((Vector)object32);
        }
        object5 = (SignedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SignedParts.class, false);
        header2 = (SignedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SignedElements.class, false);
        if (object5 != null) {
            list = object5.getExtensibilityElements(Body.class);
            list2 = object5.getExtensibilityElements(Attachments.class);
            list3 = object5.getExtensibilityElements(Header.class);
        }
        if (header2 != null) {
            list4 = header2.getExtensibilityElements(XPath.class);
        }
        if (list != null && !list.isEmpty()) {
            object4 = new MessageBody();
            object32 = SecurityPolicyModelHelper.targetExists(vector2, (TargetElement)object4);
            if (object32 != null) {
                ((Vector)object32).set(1, Boolean.TRUE);
            } else {
                object22 = new Vector();
                ((Vector)object22).add(0, object4);
                ((Vector)object22).add(1, Boolean.TRUE);
                ((Vector)object22).add(2, Boolean.FALSE);
                ((Vector)object22).add(3, Boolean.FALSE);
                vector2.add((Vector)object22);
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            object4 = new MessageAttachments();
            object32 = SecurityPolicyModelHelper.targetExists(vector2, object4);
            if (object32 != null) {
                ((Vector)object32).set(1, Boolean.TRUE);
            } else {
                object22 = new Vector<RequiredElements>();
                ((Vector)object22).add(0, object4);
                ((Vector)object22).add(1, Boolean.TRUE);
                ((Vector)object22).add(2, Boolean.FALSE);
                ((Vector)object22).add(3, Boolean.FALSE);
                vector2.add((Vector)object22);
            }
        }
        for (Object object32 : list3) {
            object22 = SecurityPolicyModelHelper.getListModelForHeader((Header)object32);
            if (object22 == null) continue;
            object = SecurityPolicyModelHelper.targetExists(vector2, object22);
            if (object != null) {
                ((Vector)object).set(1, Boolean.TRUE);
                continue;
            }
            vector = new Vector();
            vector.add(0, object22);
            vector.add(1, Boolean.TRUE);
            vector.add(2, Boolean.FALSE);
            vector.add(3, Boolean.FALSE);
            vector2.add(vector);
        }
        for (Object object32 : list4) {
            object22 = SecurityPolicyModelHelper.getListModelForXPath((XPath)object32);
            if (object22 == null) continue;
            object = SecurityPolicyModelHelper.targetExists(vector2, (TargetElement)object22);
            if (object != null) {
                ((Vector)object).set(1, Boolean.TRUE);
                continue;
            }
            vector = new Vector();
            vector.add(0, object22);
            vector.add(1, Boolean.TRUE);
            vector.add(2, Boolean.FALSE);
            vector.add(3, Boolean.FALSE);
            vector2.add(vector);
        }
        object4 = (RequiredElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, RequiredElements.class, false);
        if (object4 != null) {
            list4 = object4.getExtensibilityElements(XPath.class);
        }
        for (Object object22 : list4) {
            object = SecurityPolicyModelHelper.getListModelForXPath((XPath)object22);
            if (object == null) continue;
            vector = SecurityPolicyModelHelper.targetExists(vector2, (TargetElement)object);
            if (vector != null) {
                vector.set(3, Boolean.TRUE);
                continue;
            }
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(0, object);
            vector3.add(1, Boolean.FALSE);
            vector3.add(2, Boolean.FALSE);
            vector3.add(3, Boolean.TRUE);
            vector2.add(vector3);
        }
        return vector2;
    }

    public static Vector targetExists(Vector<Vector> vector, TargetElement targetElement) {
        for (Vector vector2 : vector) {
            TargetElement targetElement2 = (TargetElement)vector2.get(0);
            if (!targetElement2.equals(targetElement)) continue;
            return vector2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargets(WSDLComponent wSDLComponent, Vector<Vector> vector) {
        if (wSDLComponent == null) {
            return;
        }
        WSDLModel wSDLModel = wSDLComponent.getModel();
        Policy policy = null;
        policy = wSDLComponent instanceof Policy ? (Policy)wSDLComponent : PolicyModelHelper.getPolicyForElement(wSDLComponent);
        EncryptedParts encryptedParts = (EncryptedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, EncryptedParts.class, false);
        SignedParts signedParts = (SignedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SignedParts.class, false);
        EncryptedElements encryptedElements = (EncryptedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, EncryptedElements.class, false);
        SignedElements signedElements = (SignedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SignedElements.class, false);
        RequiredElements requiredElements = (RequiredElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, RequiredElements.class, false);
        WSDLComponentFactory wSDLComponentFactory = wSDLModel.getFactory();
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            Object object = null;
            if (encryptedParts != null) {
                object = (WSDLComponent)encryptedParts.getParent();
                object.removeExtensibilityElement((ExtensibilityElement)encryptedParts);
                encryptedParts = null;
            }
            if (signedParts != null) {
                object = (WSDLComponent)signedParts.getParent();
                object.removeExtensibilityElement((ExtensibilityElement)signedParts);
                signedParts = null;
            }
            if (encryptedElements != null) {
                object = (WSDLComponent)encryptedElements.getParent();
                object.removeExtensibilityElement((ExtensibilityElement)encryptedElements);
                encryptedElements = null;
            }
            if (signedElements != null) {
                object = (WSDLComponent)signedElements.getParent();
                object.removeExtensibilityElement((ExtensibilityElement)signedElements);
                signedElements = null;
            }
            if (requiredElements != null) {
                object = (WSDLComponent)requiredElements.getParent();
                object.removeExtensibilityElement((ExtensibilityElement)requiredElements);
                requiredElements = null;
            }
            if (vector == null) {
                return;
            }
            PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
            object = policy == null ? policyModelHelper.createPolicy(wSDLComponent, true) : (!(wSDLComponent instanceof Policy) ? policyModelHelper.createTopExactlyOneAll(policy) : policy);
            boolean bl2 = true;
            for (Vector vector2 : vector) {
                TargetElement targetElement = (TargetElement)vector2.get(0);
                boolean bl3 = (Boolean)vector2.get(2);
                boolean bl4 = (Boolean)vector2.get(1);
                boolean bl5 = (Boolean)vector2.get(3);
                if (targetElement instanceof MessageHeader) {
                    if (bl3) {
                        if (encryptedParts == null) {
                            encryptedParts = (EncryptedParts)policyModelHelper.createElement((WSDLComponent)object, SecurityPolicyQName.ENCRYPTEDPARTS.getQName(this.configVersion), EncryptedParts.class, false);
                        }
                        this.addHeaderElementForListItem(targetElement.toString(), (WSDLComponent)encryptedParts, wSDLComponentFactory);
                    }
                    if (!bl4) continue;
                    if (signedParts == null) {
                        signedParts = (SignedParts)policyModelHelper.createElement((WSDLComponent)object, SecurityPolicyQName.SIGNEDPARTS.getQName(this.configVersion), SignedParts.class, false);
                    }
                    this.addHeaderElementForListItem(targetElement.toString(), (WSDLComponent)signedParts, wSDLComponentFactory);
                    continue;
                }
                if (targetElement instanceof MessageElement) {
                    bl2 = false;
                    if (bl3) {
                        if (encryptedElements == null) {
                            encryptedElements = (EncryptedElements)policyModelHelper.createElement((WSDLComponent)object, SecurityPolicyQName.ENCRYPTEDELEMENTS.getQName(this.configVersion), EncryptedElements.class, false);
                        }
                        this.addElementForListItem(targetElement.toString(), (WSDLComponent)encryptedElements, wSDLComponentFactory);
                    }
                    if (bl4) {
                        if (signedElements == null) {
                            signedElements = (SignedElements)policyModelHelper.createElement((WSDLComponent)object, SecurityPolicyQName.SIGNEDELEMENTS.getQName(this.configVersion), SignedElements.class, false);
                        }
                        this.addElementForListItem(targetElement.toString(), (WSDLComponent)signedElements, wSDLComponentFactory);
                    }
                    if (!bl5) continue;
                    if (requiredElements == null) {
                        requiredElements = (RequiredElements)policyModelHelper.createElement((WSDLComponent)object, SecurityPolicyQName.REQUIREDELEMENTS.getQName(this.configVersion), RequiredElements.class, false);
                    }
                    this.addElementForListItem(targetElement.toString(), (WSDLComponent)requiredElements, wSDLComponentFactory);
                    continue;
                }
                if (targetElement instanceof MessageBody) {
                    if (bl3) {
                        if (encryptedParts == null) {
                            encryptedParts = (EncryptedParts)policyModelHelper.createElement((WSDLComponent)object, SecurityPolicyQName.ENCRYPTEDPARTS.getQName(this.configVersion), EncryptedParts.class, false);
                        }
                        this.addBody((WSDLComponent)encryptedParts, wSDLComponentFactory);
                    }
                    if (!bl4) continue;
                    if (signedParts == null) {
                        signedParts = (SignedParts)policyModelHelper.createElement((WSDLComponent)object, SecurityPolicyQName.SIGNEDPARTS.getQName(this.configVersion), SignedParts.class, false);
                    }
                    this.addBody((WSDLComponent)signedParts, wSDLComponentFactory);
                    continue;
                }
                if (!(targetElement instanceof MessageAttachments)) continue;
                if (bl3) {
                    if (encryptedParts == null) {
                        encryptedParts = (EncryptedParts)policyModelHelper.createElement((WSDLComponent)object, SecurityPolicyQName.ENCRYPTEDPARTS.getQName(this.configVersion), EncryptedParts.class, false);
                    }
                    this.addAttachments((WSDLComponent)encryptedParts, wSDLComponentFactory);
                }
                if (!bl4) continue;
                if (signedParts == null) {
                    signedParts = (SignedParts)policyModelHelper.createElement((WSDLComponent)object, SecurityPolicyQName.SIGNEDPARTS.getQName(this.configVersion), SignedParts.class, false);
                }
                this.addAttachments((WSDLComponent)signedParts, wSDLComponentFactory);
            }
            if (wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
                Binding binding = (Binding)((WSDLComponent)wSDLComponent.getParent()).getParent();
                ProprietarySecurityPolicyModelHelper.setStreamingSecurity(binding, bl2);
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }

    private static MessageHeader getListModelForHeader(Header header) {
        String string = header.getName();
        if ("To".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_TO);
        }
        if ("From".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_FROM);
        }
        if ("FaultTo".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_FAULTTO);
        }
        if ("ReplyTo".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_REPLYTO);
        }
        if ("MessageID".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_MESSAGEID);
        }
        if ("RelatesTo".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_RELATESTO);
        }
        if ("Action".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_ACTION);
        }
        if ("AckRequested".equals(string)) {
            return new MessageHeader(MessageHeader.RM_ACKREQUESTED);
        }
        if ("SequenceAcknowledgement".equals(string)) {
            return new MessageHeader(MessageHeader.RM_SEQUENCEACK);
        }
        if ("Sequence".equals(string)) {
            return new MessageHeader(MessageHeader.RM_SEQUENCE);
        }
        if ("CreateSequence".equals(string)) {
            return new MessageHeader(MessageHeader.RM_CREATESEQUENCE);
        }
        return null;
    }

    private static MessageElement getListModelForXPath(XPath xPath) {
        String string = xPath.getXPath();
        return new MessageElement(string);
    }

    private ExtensibilityElement addHeaderElementForListItem(String string, WSDLComponent wSDLComponent, WSDLComponentFactory wSDLComponentFactory) {
        Header header = (Header)wSDLComponentFactory.create(wSDLComponent, SecurityPolicyQName.HEADER.getQName(this.configVersion));
        if (MessageHeader.ADDRESSING_TO.equals(string)) {
            header.setName("To");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_FROM.equals(string)) {
            header.setName("From");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_FAULTTO.equals(string)) {
            header.setName("FaultTo");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_REPLYTO.equals(string)) {
            header.setName("ReplyTo");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_MESSAGEID.equals(string)) {
            header.setName("MessageID");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_RELATESTO.equals(string)) {
            header.setName("RelatesTo");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_ACTION.equals(string)) {
            header.setName("Action");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        String string2 = RMQName.getHeaderNamespaceUri((ConfigVersion)this.configVersion);
        if (MessageHeader.RM_ACKREQUESTED.equals(string)) {
            header.setName("AckRequested");
            header.setNamespace(string2);
        }
        if (MessageHeader.RM_SEQUENCEACK.equals(string)) {
            header.setName("SequenceAcknowledgement");
            header.setNamespace(string2);
        }
        if (MessageHeader.RM_SEQUENCE.equals(string)) {
            header.setName("Sequence");
            header.setNamespace(string2);
        }
        if (MessageHeader.RM_CREATESEQUENCE.equals(string)) {
            header.setName("CreateSequence");
            header.setNamespace(string2);
        }
        if (header != null) {
            wSDLComponent.addExtensibilityElement((ExtensibilityElement)header);
        }
        return header;
    }

    private ExtensibilityElement addElementForListItem(String string, WSDLComponent wSDLComponent, WSDLComponentFactory wSDLComponentFactory) {
        XPath xPath = null;
        xPath = (XPath)wSDLComponentFactory.create(wSDLComponent, SecurityPolicyQName.XPATH.getQName(this.configVersion));
        if (xPath != null) {
            wSDLComponent.addExtensibilityElement((ExtensibilityElement)xPath);
            xPath.setXPath(string);
        }
        return xPath;
    }

    private ExtensibilityElement addBody(WSDLComponent wSDLComponent, WSDLComponentFactory wSDLComponentFactory) {
        Body body = null;
        body = (Body)wSDLComponentFactory.create(wSDLComponent, SecurityPolicyQName.BODY.getQName(this.configVersion));
        wSDLComponent.addExtensibilityElement((ExtensibilityElement)body);
        return body;
    }

    private ExtensibilityElement addAttachments(WSDLComponent wSDLComponent, WSDLComponentFactory wSDLComponentFactory) {
        Attachments attachments = null;
        attachments = (Attachments)wSDLComponentFactory.create(wSDLComponent, SecurityPolicyQName.ATTACHMENTS.getQName(this.configVersion));
        wSDLComponent.addExtensibilityElement((ExtensibilityElement)attachments);
        return attachments;
    }

    public static ExtensibilityElement getSecurityBindingTypeElement(WSDLComponent wSDLComponent) {
        assert (wSDLComponent != null);
        Object object = wSDLComponent;
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation || wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
            object = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        } else if (wSDLComponent instanceof BootstrapPolicy) {
            object = PolicyModelHelper.getTopLevelElement(wSDLComponent, Policy.class, false);
        }
        Object object2 = PolicyModelHelper.getTopLevelElement(object, SymmetricBinding.class, false);
        if (object2 != null) {
            return object2;
        }
        object2 = (AsymmetricBinding)PolicyModelHelper.getTopLevelElement(object, AsymmetricBinding.class, false);
        if (object2 != null) {
            return object2;
        }
        object2 = (TransportBinding)PolicyModelHelper.getTopLevelElement(object, TransportBinding.class, false);
        if (object2 != null) {
            return object2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WSDLComponent setSecurityBindingType(WSDLComponent wSDLComponent, String string) {
        assert (wSDLComponent != null);
        WSDLModel wSDLModel = wSDLComponent.getModel();
        SymmetricBinding symmetricBinding = null;
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        All all = policyModelHelper.createPolicy(wSDLComponent, true);
        try {
            SymmetricBinding symmetricBinding2 = (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)all, SymmetricBinding.class, false);
            AsymmetricBinding asymmetricBinding = (AsymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)all, AsymmetricBinding.class, false);
            TransportBinding transportBinding = (TransportBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)all, TransportBinding.class, false);
            if (symmetricBinding2 != null) {
                ((WSDLComponent)symmetricBinding2.getParent()).removeExtensibilityElement((ExtensibilityElement)symmetricBinding2);
            }
            if (asymmetricBinding != null) {
                ((WSDLComponent)asymmetricBinding.getParent()).removeExtensibilityElement((ExtensibilityElement)asymmetricBinding);
            }
            if (transportBinding != null) {
                ((WSDLComponent)transportBinding.getParent()).removeExtensibilityElement((ExtensibilityElement)transportBinding);
            }
            if (ComboConstants.SYMMETRIC.equals(string)) {
                symmetricBinding = symmetricBinding2 = (SymmetricBinding)policyModelHelper.createElement((WSDLComponent)all, SecurityPolicyQName.SYMMETRICBINDING.getQName(this.configVersion), SymmetricBinding.class, false);
            }
            if (ComboConstants.ASYMMETRIC.equals(string)) {
                asymmetricBinding = (AsymmetricBinding)policyModelHelper.createElement((WSDLComponent)all, SecurityPolicyQName.ASYMMETRICBINDING.getQName(this.configVersion), AsymmetricBinding.class, false);
                symmetricBinding = asymmetricBinding;
            }
            if (ComboConstants.TRANSPORT.equals(string)) {
                transportBinding = (TransportBinding)policyModelHelper.createElement((WSDLComponent)all, SecurityPolicyQName.TRANSPORTBINDING.getQName(this.configVersion), TransportBinding.class, false);
                symmetricBinding = transportBinding;
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
        return symmetricBinding;
    }

    public void setDefaultTargets(WSDLComponent wSDLComponent, boolean bl, boolean bl2) {
        Vector<Vector> vector = new Vector<Vector>();
        Vector<Object> vector2 = new Vector<Object>();
        MessageBody messageBody = new MessageBody();
        vector2.add(0, messageBody);
        vector2.add(1, Boolean.TRUE);
        vector2.add(2, Boolean.TRUE);
        vector2.add(3, Boolean.FALSE);
        vector.add(vector2);
        if (bl) {
            MessageHeader messageHeader;
            for (String string : MessageHeader.ADDRESSING_HEADERS) {
                vector2 = new Vector();
                messageHeader = new MessageHeader(string);
                vector2.add(0, messageHeader);
                vector2.add(1, Boolean.TRUE);
                vector2.add(2, Boolean.FALSE);
                vector2.add(3, Boolean.FALSE);
                vector.add(vector2);
            }
            for (String string : MessageHeader.RM_HEADERS) {
                vector2 = new Vector();
                messageHeader = new MessageHeader(string);
                vector2.add(0, messageHeader);
                vector2.add(1, Boolean.TRUE);
                vector2.add(2, Boolean.FALSE);
                vector2.add(3, Boolean.FALSE);
                vector.add(vector2);
            }
        }
        this.setTargets(wSDLComponent, vector);
    }

    private void removeTargets(WSDLComponent wSDLComponent) {
        this.setTargets(wSDLComponent, null);
    }

    public static String getMessageLayout(WSDLComponent wSDLComponent) {
        WSDLComponent wSDLComponent2 = SecurityPolicyModelHelper.getMessageLayoutElement(wSDLComponent);
        if (wSDLComponent2 != null) {
            if (wSDLComponent2 instanceof Strict) {
                return ComboConstants.STRICT;
            }
            if (wSDLComponent2 instanceof Lax) {
                return ComboConstants.LAX;
            }
            if (wSDLComponent2 instanceof LaxTsFirst) {
                return ComboConstants.LAXTSFIRST;
            }
            if (wSDLComponent2 instanceof LaxTsLast) {
                return ComboConstants.LAXTSLAST;
            }
        }
        return null;
    }

    private static WSDLComponent getMessageLayoutElement(WSDLComponent wSDLComponent) {
        List list;
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            wSDLComponent = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        }
        if (wSDLComponent == null) {
            return null;
        }
        Policy policy = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent, Policy.class, false);
        Layout layout = (Layout)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, Layout.class, false);
        if ((policy = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)layout, Policy.class, false)) != null && (list = policy.getExtensibilityElements()) != null && !list.isEmpty()) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(0);
            return extensibilityElement;
        }
        return null;
    }

    public static boolean isEncryptBeforeSigning(WSDLComponent wSDLComponent) {
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        if (extensibilityElement != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(extensibilityElement, EncryptBeforeSigning.class);
        }
        return false;
    }

    public static boolean isEncryptSignature(WSDLComponent wSDLComponent) {
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        if (extensibilityElement != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(extensibilityElement, EncryptSignature.class);
        }
        return false;
    }

    static boolean isSignEntireHeadersAndBody(WSDLComponent wSDLComponent) {
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        if (extensibilityElement != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(extensibilityElement, OnlySignEntireHeadersAndBody.class);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayout(WSDLComponent wSDLComponent, String string) {
        WSDLModel wSDLModel = wSDLComponent.getModel();
        WSDLComponentFactory wSDLComponentFactory = wSDLModel.getFactory();
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            Policy policy2;
            QName qName = null;
            if (ComboConstants.STRICT.equals(string)) {
                qName = SecurityPolicyQName.STRICT.getQName(this.configVersion);
            } else if (ComboConstants.LAX.equals(string)) {
                qName = SecurityPolicyQName.LAX.getQName(this.configVersion);
            } else if (ComboConstants.LAXTSFIRST.equals(string)) {
                qName = SecurityPolicyQName.LAXTSFIRST.getQName(this.configVersion);
            } else if (ComboConstants.LAXTSLAST.equals(string)) {
                qName = SecurityPolicyQName.LAXTSLAST.getQName(this.configVersion);
            }
            PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
            Layout layout = (Layout)policyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.LAYOUT.getQName(this.configVersion), Layout.class, true);
            List list = layout.getExtensibilityElements(Policy.class);
            if (list != null && !list.isEmpty()) {
                for (Policy policy2 : list) {
                    layout.removeExtensibilityElement((ExtensibilityElement)policy2);
                }
            }
            Policy policy3 = (Policy)policyModelHelper.createElement((WSDLComponent)layout, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
            policy2 = (ExtensibilityElement)wSDLComponentFactory.create((WSDLComponent)policy3, qName);
            policy3.addExtensibilityElement((ExtensibilityElement)policy2);
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }
}

