/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRefactoringPlugin;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSITRenameRefactoringPlugin
extends WSITRefactoringPlugin<RenameRefactoring> {
    public WSITRenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        super(renameRefactoring);
    }

    @Override
    protected RefactoringElementImplementation createClassRE(WSDLModel wSDLModel) {
        return new ClassRE(((RenameRefactoring)this.refactoring).getNewName(), wSDLModel);
    }

    @Override
    protected RefactoringElementImplementation createMethodRE(String string, WSDLModel wSDLModel) {
        return new MethodRE(string, ((RenameRefactoring)this.refactoring).getNewName(), wSDLModel);
    }

    private static class MethodRE
    extends WSITRefactoringPlugin.AbstractRefactoringElement {
        private final String oldName;
        private final String newName;

        public MethodRE(String string, String string2, WSDLModel wSDLModel) {
            super(wSDLModel);
            this.oldName = string;
            this.newName = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performChange() {
            Definitions definitions = this.model.getDefinitions();
            Binding binding = (Binding)definitions.getBindings().toArray()[0];
            Collection collection = binding.getBindingOperations();
            PortType portType = (PortType)definitions.getPortTypes().toArray()[0];
            Collection collection2 = portType.getOperations();
            this.model.startTransaction();
            try {
                for (BindingOperation bindingOperation : collection) {
                    if (!this.oldName.equals(bindingOperation.getName())) continue;
                    bindingOperation.setName(this.newName);
                }
                for (BindingOperation bindingOperation : collection2) {
                    String string;
                    String string2;
                    QName qName;
                    Object object;
                    if (!this.oldName.equals(bindingOperation.getName())) continue;
                    bindingOperation.setName(this.newName);
                    Input input = bindingOperation.getInput();
                    if (input != null) {
                        object = input.getMessage().getQName();
                        qName = (Message)this.model.findComponentByName((QName)object, Message.class);
                        string2 = qName.getName();
                        if (string2 != null) {
                            string = string2.replaceAll(this.oldName, this.newName);
                            qName.setName(string);
                        }
                        input.setMessage(input.createReferenceTo((ReferenceableWSDLComponent)qName, Message.class));
                    }
                    if ((object = bindingOperation.getOutput()) == null) continue;
                    qName = object.getMessage().getQName();
                    string2 = (Message)this.model.findComponentByName(qName, Message.class);
                    string = string2.getName();
                    if (string != null) {
                        String string3 = string.replaceAll(this.oldName, this.newName);
                        string2.setName(string3);
                    }
                    object.setMessage(object.createReferenceTo((ReferenceableWSDLComponent)string2, Message.class));
                }
            }
            finally {
                this.model.endTransaction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undoChange() {
            Definitions definitions = this.model.getDefinitions();
            Binding binding = (Binding)definitions.getBindings().toArray()[0];
            Collection collection = binding.getBindingOperations();
            PortType portType = (PortType)definitions.getPortTypes().toArray()[0];
            Collection collection2 = portType.getOperations();
            this.model.startTransaction();
            try {
                for (BindingOperation bindingOperation : collection) {
                    if (!this.newName.equals(bindingOperation.getName())) continue;
                    bindingOperation.setName(this.oldName);
                }
                for (BindingOperation bindingOperation : collection2) {
                    String string;
                    String string2;
                    QName qName;
                    Object object;
                    if (!this.newName.equals(bindingOperation.getName())) continue;
                    bindingOperation.setName(this.oldName);
                    Input input = bindingOperation.getInput();
                    if (input != null) {
                        object = input.getMessage().getQName();
                        qName = (Message)this.model.findComponentByName((QName)object, Message.class);
                        string2 = qName.getName();
                        if (string2 != null) {
                            string = string2.replaceAll(this.newName, this.oldName);
                            qName.setName(string);
                        }
                        input.setMessage(input.createReferenceTo((ReferenceableWSDLComponent)qName, Message.class));
                    }
                    if ((object = bindingOperation.getOutput()) == null) continue;
                    qName = object.getMessage().getQName();
                    string2 = (Message)this.model.findComponentByName(qName, Message.class);
                    string = string2.getName();
                    if (string != null) {
                        String string3 = string.replaceAll(this.newName, this.oldName);
                        string2.setName(string3);
                    }
                    object.setMessage(object.createReferenceTo((ReferenceableWSDLComponent)string2, Message.class));
                }
            }
            finally {
                this.model.endTransaction();
            }
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(MethodRE.class, (String)"TXT_WsitXmlMethodRename"), objectArray);
        }
    }

    private static class ClassRE
    extends WSITRefactoringPlugin.AbstractRefactoringElement {
        private final String oldConfigName = this.getParentFile().getName();
        private final String newConfigName;
        private final String extension;

        public ClassRE(String string, WSDLModel wSDLModel) {
            super(wSDLModel);
            this.newConfigName = this.oldConfigName.substring(0, this.oldConfigName.lastIndexOf(46) + 1) + string;
            this.extension = this.getParentFile().getExt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performChange() {
            FileLock fileLock = null;
            FileObject fileObject = this.getParentFile();
            try {
                fileLock = fileObject.lock();
                fileObject.rename(fileLock, this.newConfigName, this.extension);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undoChange() {
            FileLock fileLock = null;
            FileObject fileObject = this.getParentFile();
            try {
                fileLock = fileObject.lock();
                fileObject.rename(fileLock, this.oldConfigName, this.extension);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.oldConfigName, this.newConfigName};
            return MessageFormat.format(NbBundle.getMessage(ClassRE.class, (String)"TXT_WsitXmlClassRename"), objectArray);
        }
    }
}

