/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.maven.artifact.Artifact;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.options.MavenCommandSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class InstallPanel
extends JPanel {
    private static File lastFolder = new File(System.getProperty("user.home"));
    private JButton btnFile;
    private JLabel lblFile;
    private JLabel lblHint;
    private JTextField txtFile;

    private InstallPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.btnFile = new JButton();
        this.lblHint = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.lblFile, (String)NbBundle.getMessage(InstallPanel.class, (String)"InstallPanel.lblFile.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnFile, (String)NbBundle.getMessage(InstallPanel.class, (String)"InstallPanel.btnFile.text"));
        this.btnFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstallPanel.this.btnFileActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(InstallPanel.class, (String)"InstallPanel.lblHint.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblFile).addPreferredGap(0).add((Component)this.txtFile, -1, 237, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnFile)).add((Component)this.lblHint)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblFile).add((Component)this.btnFile).add((Component)this.txtFile, -2, -1, -2)).addPreferredGap(0).add((Component)this.lblHint).addContainerGap(72, Short.MAX_VALUE)));
    }

    private void btnFileActionPerformed(ActionEvent actionEvent) {
        int n;
        File file;
        JFileChooser jFileChooser = new JFileChooser(lastFolder);
        jFileChooser.setDialogTitle(NbBundle.getMessage(InstallPanel.class, (String)"TIT_Select_Artifact"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".jar");
            }

            public String getDescription() {
                return NbBundle.getMessage(InstallPanel.class, (String)"SEL_Jars");
            }
        });
        jFileChooser.setMultiSelectionEnabled(false);
        if (this.txtFile.getText().trim().length() > 0 && (file = new File(this.txtFile.getText().trim())).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if ((n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(InstallPanel.class, (String)"TIT_Select"))) == 0) {
            this.txtFile.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.txtFile.requestFocusInWindow();
        }
    }

    File getFile() {
        File file = this.txtFile.getText().trim().length() > 0 ? new File(this.txtFile.getText().trim()) : null;
        return file != null && file.exists() ? file : null;
    }

    public static File showInstallDialog(Artifact artifact) {
        final InstallPanel installPanel = new InstallPanel();
        installPanel.setExplainText(NbBundle.getMessage(InstallPanel.class, (String)"MSG_Instructions", (Object)artifact.getGroupId(), (Object)artifact.getArtifactId(), (Object)artifact.getVersion()));
        final JButton jButton = new JButton(NbBundle.getMessage(InstallPanel.class, (String)"BTN_Install_locally"));
        jButton.setEnabled(installPanel.getFile() != null);
        installPanel.addDocListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                jButton.setEnabled(installPanel.getFile() != null);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                jButton.setEnabled(installPanel.getFile() != null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                jButton.setEnabled(installPanel.getFile() != null);
            }
        });
        Object[] objectArray = new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)installPanel, NbBundle.getMessage(InstallPanel.class, (String)"TIT_Install_locally"), true, objectArray, (Object)jButton, 0, HelpCtx.DEFAULT_HELP, null);
        dialogDescriptor.setClosingOptions(objectArray);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == jButton) {
            lastFolder = installPanel.getFile().getParentFile();
            return installPanel.getFile();
        }
        return null;
    }

    public static void runInstallGoal(NbMavenProjectImpl nbMavenProjectImpl, File file, Artifact artifact) {
        BeanRunConfig beanRunConfig = new BeanRunConfig();
        beanRunConfig.setExecutionDirectory(nbMavenProjectImpl.getPOMFile().getParentFile());
        beanRunConfig.setProject(nbMavenProjectImpl);
        beanRunConfig.setGoals(Collections.singletonList(MavenCommandSettings.getDefault().getCommand("installFile")));
        beanRunConfig.setExecutionName("install-artifact");
        Properties properties = new Properties();
        properties.put("artifactId", artifact.getArtifactId());
        properties.put("groupId", artifact.getGroupId());
        properties.put("version", artifact.getVersion());
        properties.put("packaging", artifact.getType());
        properties.put("file", file.getAbsolutePath());
        properties.put("generatePom", "false");
        beanRunConfig.setProperties(properties);
        beanRunConfig.setActivatedProfiles(Collections.<String>emptyList());
        beanRunConfig.setTaskDisplayName(NbBundle.getMessage(InstallPanel.class, (String)"TXT_InstallTask"));
        RunUtils.executeMaven(beanRunConfig);
    }

    private void addDocListener(DocumentListener documentListener) {
        this.txtFile.getDocument().addDocumentListener(documentListener);
    }

    private void setExplainText(String string) {
        this.lblHint.setText(string);
    }
}

