/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.openide.util.Exceptions;

public class BackwardCompatibilityWithMevenideChecker
implements PrerequisitesChecker {
    private static Logger LOG = Logger.getLogger(BackwardCompatibilityWithMevenideChecker.class.getName());

    public boolean checkRunConfig(RunConfig runConfig) {
        String[] stringArray = runConfig.getGoals().toArray(new String[0]);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("org.codehaus.mevenide:netbeans-deploy-plugin")) {
                stringArray[i] = null;
                runConfig.setProperty("netbeans.deploy", "true");
                bl = true;
                LOG.info("Dynamically removing netbeans-deploy-plugin goal from execution. No longer supported.");
                continue;
            }
            if (stringArray[i].startsWith("org.codehaus.mevenide:netbeans-nbmreload-plugin")) {
                stringArray[i] = null;
                LOG.info("Dynamically removing netbeans-nbmreload-plugin goal from execution. No longer supported.");
                bl = true;
                continue;
            }
            if (stringArray[i].startsWith("org.codehaus.mevenide:netbeans-run-plugin")) {
                stringArray[i] = null;
                LOG.info("Dynamically removing netbeans-run-plugin goal from execution. No longer supported.");
                bl = true;
                continue;
            }
            if (!stringArray[i].startsWith("org.codehaus.mevenide:netbeans-debugger-plugin")) continue;
            stringArray[i] = null;
            LOG.info("Dynamically removing netbeans-debugger-plugin goal from execution. No longer supported.");
            bl = true;
        }
        if (bl) {
            List<String> list = runConfig.getGoals();
            try {
                list.clear();
                list.addAll(Arrays.asList(stringArray));
                list.remove(null);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Exceptions.printStackTrace((Throwable)unsupportedOperationException);
            }
        }
        return true;
    }
}

