/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.debug;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.debug.JPDAStart;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.windows.OutputWriter;

public class DebuggerChecker
implements LateBoundPrerequisitesChecker,
ExecutionResultChecker,
PrerequisitesChecker {
    private static final String ARGLINE = "argLine";
    private static final String MAVENSUREFIREDEBUG = "maven.surefire.debug";
    private Logger LOGGER = Logger.getLogger(DebuggerChecker.class.getName());

    public boolean checkRunConfig(RunConfig runConfig) {
        if (runConfig.getProject() == null) {
            return true;
        }
        boolean bl = "true".equalsIgnoreCase(runConfig.getProperties().getProperty("jpda.listen"));
        if (bl && "debug.test.single".equalsIgnoreCase(runConfig.getActionName()) && runConfig.getGoals().contains("surefire:test")) {
            Properties properties;
            String string = runConfig.getProperties().getProperty(MAVENSUREFIREDEBUG);
            String string2 = runConfig.getProperties().getProperty(ARGLINE);
            String string3 = PluginPropertyUtils.getPluginVersion(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin");
            if (string3 == null) {
                string3 = "2.4";
            }
            DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion("2.4");
            DefaultArtifactVersion defaultArtifactVersion2 = new DefaultArtifactVersion(string3);
            int n = defaultArtifactVersion2.compareTo((Object)defaultArtifactVersion);
            if (string2 != null && string == null && n >= 0) {
                properties = runConfig.getProperties();
                properties.put(MAVENSUREFIREDEBUG, string2);
                properties.remove(ARGLINE);
                runConfig.setProperties(properties);
            }
            if (string != null && n < 0) {
                string2 = (string2 == null ? "" : string2) + " " + string;
                properties = runConfig.getProperties();
                properties.setProperty(ARGLINE, string2);
                properties.remove(MAVENSUREFIREDEBUG);
                runConfig.setProperties(properties);
            }
        }
        return true;
    }

    public boolean checkRunConfig(RunConfig runConfig, ExecutionContext executionContext) {
        if (runConfig.getProject() == null) {
            return true;
        }
        boolean bl = "true".equalsIgnoreCase(runConfig.getProperties().getProperty("jpda.listen"));
        boolean bl2 = "maven".equalsIgnoreCase(runConfig.getProperties().getProperty("jpda.listen"));
        if (bl || bl2) {
            if (bl2 && !runConfig.getProperties().contains("Env.MAVEN_OPTS")) {
                runConfig.setProperty("Env.MAVEN_OPTS", "-Xdebug -Xrunjdwp:transport=dt_socket,server=n,address=${jpda.address}");
            }
            try {
                JPDAStart jPDAStart = new JPDAStart(executionContext.getInputOutput());
                NbMavenProject nbMavenProject = (NbMavenProject)runConfig.getProject().getLookup().lookup(NbMavenProject.class);
                jPDAStart.setName(nbMavenProject.getMavenProject().getArtifactId());
                jPDAStart.setStopClassName(runConfig.getProperties().getProperty("jpda.stopclass"));
                String string = jPDAStart.execute(runConfig.getProject());
                Enumeration<?> enumeration = runConfig.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = runConfig.getProperties().getProperty(string2);
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    String string4 = "${jpda.address}";
                    int n = stringBuffer.indexOf(string4);
                    while (n > -1) {
                        String string5 = string;
                        string5 = string5 == null ? "" : string5;
                        stringBuffer.replace(n, n + string4.length(), string5);
                        n = stringBuffer.indexOf(string4);
                    }
                    runConfig.setProperty(string2, stringBuffer.toString());
                }
                runConfig.setProperty("jpda.address", string);
            }
            catch (Throwable throwable) {
                this.LOGGER.log(Level.INFO, throwable.getMessage(), throwable);
            }
        }
        if ("debug.stepinto".equals(runConfig.getActionName())) {
            // empty if block
        }
        return true;
    }

    public void executionResult(RunConfig runConfig, ExecutionContext executionContext, int n) {
        if (runConfig.getProject() != null && n == 0 && "debug.fix".equals(runConfig.getActionName())) {
            String string = runConfig.getProperties().getProperty("jpda.stopclass");
            if (string != null) {
                this.reload(runConfig.getProject(), executionContext.getInputOutput().getOut(), string);
            } else {
                executionContext.getInputOutput().getErr().println("Missing jpda.stopclass property in action mapping definition. Cannot reload class.");
            }
        }
    }

    public void reload(Project project, OutputWriter outputWriter, String string) {
        ClassPath classPath;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            outputWriter.println("NetBeans: No debugging sessions was found.");
            return;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (jPDADebugger == null) {
            outputWriter.println("NetBeans: Current debugger is not JPDA one.");
            return;
        }
        if (!jPDADebugger.canFixClasses()) {
            outputWriter.println("NetBeans: The debugger does not support Fix action.");
            return;
        }
        if (jPDADebugger.getState() == 4) {
            outputWriter.println("NetBeans: The debugger is not running");
            return;
        }
        outputWriter.println("NetBeans: Classes to be reloaded:");
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        EditorContext editorContext = (EditorContext)DebuggerManager.getDebuggerManager().lookupFirst(null, EditorContext.class);
        String string2 = string.replace('.', '/') + ".class";
        ProjectSourcesClassPathProvider projectSourcesClassPathProvider = (ProjectSourcesClassPathProvider)project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
        ClassPath[] classPathArray = projectSourcesClassPathProvider.getProjectClassPaths("classpath/compile");
        FileObject fileObject = null;
        Object object = classPathArray;
        int n = ((ClassPath[])object).length;
        for (int i = 0; i < n && (fileObject = (classPath = object[i]).findResource(string2)) == null; ++i) {
        }
        if (fileObject != null) {
            try {
                object = this.classToSourceURL(fileObject, outputWriter);
                if (object != null) {
                    editorContext.updateTimeStamp((Object)jPDADebugger, (String)object);
                }
                InputStream inputStream = fileObject.getInputStream();
                long l = fileObject.getSize();
                byte[] byArray = new byte[(int)l];
                inputStream.read(byArray);
                hashMap.put(string, byArray);
                outputWriter.println(" " + string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        outputWriter.println("NetBeans: Reloaded classes: " + hashMap.keySet());
        if (hashMap.size() == 0) {
            outputWriter.println("NetBeans: No class to reload");
            return;
        }
        object = null;
        try {
            jPDADebugger.fixClasses(hashMap);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = "The virtual machine does not support this operation: " + unsupportedOperationException.getLocalizedMessage();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            object = "The bytes don't correspond to the class type (the names don't match): " + noClassDefFoundError.getLocalizedMessage();
        }
        catch (VerifyError verifyError) {
            object = "A \"verifier\" detects that a class, though well formed, contains an internal inconsistency or security problem: " + verifyError.getLocalizedMessage();
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            object = "The major and minor version numbers in bytes are not supported by the VM. " + unsupportedClassVersionError.getLocalizedMessage();
        }
        catch (ClassFormatError classFormatError) {
            object = "The bytes do not represent a valid class. " + classFormatError.getLocalizedMessage();
        }
        catch (ClassCircularityError classCircularityError) {
            object = "A circularity has been detected while initializing a class: " + classCircularityError.getLocalizedMessage();
        }
        if (object != null) {
            outputWriter.println("NetBeans:" + (String)object);
        }
    }

    private String classToSourceURL(FileObject fileObject, OutputWriter outputWriter) {
        try {
            FileObject[] fileObjectArray;
            ClassPath classPath;
            FileObject fileObject2;
            ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            FileObject fileObject3 = classPath2.findOwnerRoot(fileObject);
            String string = classPath2.getResourceName(fileObject, '/', false);
            if (string == null) {
                outputWriter.println("Can not find classpath resource for " + fileObject + ", skipping...");
                return null;
            }
            int n = string.indexOf(36);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if ((fileObject2 = (classPath = ClassPathSupport.createClassPath((FileObject[])(fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)fileObject3.getURL()).getRoots()))).findResource(string + ".java")) == null) {
                return null;
            }
            return fileObject2.getURL().toExternalForm();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            fileStateInvalidException.printStackTrace();
            return null;
        }
    }
}

