/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions.usages.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.indexer.api.NBArtifactInfo;
import org.netbeans.modules.maven.indexer.api.NBGroupInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsagesUI
extends JPanel
implements ExplorerManager.Provider {
    static final int TYPE_DEPENDENCY = 0;
    static final int TYPE_COMPILE = 1;
    static final int TYPE_TEST = 2;
    static final int TYPE_RUNTIME = 3;
    private ExplorerManager explorerManager = new ExplorerManager();
    private JScrollPane jScrollPane1;

    public UsagesUI(String string, Artifact artifact) {
        this.initComponents();
        this.initNodes(string, artifact);
    }

    void initNodes(final String string, final Artifact artifact) {
        Children.Keys<Integer> keys = new Children.Keys<Integer>(){

            protected Node[] createNodes(Integer n) {
                final List<NbMavenProjectImpl> list = UsagesUI.this.getOpenProjects(artifact, n);
                Children.Keys<NbMavenProjectImpl> keys = new Children.Keys<NbMavenProjectImpl>(){

                    protected Node[] createNodes(NbMavenProjectImpl nbMavenProjectImpl) {
                        return new Node[]{new OpenProjectNode(nbMavenProjectImpl)};
                    }

                    protected void addNotify() {
                        super.addNotify();
                        this.setKeys(list);
                    }
                };
                AbstractNode abstractNode = new AbstractNode((Children)keys){

                    public String getHtmlDisplayName() {
                        return this.getDisplayName();
                    }

                    public Image getIcon(int n) {
                        return NodeUtils.getTreeFolderIcon(false);
                    }

                    public Image getOpenedIcon(int n) {
                        return NodeUtils.getTreeFolderIcon(true);
                    }
                };
                switch (n) {
                    case 0: {
                        abstractNode.setDisplayName(NbBundle.getMessage(UsagesUI.class, (String)"LBL_Dependancy"));
                        break;
                    }
                    case 1: {
                        abstractNode.setDisplayName(NbBundle.getMessage(UsagesUI.class, (String)"LBL_TYPE_COMPILE"));
                        break;
                    }
                    case 2: {
                        abstractNode.setDisplayName(NbBundle.getMessage(UsagesUI.class, (String)"LBL_TYPE_TEST"));
                        break;
                    }
                    case 3: {
                        abstractNode.setDisplayName(NbBundle.getMessage(UsagesUI.class, (String)"LBL_TYPE_RUNTIME"));
                    }
                }
                return new Node[]{abstractNode};
            }

            protected void addNotify() {
                super.addNotify();
                this.setKeys(new Integer[]{0, 1, 2, 3});
            }
        };
        final AbstractNode abstractNode = new AbstractNode((Children)keys){

            public String getHtmlDisplayName() {
                return NbBundle.getMessage(UsagesUI.class, (String)"LBL_Description", (Object)string);
            }

            public Image getIcon(int n) {
                return NodeUtils.getTreeFolderIcon(false);
            }

            public Image getOpenedIcon(int n) {
                return NodeUtils.getTreeFolderIcon(true);
            }
        };
        final List list = RepositoryQueries.findDependencyUsage((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion(), (RepositoryInfo[])new RepositoryInfo[0]);
        Children.Keys<NBGroupInfo> keys2 = new Children.Keys<NBGroupInfo>(){

            protected Node[] createNodes(NBGroupInfo nBGroupInfo) {
                return new Node[]{new GroupNode(nBGroupInfo)};
            }

            protected void addNotify() {
                super.addNotify();
                this.setKeys(list);
            }
        };
        AbstractNode abstractNode2 = new AbstractNode((Children)keys2){

            public String getHtmlDisplayName() {
                return NbBundle.getMessage(UsagesUI.class, (String)"LBL_Repo", (Object)string);
            }

            public Image getIcon(int n) {
                return NodeUtils.getTreeFolderIcon(false);
            }

            public Image getOpenedIcon(int n) {
                return NodeUtils.getTreeFolderIcon(true);
            }
        };
        Children.Array array = new Children.Array();
        array.add(new Node[]{abstractNode, abstractNode2});
        this.explorerManager.setRootContext((Node)new AbstractNode((Children)array));
        final BeanTreeView beanTreeView = (BeanTreeView)this.jScrollPane1;
        beanTreeView.setPopupAllowed(false);
        beanTreeView.setRootVisible(false);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                beanTreeView.expandAll();
            }
        }, 100);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    UsagesUI.this.explorerManager.setSelectedNodes(new Node[]{abstractNode});
                }
                catch (PropertyVetoException propertyVetoException) {
                    Exceptions.printStackTrace((Throwable)propertyVetoException);
                }
            }
        }, 600);
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder(null, UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 524, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 447, Short.MAX_VALUE)));
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public List<NbMavenProjectImpl> getOpenProjects(Artifact artifact, int n) {
        Project[] projectArray;
        ArrayList<NbMavenProjectImpl> arrayList = new ArrayList<NbMavenProjectImpl>();
        block6: for (Project project : projectArray = OpenProjects.getDefault().getOpenProjects()) {
            NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
            if (nbMavenProjectImpl == null) continue;
            MavenProject mavenProject = nbMavenProjectImpl.getOriginalMavenProject();
            ArrayList arrayList2 = new ArrayList();
            switch (n) {
                case 0: {
                    arrayList2.addAll(mavenProject.getDependencyArtifacts());
                    break;
                }
                case 1: {
                    arrayList2.addAll(mavenProject.getCompileArtifacts());
                    break;
                }
                case 2: {
                    arrayList2.addAll(mavenProject.getTestArtifacts());
                    arrayList2.removeAll(mavenProject.getCompileArtifacts());
                    break;
                }
                case 3: {
                    arrayList2.addAll(mavenProject.getRuntimeArtifacts());
                    arrayList2.removeAll(mavenProject.getCompileArtifacts());
                }
            }
            for (Artifact artifact2 : arrayList2) {
                if (!artifact2.getGroupId().equals(artifact.getGroupId()) || !artifact2.getArtifactId().equals(artifact.getArtifactId()) || !artifact2.getVersion().equals(artifact.getVersion())) continue;
                arrayList.add(nbMavenProjectImpl);
                continue block6;
            }
        }
        return arrayList;
    }

    private static class OpenProjectNode
    extends AbstractNode {
        private NbMavenProjectImpl project;
        private ProjectInformation pi;

        public OpenProjectNode(NbMavenProjectImpl nbMavenProjectImpl) {
            super(Children.LEAF);
            this.project = nbMavenProjectImpl;
            this.pi = ProjectUtils.getInformation((Project)nbMavenProjectImpl);
        }

        public Image getIcon(int n) {
            return ImageUtilities.icon2Image((Icon)this.pi.getIcon());
        }

        public String getDisplayName() {
            return this.pi.getDisplayName();
        }
    }

    private static class VertionNode
    extends AbstractNode {
        NBVersionInfo version;

        public VertionNode(NBVersionInfo nBVersionInfo) {
            super(Children.LEAF);
            this.version = nBVersionInfo;
            this.setIconBaseWithExtension("org/netbeans/modules/maven/DependencyIcon.png");
        }

        public String getDisplayName() {
            return this.version.getVersion() + " [ " + this.version.getType() + " ]";
        }
    }

    private static class ArtifactNode
    extends AbstractNode {
        NBArtifactInfo artifact;

        public ArtifactNode(final NBArtifactInfo nBArtifactInfo) {
            super((Children)new Children.Keys<NBVersionInfo>(){

                protected Node[] createNodes(NBVersionInfo nBVersionInfo) {
                    return new Node[]{new VertionNode(nBVersionInfo)};
                }

                protected void addNotify() {
                    super.addNotify();
                    this.setKeys(nBArtifactInfo.getVersionInfos());
                }
            });
            this.artifact = nBArtifactInfo;
        }

        public Image getIcon(int n) {
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/actions/usages/ArtifactBadge.png", (boolean)true);
            return image;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getDisplayName() {
            return this.artifact.getName();
        }
    }

    private static class GroupNode
    extends AbstractNode {
        NBGroupInfo group;

        public GroupNode(final NBGroupInfo nBGroupInfo) {
            super((Children)new Children.Keys<NBArtifactInfo>(){

                protected Node[] createNodes(NBArtifactInfo nBArtifactInfo) {
                    return new Node[]{new ArtifactNode(nBArtifactInfo)};
                }

                protected void addNotify() {
                    super.addNotify();
                    this.setKeys(nBGroupInfo.getArtifactInfos());
                }
            });
            this.group = nBGroupInfo;
        }

        public Image getIcon(int n) {
            return NodeUtils.getTreeFolderIcon(false);
        }

        public Image getOpenedIcon(int n) {
            return NodeUtils.getTreeFolderIcon(true);
        }

        public String getDisplayName() {
            return this.group.getName();
        }
    }
}

