/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions.scm;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.actions.ActionsUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenScmURLAction
extends AbstractAction {
    private Artifact artifact;
    private List<ArtifactRepository> repos;

    public OpenScmURLAction(Artifact artifact, List<ArtifactRepository> list) {
        this.putValue("Name", NbBundle.getMessage(OpenScmURLAction.class, (String)"LBL_OpenURL"));
        this.artifact = artifact;
        this.repos = list;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Scm scm = ActionsUtil.readMavenProject(this.artifact, this.repos).getScm();
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(scm.getUrl()));
        }
        catch (MalformedURLException malformedURLException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenScmURLAction.class, (String)"ERR_Url", (Object)scm.getUrl()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    @Override
    public boolean isEnabled() {
        MavenProject mavenProject = ActionsUtil.readMavenProject(this.artifact, this.repos);
        return mavenProject != null && mavenProject.getScm() != null && mavenProject.getScm().getUrl() != null;
    }
}

