/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubprojectProviderImpl
implements SubprojectProvider {
    private final NbMavenProjectImpl project;
    private final NbMavenProject watcher;
    private List<ChangeListener> listeners;
    private ChangeListener listener2;
    private PropertyChangeListener propertyChange;

    public SubprojectProviderImpl(NbMavenProjectImpl nbMavenProjectImpl, NbMavenProject nbMavenProject) {
        this.project = nbMavenProjectImpl;
        this.watcher = nbMavenProject;
        this.listeners = new ArrayList<ChangeListener>();
        this.propertyChange = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                    SubprojectProviderImpl.this.fireChange();
                }
            }
        };
        this.listener2 = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SubprojectProviderImpl.this.fireChange();
            }
        };
        MavenFileOwnerQueryImpl.getInstance().addChangeListener(WeakListeners.change((ChangeListener)this.listener2, (Object)MavenFileOwnerQueryImpl.getInstance()));
    }

    public Set<? extends Project> getSubprojects() {
        HashSet<Project> hashSet = new HashSet<Project>();
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        try {
            this.addProjectModules(file, hashSet, this.project.getOriginalMavenProject().getModules());
        }
        catch (InterruptedException interruptedException) {
            return Collections.emptySet();
        }
        this.addOpenedCandidates(hashSet);
        hashSet.remove(this.project);
        return hashSet;
    }

    private void addOpenedCandidates(Set<Project> set) {
        Set<Project> set2 = MavenFileOwnerQueryImpl.getInstance().getOpenedProjects();
        List list = this.project.getOriginalMavenProject().getCompileArtifacts();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Artifact artifact : list) {
            arrayList.add(this.project.getArtifactRelativeRepositoryPath(artifact));
        }
        for (Project project : set2) {
            String string = ((NbMavenProjectImpl)project).getArtifactRelativeRepositoryPath();
            if (!arrayList.contains(string)) continue;
            set.add(project);
        }
    }

    private boolean isProcessed(Set<Project> set, FileObject fileObject) {
        for (Project project : set) {
            if (!project.getProjectDirectory().equals(fileObject)) continue;
            return true;
        }
        return false;
    }

    private void addProjectModules(File file, Set<Project> set, List list) throws InterruptedException {
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            String string = (String)iterator.next();
            if (string.trim().length() == 0) continue;
            File file2 = new File(file, string);
            File file3 = FileUtil.normalizeFile((File)file2);
            if (!file3.equals(file) && file3.exists()) {
                FileObject fileObject = FileUtil.toFileObject((File)file3);
                if (fileObject != null && !this.isProcessed(set, fileObject)) {
                    Project project = this.processOneSubproject(fileObject);
                    NbMavenProjectImpl nbMavenProjectImpl = project != null ? (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class) : null;
                    if (nbMavenProjectImpl == null) continue;
                    if (!"pom".equalsIgnoreCase(nbMavenProjectImpl.getProjectWatcher().getPackagingType())) {
                        set.add(project);
                    }
                    this.addProjectModules(FileUtil.toFile((FileObject)nbMavenProjectImpl.getProjectDirectory()), set, nbMavenProjectImpl.getOriginalMavenProject().getModules());
                    continue;
                }
                ErrorManager.getDefault().log("fileobject not found=" + file2);
                continue;
            }
            ErrorManager.getDefault().log("project file not found=" + file2);
        }
    }

    private Project processOneSubproject(FileObject fileObject) {
        try {
            return ProjectManager.getDefault().findProject(fileObject);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners.size() == 0) {
            this.watcher.addPropertyChangeListener(this.propertyChange);
        }
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
        if (this.listeners.size() == 0) {
            this.watcher.removePropertyChangeListener(this.propertyChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
        SubprojectProviderImpl subprojectProviderImpl = this;
        synchronized (subprojectProviderImpl) {
            arrayList.addAll(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }
}

