/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.MavenExecutor;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.execute.ui.RunGoalsPanel;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.operations.Operations;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.spi.actions.ActionConvertor;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ActionProviderImpl
implements ActionProvider {
    private final NbMavenProjectImpl project;
    private static String[] supported = new String[]{"build", "build-with-dependencies", "clean", "rebuild", "javadoc", "test", "test.single", "run", "run.single", "debug", "debug.single", "debug.test.single", "debug.fix", "delete", "rename", "move", "copy"};
    Lookup.Result<? extends MavenActionsProvider> result;

    public ActionProviderImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
        this.result = Lookup.getDefault().lookupResult(MavenActionsProvider.class);
    }

    public String[] getSupportedActions() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(supported));
        for (MavenActionsProvider mavenActionsProvider : this.result.allInstances()) {
            Set<String> set = mavenActionsProvider.getSupportedDefaultActions();
            if (set == null) continue;
            hashSet.addAll(set);
        }
        if (RunUtils.hasTestCompileOnSaveEnabled(this.project)) {
            hashSet.add("run.single.method");
            hashSet.add("debug.single.method");
        }
        return hashSet.toArray(new String[0]);
    }

    public void invokeAction(final String string, final Lookup lookup) {
        Object object;
        Object object2;
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            Operations.renameProject(this.project);
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ActionProviderImpl.this.invokeAction(string, lookup);
                }
            });
            return;
        }
        Collection collection = this.project.getLookup().lookupAll(ActionConvertor.class);
        String string2 = null;
        Object object3 = collection.iterator();
        while (object3.hasNext() && (string2 = (object2 = (ActionConvertor)object3.next()).convert(string, lookup)) == null) {
        }
        if (string2 == null) {
            string2 = string;
        }
        object3 = this.project.getLookup().lookupAll(ReplaceTokenProvider.class);
        object2 = new HashMap();
        ProxyLookup proxyLookup = object3.iterator();
        while (proxyLookup.hasNext()) {
            object = (ReplaceTokenProvider)proxyLookup.next();
            ((HashMap)object2).putAll(object.createReplacements(string2, lookup));
        }
        proxyLookup = new ProxyLookup(new Lookup[]{lookup, Lookups.fixed((Object[])new Object[]{object2})});
        object = ActionToGoalUtils.createRunConfig(string2, this.project, (Lookup)proxyLookup);
        if (object == null) {
            Logger.getLogger(ActionProviderImpl.class.getName()).log(Level.INFO, "No handling for action:" + string + ". Ignoring.");
        } else {
            RunConfig runConfig;
            BeanRunConfig beanRunConfig;
            if (object instanceof BeanRunConfig && (beanRunConfig = (BeanRunConfig)object).getPreExecutionActionName() != null && (runConfig = ActionToGoalUtils.createRunConfig(beanRunConfig.getPreExecutionActionName(), this.project, (Lookup)proxyLookup)) != null) {
                beanRunConfig.setPreExecution(runConfig);
            }
            this.setupTaskName(string, (RunConfig)object, lookup);
            this.runGoal(lookup, (RunConfig)object, true);
        }
    }

    private void runGoal(Lookup lookup, RunConfig runConfig, boolean bl) {
        Object object;
        LifecycleManager.getDefault().saveAll();
        Lookup.Result result = runConfig.getProject().getLookup().lookup(new Lookup.Template(PrerequisitesChecker.class));
        for (PrerequisitesChecker prerequisitesChecker : result.allInstances()) {
            if (!prerequisitesChecker.checkRunConfig(runConfig)) {
                return;
            }
            if (runConfig.getPreExecution() == null || prerequisitesChecker.checkRunConfig(runConfig.getPreExecution())) continue;
            return;
        }
        if (bl && MavenSettings.getDefault().isShowRunDialog()) {
            PrerequisitesChecker prerequisitesChecker;
            object = new RunGoalsPanel();
            prerequisitesChecker = new DialogDescriptor(object, NbBundle.getMessage(MavenExecutor.class, (String)"TIT_Run_maven"));
            ((RunGoalsPanel)object).readConfig(runConfig);
            Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)prerequisitesChecker);
            if (object2 == DialogDescriptor.OK_OPTION) {
                BeanRunConfig beanRunConfig = new BeanRunConfig();
                beanRunConfig.setExecutionDirectory(runConfig.getExecutionDirectory());
                beanRunConfig.setExecutionName(runConfig.getExecutionName());
                beanRunConfig.setTaskDisplayName(runConfig.getTaskDisplayName());
                beanRunConfig.setProject(runConfig.getProject());
                ((RunGoalsPanel)object).applyValues(beanRunConfig);
                runConfig = beanRunConfig;
            } else {
                return;
            }
        }
        object = RunUtils.executeMaven(runConfig);
        object.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                RepositoryInfo repositoryInfo = RepositoryPreferences.getInstance().getRepositoryInfoById("local");
                if (repositoryInfo != null) {
                    Set set;
                    ArrayList<Artifact> arrayList = new ArrayList<Artifact>();
                    Artifact artifact = ActionProviderImpl.this.project.getOriginalMavenProject().getArtifact();
                    if (artifact != null) {
                        arrayList.add(artifact);
                    }
                    if ((set = ActionProviderImpl.this.project.getOriginalMavenProject().getDependencyArtifacts()) != null) {
                        arrayList.addAll(set);
                    }
                    RepositoryIndexer.updateIndexWithArtifacts((RepositoryInfo)repositoryInfo, arrayList);
                }
            }
        });
    }

    private void setupTaskName(String string, RunConfig runConfig, Lookup lookup) {
        String string2;
        assert (runConfig instanceof BeanRunConfig);
        BeanRunConfig beanRunConfig = (BeanRunConfig)runConfig;
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        NbMavenProject nbMavenProject = (NbMavenProject)beanRunConfig.getProject().getLookup().lookup(NbMavenProject.class);
        String string3 = string2 = dataObject != null ? dataObject.getName() : "";
        String string4 = "run".equals(string) ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Run", (Object)nbMavenProject.getMavenProject().getArtifactId()) : ("debug".equals(string) ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Debug", (Object)nbMavenProject.getMavenProject().getArtifactId()) : ("test".equals(string) ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Test", (Object)nbMavenProject.getMavenProject().getArtifactId()) : (string.startsWith("run.single") ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Run", (Object)string2) : (string.startsWith("debug.single") || "debug.test.single".equals(string) ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Debug", (Object)string2) : ("test.single".equals(string) ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Test", (Object)string2) : NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Build", (Object)nbMavenProject.getMavenProject().getArtifactId()))))));
        beanRunConfig.setTaskDisplayName(string4);
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        ActionConvertor actionConvertor;
        if ("delete".equals(string) || "rename".equals(string) || "copy".equals(string) || "move".equals(string)) {
            return true;
        }
        Collection collection = this.project.getLookup().lookupAll(ActionConvertor.class);
        String string2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && (string2 = (actionConvertor = (ActionConvertor)iterator.next()).convert(string, lookup)) == null) {
        }
        if (string2 == null) {
            string2 = string;
        }
        return ActionToGoalUtils.isActionEnable(string2, this.project, lookup);
    }

    public Action createBasicMavenAction(String string, String string2) {
        return new BasicAction(string, string2);
    }

    public Action createCustomMavenAction(String string, NetbeansActionMapping netbeansActionMapping) {
        return this.createCustomMavenAction(string, netbeansActionMapping, true);
    }

    public Action createCustomMavenAction(String string, NetbeansActionMapping netbeansActionMapping, boolean bl) {
        return new CustomAction(string, netbeansActionMapping, bl);
    }

    public Action createCustomPopupAction() {
        return new CustomPopupActions();
    }

    public Action createProfilesPopupAction() {
        return new ProfilesPopupActions();
    }

    private final class ProfilesPopupActions
    extends AbstractAction
    implements Presenter.Popup {
        private ProfilesPopupActions() {
            this.putValue("Name", NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Profiles"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getPopupPresenter() {
            final JMenu jMenu = new JMenu(NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Profiles"));
            final JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Loading", (Object[])new Object[0]));
            jMenu.add(jMenuItem);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    final ProjectProfileHandler projectProfileHandler = (ProjectProfileHandler)ActionProviderImpl.this.project.getLookup().lookup(ProjectProfileHandler.class);
                    List<String> list = projectProfileHandler.getAllProfiles();
                    List<String> list2 = projectProfileHandler.getMergedActiveProfiles(false);
                    List<String> list3 = projectProfileHandler.getActiveProfiles(false);
                    ArrayList<String> arrayList = new ArrayList<String>(list2);
                    arrayList.removeAll(list3);
                    for (final String string : list) {
                        final boolean bl = arrayList.contains(string);
                        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, list2.contains(string));
                        jMenu.add(jCheckBoxMenuItem);
                        jCheckBoxMenuItem.setAction(new AbstractAction(string){

                            public void actionPerformed(ActionEvent actionEvent) {
                                if (jCheckBoxMenuItem.isSelected()) {
                                    projectProfileHandler.enableProfile(string, false);
                                } else {
                                    projectProfileHandler.disableProfile(string, false);
                                }
                                NbMavenProject.fireMavenProjectReload(ActionProviderImpl.this.project);
                            }

                            public boolean isEnabled() {
                                return !bl;
                            }
                        });
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            boolean bl = jMenu.isSelected();
                            jMenu.remove(jMenuItem);
                            jMenu.getPopupMenu().pack();
                            jMenu.repaint();
                            jMenu.updateUI();
                            jMenu.setSelected(bl);
                        }
                    });
                }
            }, 100);
            return jMenu;
        }
    }

    private final class CustomPopupActions
    extends AbstractAction
    implements Presenter.Popup {
        private CustomPopupActions() {
            this.putValue("Name", NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Custom_Run"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getPopupPresenter() {
            final JMenu jMenu = new JMenu(NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Custom_Run"));
            final JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Loading", (Object[])new Object[0]));
            jMenu.add(jMenuItem);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    NetbeansActionMapping[] netbeansActionMappingArray = ActionToGoalUtils.getActiveCustomMappings(ActionProviderImpl.this.project);
                    for (int i = 0; i < netbeansActionMappingArray.length; ++i) {
                        NetbeansActionMapping netbeansActionMapping = netbeansActionMappingArray[i];
                        Action action = ActionProviderImpl.this.createCustomMavenAction(netbeansActionMapping.getActionName(), netbeansActionMapping, false);
                        JMenuItem jMenuItem2 = new JMenuItem(action);
                        jMenuItem2.setText(netbeansActionMapping.getDisplayName() == null ? netbeansActionMapping.getActionName() : netbeansActionMapping.getDisplayName());
                        jMenu.add(jMenuItem2);
                    }
                    jMenu.add(new JMenuItem(ActionProviderImpl.this.createCustomMavenAction(NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Custom_run_goals"), new NetbeansActionMapping())));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            boolean bl = jMenu.isSelected();
                            jMenu.remove(jMenuItem);
                            jMenu.getPopupMenu().pack();
                            jMenu.repaint();
                            jMenu.updateUI();
                            jMenu.setSelected(bl);
                        }
                    });
                }
            }, 100);
            return jMenu;
        }
    }

    private final class CustomAction
    extends AbstractAction {
        private NetbeansActionMapping mapping;
        private boolean showUI;

        private CustomAction(String string, NetbeansActionMapping netbeansActionMapping, boolean bl) {
            this.mapping = netbeansActionMapping;
            this.putValue("Name", string);
            this.showUI = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.showUI) {
                ModelRunConfig modelRunConfig = new ModelRunConfig(ActionProviderImpl.this.project, this.mapping, this.mapping.getActionName(), null);
                modelRunConfig.setShowDebug(MavenSettings.getDefault().isShowDebug());
                modelRunConfig.setTaskDisplayName(NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Build"));
                ActionProviderImpl.this.setupTaskName("custom", modelRunConfig, Lookup.EMPTY);
                ActionProviderImpl.this.runGoal(Lookup.EMPTY, modelRunConfig, true);
                return;
            }
            RunGoalsPanel runGoalsPanel = new RunGoalsPanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)runGoalsPanel, NbBundle.getMessage(ActionProviderImpl.class, (String)"TIT_Run_Maven"));
            ActionToGoalMapping actionToGoalMapping = ActionToGoalUtils.readMappingsFromFileAttributes(ActionProviderImpl.this.project.getProjectDirectory());
            runGoalsPanel.readMapping(this.mapping, ActionProviderImpl.this.project, actionToGoalMapping);
            runGoalsPanel.setShowDebug(MavenSettings.getDefault().isShowDebug());
            runGoalsPanel.setOffline(MavenSettings.getDefault().isOffline() != null ? MavenSettings.getDefault().isOffline() : false);
            runGoalsPanel.setRecursive(true);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object == DialogDescriptor.OK_OPTION) {
                Object object2;
                runGoalsPanel.applyValues(this.mapping);
                if (actionToGoalMapping.getActions().size() > 10) {
                    actionToGoalMapping.getActions().remove(0);
                }
                actionToGoalMapping.getActions().add(this.mapping);
                ActionToGoalUtils.writeMappingsToFileAttributes(ActionProviderImpl.this.project.getProjectDirectory(), actionToGoalMapping);
                if (runGoalsPanel.isRememberedAs() != null) {
                    try {
                        object2 = (M2ConfigProvider)ActionProviderImpl.this.project.getLookup().lookup(M2ConfigProvider.class);
                        ActionToGoalMapping actionToGoalMapping2 = new NetbeansBuildActionXpp3Reader().read(new StringReader(((M2ConfigProvider)object2).getDefaultConfig().getRawMappingsAsString()));
                        String string = "CUSTOM-" + runGoalsPanel.isRememberedAs();
                        this.mapping.setActionName(string);
                        Iterator<NetbeansActionMapping> iterator = actionToGoalMapping2.getActions().iterator();
                        NetbeansActionMapping netbeansActionMapping = null;
                        while (iterator.hasNext()) {
                            NetbeansActionMapping netbeansActionMapping2 = iterator.next();
                            if (!string.equals(netbeansActionMapping2.getActionName())) continue;
                            netbeansActionMapping = netbeansActionMapping2;
                            break;
                        }
                        if (netbeansActionMapping != null) {
                            actionToGoalMapping2.getActions().set(actionToGoalMapping2.getActions().indexOf(netbeansActionMapping), this.mapping);
                        } else {
                            actionToGoalMapping2.addAction(this.mapping);
                        }
                        this.mapping.setDisplayName(runGoalsPanel.isRememberedAs());
                        CustomizerProviderImpl.writeNbActionsModel(ActionProviderImpl.this.project, actionToGoalMapping2, M2Configuration.getFileNameExt(M2Configuration.DEFAULT));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                object2 = new ModelRunConfig(ActionProviderImpl.this.project, this.mapping, this.mapping.getActionName(), null);
                ((BeanRunConfig)object2).setOffline(runGoalsPanel.isOffline());
                ((BeanRunConfig)object2).setShowDebug(runGoalsPanel.isShowDebug());
                ((BeanRunConfig)object2).setRecursive(runGoalsPanel.isRecursive());
                ((BeanRunConfig)object2).setUpdateSnapshots(runGoalsPanel.isUpdateSnapshots());
                ((BeanRunConfig)object2).setTaskDisplayName(NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Build"));
                ActionProviderImpl.this.setupTaskName("custom", (RunConfig)object2, Lookup.EMPTY);
                ActionProviderImpl.this.runGoal(Lookup.EMPTY, (RunConfig)object2, false);
            }
        }
    }

    private static final class BasicAction
    extends AbstractAction
    implements ContextAwareAction {
        private String actionid;
        private Lookup context;
        private ActionProviderImpl provider;

        private BasicAction(String string, String string2) {
            this.actionid = string2;
            this.putValue("Name", string);
        }

        private BasicAction(String string, String string2, Lookup lookup) {
            this(string, string2);
            Lookup.Result result = lookup.lookup(new Lookup.Template(Project.class));
            if (result.allItems().size() == 1) {
                Project project = (Project)lookup.lookup(Project.class);
                this.context = project.getLookup();
                this.provider = (ActionProviderImpl)this.context.lookup(ActionProviderImpl.class);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.provider != null) {
                this.provider.invokeAction(this.actionid, this.context);
            }
        }

        public boolean isEnabled() {
            if (this.provider != null) {
                return this.provider.isActionEnabled(this.actionid, this.provider.project.getLookup());
            }
            return false;
        }

        public Action createContextAwareInstance(Lookup lookup) {
            return new BasicAction((String)this.getValue("Name"), this.actionid, lookup);
        }
    }
}

