/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.ui.options.AddCompilerSetPanel;
import org.netbeans.modules.cnd.ui.options.DuplicateCompilerSetPanel;
import org.netbeans.modules.cnd.ui.options.GlobalToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.IsChangedListener;
import org.netbeans.modules.cnd.ui.options.ServerListUIEx;
import org.netbeans.modules.cnd.ui.options.ToolCollectionPanel;
import org.netbeans.modules.cnd.ui.options.ToolsCacheManager;
import org.netbeans.modules.cnd.ui.options.ToolsPanelGlobalCustomizer;
import org.netbeans.modules.cnd.ui.options.ToolsPanelModel;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.windows.WindowManager;

public final class ToolsPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ItemListener {
    public static final String PROP_VALID = "valid";
    private boolean initialized = false;
    private boolean changed;
    private boolean changingCompilerSet;
    private boolean updating;
    private ValidState valid = ValidState.UNKNOWN;
    private ToolsPanelModel model = null;
    private boolean customizeDebugger;
    private ExecutionEnvironment execEnv;
    private static ToolsPanel instance = null;
    private CompilerSetManager csm;
    private CompilerSet currentCompilerSet;
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    private static final ToolsCacheManager cacheManager = new ToolsCacheManager();
    static Set<ChangeListener> listenerChanged = new HashSet<ChangeListener>();
    private static final Set<ChangeListener> listenerModified = new WeakSet();
    private static final Set<IsChangedListener> listenerIsChanged = new WeakSet();
    private JPanel ToolSetPanel;
    private JButton btAdd;
    private JButton btDefault;
    private JButton btDuplicate;
    private JButton btEditDevHost;
    private JButton btRemove;
    private JButton btRestore;
    private JButton btVersions;
    private JPanel buttomPanel;
    private JPanel buttonPanel;
    private JComboBox cbDevHost;
    private JLabel lbDevHost;
    private JLabel lbToolCollections;
    private JLabel lblErrors;
    private JList lstDirlist;
    private JScrollPane spDirlist;
    private JPanel toolCollectionPanel;

    public ToolsPanel() {
        this.initComponents();
        this.setName("TAB_ToolsTab");
        this.changed = false;
        instance = this;
        this.currentCompilerSet = null;
        if (cacheManager.isRemoteAvailable()) {
            this.execEnv = cacheManager.getDefaultHostEnvironment();
            this.btEditDevHost.setEnabled(true);
            this.cbDevHost.setEnabled(true);
        } else {
            this.execEnv = ExecutionEnvironmentFactory.getLocal();
        }
        this.lstDirlist.setCellRenderer(new MyCellRenderer());
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
        HelpCtx.setHelpIDString((JComponent)this, (String)"ResolveBuildTools");
    }

    public ToolsPanel(ToolsPanelModel toolsPanelModel) {
        this();
        this.model = toolsPanelModel;
    }

    private void initializeLong() {
        this.csm = cacheManager.getCompilerSetManagerCopy(this.execEnv, true);
    }

    ToolsPanelModel getModel() {
        return this.model;
    }

    ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    private void initializeUI() {
        if (instance == null) {
            instance = this;
        }
        this.changingCompilerSet = true;
        if (this.model == null) {
            this.model = new GlobalToolsPanelModel();
        }
        this.cbDevHost.removeItemListener(this);
        ExecutionEnvironment executionEnvironment = this.model.getSelectedDevelopmentHost();
        ServerRecord serverRecord = null;
        Collection<? extends ServerRecord> collection = cacheManager.getHosts();
        if (collection != null) {
            this.cbDevHost.removeAllItems();
            for (ServerRecord serverRecord2 : collection) {
                if (serverRecord2.getExecutionEnvironment().equals(executionEnvironment)) {
                    serverRecord = serverRecord2;
                }
                this.cbDevHost.addItem(serverRecord2);
            }
        } else {
            this.cbDevHost.addItem(ServerList.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()));
        }
        if (serverRecord != null) {
            this.cbDevHost.setSelectedItem(serverRecord);
        } else {
            this.cbDevHost.setSelectedItem(cacheManager.getDefaultHostRecord());
        }
        this.cbDevHost.setRenderer(new MyDevHostListCellRenderer());
        this.cbDevHost.addItemListener(this);
        this.cbDevHost.setEnabled(this.model.getEnableDevelopmentHostChange());
        this.btEditDevHost.setEnabled(this.model.getEnableDevelopmentHostChange());
        this.execEnv = this.getSelectedRecord().getExecutionEnvironment();
        this.btVersions.setEnabled(false);
        this.initCustomizableDebugger();
        this.getToolCollectionPanel().initializeUI();
    }

    private ToolCollectionPanel getToolCollectionPanel() {
        return (ToolCollectionPanel)this.toolCollectionPanel;
    }

    private void addCompilerSet() {
        if (this.csm == null) {
            return;
        }
        AddCompilerSetPanel addCompilerSetPanel = new AddCompilerSetPanel(this.csm);
        String string = this.isRemoteHostSelected() ? ToolsPanel.getString("NEW_TOOL_SET_TITLE_REMOTE", ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.csm.getExecutionEnvironment())) : ToolsPanel.getString("NEW_TOOL_SET_TITLE");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addCompilerSetPanel, string);
        addCompilerSetPanel.setDialogDescriptor(dialogDescriptor);
        boolean bl = cacheManager.isDevHostValid(this.execEnv);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            boolean bl2 = cacheManager.isDevHostValid(this.execEnv);
            if (bl != bl2) {
                this.dataValid();
            }
            return;
        }
        final CompilerSet compilerSet = addCompilerSetPanel.getCompilerSet();
        this.updating = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ToolsPanel.this.csm.add(compilerSet);
                ToolsPanel.this.changed = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ToolsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                        ToolsPanel.this.update(false, compilerSet);
                    }
                });
            }
        });
    }

    private void duplicateCompilerSet() {
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        DuplicateCompilerSetPanel duplicateCompilerSetPanel = new DuplicateCompilerSetPanel(this.csm, compilerSet);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)duplicateCompilerSetPanel, ToolsPanel.getString("COPY_TOOL_SET_TITLE"));
        duplicateCompilerSetPanel.setDialogDescriptor(dialogDescriptor);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        String string = duplicateCompilerSetPanel.getCompilerSetName().trim();
        CompilerSet compilerSet2 = compilerSet.createCopy();
        compilerSet2.setName(string);
        compilerSet2.unsetDefault();
        compilerSet2.setAutoGenerated(false);
        this.csm.add(compilerSet2);
        this.changed = true;
        this.update(false, compilerSet2);
    }

    private void onCompilerSetChanged() {
        boolean bl = this.model.showRequiredTools() ? this.lstDirlist.getSelectedIndex() >= 0 : this.csm.getCompilerSets().size() > 1 && this.lstDirlist.getSelectedIndex() >= 0;
        this.changeCompilerSet((CompilerSet)this.lstDirlist.getSelectedValue());
        this.btAdd.setEnabled(this.isHostValidForEditing());
        this.btRemove.setEnabled(bl && this.isHostValidForEditing());
        this.btDuplicate.setEnabled(this.lstDirlist.getSelectedIndex() >= 0 && this.isHostValidForEditing());
        this.btDefault.setEnabled(this.lstDirlist.getSelectedIndex() >= 0 && !((CompilerSet)this.lstDirlist.getSelectedValue()).isDefault());
    }

    private void onNewDevHostSelected() {
        if (!this.execEnv.equals(this.getSelectedRecord().getExecutionEnvironment())) {
            log.fine("TP.itemStateChanged: About to update");
            this.changed = true;
            if (!cacheManager.hasCache()) {
                ArrayList<ServerRecord> arrayList = new ArrayList<ServerRecord>(this.cbDevHost.getItemCount());
                for (int i = 0; i < this.cbDevHost.getItemCount(); ++i) {
                    arrayList.add((ServerRecord)this.cbDevHost.getItemAt(i));
                }
                cacheManager.setHosts(arrayList);
            }
            cacheManager.setDefaultRecord((ServerRecord)this.cbDevHost.getSelectedItem());
            this.execEnv = this.getSelectedRecord().getExecutionEnvironment();
            this.model.setSelectedDevelopmentHost(this.execEnv);
            this.update(true);
        } else {
            this.update(false);
        }
    }

    private void removeCompilerSet() {
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        if (compilerSet != null) {
            int n = this.csm.getCompilerSets().indexOf(compilerSet);
            this.csm.remove(compilerSet);
            if (compilerSet.isDefault() && this.csm.getCompilerSets().size() > 0) {
                this.csm.setDefault(this.csm.getCompilerSet(0));
            }
            if (n >= 0 && n < this.csm.getCompilerSets().size()) {
                this.update(false, this.csm.getCompilerSets().get(n));
            } else if (n > 0) {
                this.update(false, this.csm.getCompilerSets().get(n - 1));
            } else {
                this.getToolCollectionPanel().removeCompilerSet();
                this.update(false);
            }
            this.changed = true;
        }
    }

    private void setSelectedAsDefault() {
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        this.csm.setDefault(compilerSet);
        this.changed = true;
        this.update(false);
    }

    public static boolean supportedMake(String string) {
        return !(string = IpeUtils.getBaseName(string)).toLowerCase().equals("mingw32-make.exe");
    }

    public void update() {
        this.update(true, null);
    }

    private void update(boolean bl) {
        this.update(bl, null);
    }

    public void update(final boolean bl, final CompilerSet compilerSet) {
        this.updating = true;
        if (!this.initialized || bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ToolsPanel.this.initializeLong();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ToolsPanel.this.initializeUI();
                            ToolsPanel.this.updateUI(bl, compilerSet);
                            ToolsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    });
                }
            });
        } else {
            this.updateUI(bl, compilerSet);
        }
    }

    private void updateUI(boolean bl, CompilerSet compilerSet) {
        this.getToolCollectionPanel().updateUI(bl, compilerSet);
        if (bl && !this.csm.getCompilerSets().isEmpty()) {
            String string;
            if (this.csm.getDefaultCompilerSet() == null) {
                string = this.model.getCompilerSetName();
                if (string.length() == 0 || this.csm.getCompilerSet(string) == null) {
                    this.csm.setDefault(this.csm.getCompilerSet(0));
                } else {
                    this.csm.setDefault(this.csm.getCompilerSet(string));
                }
            }
            if ((string = this.model.getSelectedCompilerSetName()) != null) {
                compilerSet = this.csm.getCompilerSet(string);
            }
            if (compilerSet == null) {
                compilerSet = this.csm.getDefaultCompilerSet();
            }
        }
        if (compilerSet == null) {
            compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        }
        this.lstDirlist.setListData(this.csm.getCompilerSets().toArray());
        if (compilerSet != null) {
            this.lstDirlist.setSelectedValue(compilerSet, true);
        }
        if (this.lstDirlist.getSelectedIndex() < 0) {
            this.lstDirlist.setSelectedIndex(0);
        }
        this.lstDirlist.invalidate();
        this.lstDirlist.repaint();
        this.onCompilerSetChanged();
        this.updating = false;
        this.dataValid();
        this.initialized = true;
    }

    boolean isRemoteHostSelected() {
        return ((ServerRecord)this.cbDevHost.getSelectedItem()).isRemote();
    }

    private ServerRecord getSelectedRecord() {
        return (ServerRecord)this.cbDevHost.getSelectedItem();
    }

    private boolean isHostValidForEditing() {
        return true;
    }

    private void changeCompilerSet(CompilerSet compilerSet) {
        this.getToolCollectionPanel().preChangeCompilerSet(compilerSet);
        if (compilerSet == null) {
            String string = "";
            if (!cacheManager.isDevHostValid(this.execEnv)) {
                string = NbBundle.getMessage(ToolsPanel.class, (String)"TP_ErrorMessage_BadDevHost", (Object)this.execEnv.toString());
            }
            this.lblErrors.setText("<html>" + string + "</html>");
            this.updateToolsControls(false, false, false, true);
            return;
        }
        if (this.currentCompilerSet != null && this.currentCompilerSet != compilerSet) {
            this.getToolCollectionPanel().updateCompilerSet(this.currentCompilerSet, false);
        }
        this.changingCompilerSet = true;
        this.getToolCollectionPanel().changeCompilerSet(compilerSet);
        this.changingCompilerSet = false;
        this.currentCompilerSet = compilerSet;
        this.fireCompilerSetChange();
        this.dataValid();
    }

    public void applyChanges(boolean bl) {
        this.changed = bl;
        this.applyChanges();
    }

    public void applyChanges() {
        if (this.changed || this.isChangedInOtherPanels()) {
            CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
            this.changed = false;
            if (compilerSet != null) {
                this.getToolCollectionPanel().updateCompilerSet(compilerSet, true);
                this.model.setCompilerSetName(this.csm.getDefaultCompilerSet().getName());
                this.model.setSelectedCompilerSetName(compilerSet.getName());
            }
            this.currentCompilerSet = compilerSet;
            cacheManager.applyChanges((ServerRecord)this.cbDevHost.getSelectedItem());
        }
        this.getToolCollectionPanel().applyChanges();
        instance = null;
    }

    public void cancel() {
        cacheManager.clear();
        this.changed = false;
        instance = null;
    }

    public static ToolsPanel getToolsPanel() {
        return instance;
    }

    public static ToolsCacheManager getToolsCacheManager() {
        return cacheManager;
    }

    public CompilerSet getCurrentCompilerSet() {
        return this.currentCompilerSet;
    }

    CompilerSetManager getCompilerSetManager() {
        return this.csm;
    }

    boolean isUpdatindOrChangingCompilerSet() {
        return this.updating || this.changingCompilerSet;
    }

    public boolean dataValid() {
        int n;
        if (this.csm.getCompilerSets().size() == 0) {
            if (this.valid != ValidState.INVALID) {
                this.valid = ValidState.INVALID;
                this.firePropertyChange(PROP_VALID, true, false);
            }
            return false;
        }
        if (this.updating || this.changingCompilerSet) {
            return true;
        }
        boolean bl = this.csm.getCompilerSets().size() > 0;
        boolean bl2 = this.getToolCollectionPanel().isToolsValid();
        boolean bl3 = cacheManager.isDevHostValid(this.execEnv);
        if (bl && bl2 && bl3) {
            if (this.valid != ValidState.VALID) {
                this.valid = ValidState.VALID;
                this.firePropertyChange(PROP_VALID, false, true);
            }
        } else if (this.valid != ValidState.INVALID) {
            this.valid = ValidState.INVALID;
            this.firePropertyChange(PROP_VALID, true, false);
        }
        this.lblErrors.setText("<html>");
        if (this.valid == ValidState.INVALID) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!bl3) {
                arrayList.add(NbBundle.getMessage(ToolsPanel.class, (String)"TP_ErrorMessage_BadDevHost", (Object)this.execEnv.toString()));
            }
            this.getToolCollectionPanel().getErrors(arrayList);
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < arrayList.size(); ++n) {
                stringBuilder.append(arrayList.get(n));
                if (n >= arrayList.size() - 1) continue;
                stringBuilder.append("<br>");
            }
            this.lblErrors.setText("<html>" + stringBuilder.toString() + "</html>");
            this.validate();
            this.repaint();
        } else {
            this.lblErrors.setText("");
        }
        boolean bl4 = this.getToolCollectionPanel().isBaseDirValid();
        boolean bl5 = bl4 || this.isRemoteHostSelected() && this.isHostValidForEditing();
        n = bl4 && !this.isRemoteHostSelected() ? 1 : 0;
        boolean bl6 = (bl4 || this.isRemoteHostSelected()) && this.isHostValidForEditing();
        this.updateToolsControls(bl5, n != 0, bl6, false);
        return this.valid == ValidState.VALID;
    }

    private void updateToolsControls(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.btVersions.setEnabled(bl3);
        this.getToolCollectionPanel().updateToolsControls(bl, bl2, bl3, bl4);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public static void addCompilerSetChangeListener(ChangeListener changeListener) {
        listenerChanged.add(changeListener);
    }

    public static void removeCompilerSetChangeListener(ChangeListener changeListener) {
        listenerChanged.remove(changeListener);
    }

    public void fireCompilerSetChange() {
        ChangeEvent changeEvent = new ChangeEvent(this.currentCompilerSet);
        for (ChangeListener changeListener : listenerChanged) {
            changeListener.stateChanged(changeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCompilerSetModifiedListener(ChangeListener changeListener) {
        Set<ChangeListener> set = listenerModified;
        synchronized (set) {
            listenerModified.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCompilerSetModifiedListener(ChangeListener changeListener) {
        Set<ChangeListener> set = listenerModified;
        synchronized (set) {
            listenerModified.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCompilerSetModified() {
        ChangeEvent changeEvent = new ChangeEvent(this.currentCompilerSet);
        Set<ChangeListener> set = listenerModified;
        synchronized (set) {
            for (ChangeListener changeListener : listenerModified) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIsChangedListener(IsChangedListener isChangedListener) {
        Set<IsChangedListener> set = listenerIsChanged;
        synchronized (set) {
            listenerIsChanged.add(isChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeIsChangedListener(IsChangedListener isChangedListener) {
        Set<IsChangedListener> set = listenerIsChanged;
        synchronized (set) {
            listenerIsChanged.remove(isChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isChangedInOtherPanels() {
        boolean bl = false;
        Set<IsChangedListener> set = listenerIsChanged;
        synchronized (set) {
            for (IsChangedListener isChangedListener : listenerIsChanged) {
                if (!isChangedListener.isChanged()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.btAdd) {
                this.addCompilerSet();
            } else if (object == this.btRemove) {
                this.removeCompilerSet();
            } else if (object == this.btDuplicate) {
                this.duplicateCompilerSet();
            } else if (object == this.btEditDevHost) {
                this.editDevHosts();
            } else if (object == this.btDefault) {
                this.setSelectedAsDefault();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (!this.updating && object == this.cbDevHost && itemEvent.getStateChange() == 1) {
            this.onNewDevHostSelected();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && !this.updating && listSelectionEvent.getSource() == this.lstDirlist) {
            this.onCompilerSetChanged();
        }
    }

    private void editDevHosts() {
        if (ServerListUIEx.showServerListDialog(cacheManager, null)) {
            this.changed = true;
            this.cbDevHost.removeItemListener(this);
            log.fine("TP.editDevHosts: Removing all items from cbDevHost");
            this.cbDevHost.removeAllItems();
            log.fine("TP.editDevHosts: Adding " + cacheManager.getHosts().size() + " items to cbDevHost");
            for (ServerRecord serverRecord : cacheManager.getHosts()) {
                log.fine("    Adding " + serverRecord);
                this.cbDevHost.addItem(serverRecord);
            }
            log.fine("TP.editDevHosts: cbDevHost has " + this.cbDevHost.getItemCount() + " items");
            log.fine("TP.editDevHosts: getDefaultHostRecord returns " + cacheManager.getDefaultHostRecord());
            this.cbDevHost.setSelectedItem(cacheManager.getDefaultHostRecord());
            cacheManager.ensureHostSetup(this.getSelectedRecord().getExecutionEnvironment());
            this.cbDevHost.addItemListener(this);
            this.onNewDevHostSelected();
        }
    }

    private void initComponents() {
        this.lbToolCollections = new JLabel();
        this.buttomPanel = new JPanel();
        this.lblErrors = new JLabel();
        this.btVersions = new JButton();
        this.btRestore = new JButton();
        this.ToolSetPanel = new JPanel();
        this.spDirlist = new JScrollPane(this.lstDirlist);
        this.lstDirlist = new JList();
        this.buttonPanel = new JPanel();
        this.btAdd = new JButton();
        this.btAdd.addActionListener(this);
        this.btRemove = new JButton();
        this.btRemove.addActionListener(this);
        this.btDuplicate = new JButton();
        this.btDuplicate.addActionListener(this);
        this.btDefault = new JButton();
        this.btDefault.addActionListener(this);
        this.lbDevHost = new JLabel();
        this.cbDevHost = new JComboBox();
        this.cbDevHost.addItemListener(this);
        this.btEditDevHost = new JButton();
        this.btEditDevHost.addActionListener(this);
        this.toolCollectionPanel = new ToolCollectionPanel(this);
        this.setMinimumSize(new Dimension(600, 400));
        this.setLayout(new GridBagLayout());
        this.lbToolCollections.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_DirlistLabel").charAt(0));
        this.lbToolCollections.setLabelFor(this.spDirlist);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle");
        this.lbToolCollections.setText(resourceBundle.getString("LBL_DirlistLabel"));
        this.lbToolCollections.setToolTipText(resourceBundle.getString("HINT_DirListLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 0, 4);
        this.add((Component)this.lbToolCollections, gridBagConstraints);
        this.lbToolCollections.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_DirlistLabel"));
        this.lbToolCollections.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_DirlistLabel"));
        this.buttomPanel.setOpaque(false);
        this.buttomPanel.setLayout(new GridBagLayout());
        this.lblErrors.setForeground(new Color(255, 51, 51));
        this.lblErrors.setHorizontalAlignment(2);
        this.lblErrors.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lblErrors.text"));
        this.lblErrors.setEnabled(false);
        this.lblErrors.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.buttomPanel.add((Component)this.lblErrors, gridBagConstraints);
        this.lblErrors.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lblErrors.AccessibleContext.accessibleName"));
        this.btVersions.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_Versions").charAt(0));
        this.btVersions.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btVersions.text"));
        this.btVersions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btVersionsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        this.buttomPanel.add((Component)this.btVersions, gridBagConstraints);
        this.btVersions.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btVersions.AccessibleContext.accessibleDescription"));
        this.btRestore.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_RestoreDefault_BT").charAt(0));
        this.btRestore.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btRestore.text"));
        this.btRestore.setHorizontalAlignment(4);
        this.btRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btRestoreActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.buttomPanel.add((Component)this.btRestore, gridBagConstraints);
        this.btRestore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btRestore.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.buttomPanel, gridBagConstraints);
        this.ToolSetPanel.setOpaque(false);
        this.ToolSetPanel.setLayout(new GridBagLayout());
        this.spDirlist.setMinimumSize(new Dimension(180, 20));
        this.spDirlist.setPreferredSize(new Dimension(180, 20));
        this.lstDirlist.setSelectionMode(0);
        this.lstDirlist.setAutoscrolls(false);
        this.lstDirlist.addListSelectionListener(this);
        this.spDirlist.setViewportView(this.lstDirlist);
        this.lstDirlist.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lstDirlist.AccessibleContext.accessibleName"));
        this.lstDirlist.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lstDirlist.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.ToolSetPanel.add((Component)this.spDirlist, gridBagConstraints);
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.btAdd.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_AddButton").charAt(0));
        this.btAdd.setText(resourceBundle.getString("LBL_AddButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.btAdd, gridBagConstraints);
        this.btAdd.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_AddButton"));
        this.btAdd.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_AddButton"));
        this.btRemove.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_RemoveButton").charAt(0));
        this.btRemove.setText(resourceBundle.getString("LBL_RemoveButton"));
        this.btRemove.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.btRemove, gridBagConstraints);
        this.btRemove.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_RemoveButton"));
        this.btRemove.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_RemoveButton"));
        this.btDuplicate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_UpButton").charAt(0));
        this.btDuplicate.setText(resourceBundle.getString("LBL_UpButton"));
        this.btDuplicate.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.buttonPanel.add((Component)this.btDuplicate, gridBagConstraints);
        this.btDuplicate.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_UpButton"));
        this.btDuplicate.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_UpButton"));
        this.btDefault.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_DownButton").charAt(0));
        this.btDefault.setText(resourceBundle.getString("LBL_DownButton"));
        this.btDefault.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.buttonPanel.add((Component)this.btDefault, gridBagConstraints);
        this.btDefault.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_DownButton"));
        this.btDefault.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_DownButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.ToolSetPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.ToolSetPanel, gridBagConstraints);
        this.lbDevHost.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_DevelopmentHosts").charAt(0));
        this.lbDevHost.setLabelFor(this.cbDevHost);
        this.lbDevHost.setText(NbBundle.getMessage(ToolsPanel.class, (String)"LBL_DevelopmentHosts"));
        this.lbDevHost.setToolTipText(NbBundle.getMessage(ToolsPanel.class, (String)"HINT_DevelopmentHosts"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.add((Component)this.lbDevHost, gridBagConstraints);
        this.cbDevHost.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.cbDevHost, gridBagConstraints);
        this.btEditDevHost.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_AddDevHost").charAt(0));
        this.btEditDevHost.setText(NbBundle.getMessage(ToolsPanel.class, (String)"Lbl_AddDevHost"));
        this.btEditDevHost.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btEditDevHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.toolCollectionPanel, gridBagConstraints);
    }

    private void btVersionsActionPerformed(ActionEvent actionEvent) {
        this.btVersions.setEnabled(false);
        final CompilerSet compilerSet = this.currentCompilerSet;
        if (compilerSet == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                String string = ToolsPanel.this.getToolCollectionPanel().getVersion(compilerSet);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ToolsPanel.this.btVersions.setEnabled(true);
                        ToolsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
                message.setTitle(ToolsPanel.getString("LBL_VersionInfo_Title"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    private void initCustomizableDebugger() {
        ToolsPanelGlobalCustomizer toolsPanelGlobalCustomizer = (ToolsPanelGlobalCustomizer)Lookup.getDefault().lookup(ToolsPanelGlobalCustomizer.class);
        this.customizeDebugger = toolsPanelGlobalCustomizer == null ? true : toolsPanelGlobalCustomizer.isDebuggerCustomizable();
    }

    boolean isCustomizableDebugger() {
        return this.customizeDebugger;
    }

    private void btRestoreActionPerformed(ActionEvent actionEvent) {
        if (this.csm == null) {
            return;
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)ToolsPanel.getString("RESTORE_TXT"), ToolsPanel.getString("RESTORE_TITLE"), 2);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object != NotifyDescriptor.OK_OPTION) {
            return;
        }
        final CompilerSet[] compilerSetArray = new CompilerSet[]{(CompilerSet)this.lstDirlist.getSelectedValue()};
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Runnable runnable = new Runnable(){

            public void run() {
                Object object;
                String string;
                CompilerSet compilerSet2;
                log.finest("Restoring defaults\n");
                ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)ToolsPanel.this.execEnv);
                if (serverRecord.isOffline()) {
                    serverRecord.validate(true);
                    if (serverRecord.isOffline()) {
                        atomicBoolean.set(true);
                        return;
                    }
                }
                CompilerSetManager compilerSetManager = CompilerSetManager.create(ToolsPanel.this.execEnv);
                compilerSetManager.initialize(false, true);
                while (compilerSetManager.isPending()) {
                    log.finest("\twaiting for compiler manager to initialize...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        atomicBoolean.set(true);
                        return;
                    }
                }
                cacheManager.addCompilerSetManager(compilerSetManager);
                List<CompilerSet> list = ToolsPanel.this.csm.getCompilerSets();
                for (CompilerSet compilerSet2 : list) {
                    if (compilerSet2.isAutoGenerated()) continue;
                    string = compilerSet2.getName();
                    if (!string.equals(object = compilerSetManager.getUniqueCompilerSetName(string))) {
                        compilerSet2.setName((String)object);
                    }
                    compilerSetManager.add(compilerSet2);
                }
                Object object2 = null;
                compilerSet2 = ToolsPanel.this.csm.getDefaultCompilerSet();
                if (compilerSet2 != null) {
                    object2 = compilerSet2.getName();
                }
                string = null;
                if (compilerSetArray[0] != null) {
                    string = compilerSetArray[0].getName();
                }
                ToolsPanel.this.csm = compilerSetManager;
                object = ToolsPanel.this.csm.getCompilerSet((String)object2);
                if (object != null) {
                    ToolsPanel.this.csm.setDefault((CompilerSet)object);
                }
                if (string != null) {
                    compilerSetArray[0] = ToolsPanel.this.csm.getCompilerSet(string);
                }
                if (ToolsPanel.this.execEnv.isLocal()) {
                    WindowsSupport.getInstance().init();
                }
                log.finest("Restored defaults\n");
            }
        };
        Runnable runnable2 = new Runnable(){

            public void run() {
                if (!atomicBoolean.get()) {
                    ToolsPanel.this.changed = true;
                    if (compilerSetArray[0] != null) {
                        ToolsPanel.this.update(false, compilerSetArray[0]);
                    } else {
                        ToolsPanel.this.update(false);
                    }
                }
            }
        };
        Frame frame = WindowManager.getDefault().getMainWindow();
        String string = ToolsPanel.getString("TITLE_Configure");
        String string2 = ToolsPanel.getString("MSG_Configure_Compiler_Sets", this.execEnv.toString());
        ModalMessageDlg.runLongTask((Frame)frame, (Runnable)runnable, (Runnable)runnable2, null, (String)string, (String)string2);
    }

    static String getString(String string) {
        return NbBundle.getMessage(ToolsPanel.class, (String)string);
    }

    static String getString(String string, Object object) {
        return NbBundle.getMessage(ToolsPanel.class, (String)string, (Object)object);
    }

    static String getString(String string, Object object, Object object2) {
        return NbBundle.getMessage(ToolsPanel.class, (String)string, (Object)object, (Object)object2);
    }

    static String getString(String string, Object object, Object object2, Object object3) {
        return NbBundle.getMessage(ToolsPanel.class, (String)string, (Object)object, (Object)object2, (Object)object3);
    }

    static class MyDevHostListCellRenderer
    extends DefaultListCellRenderer {
        MyDevHostListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            ServerRecord serverRecord = (ServerRecord)object;
            jLabel.setText(serverRecord.getDisplayName());
            if (object != null && object.equals(cacheManager.getDefaultHostRecord())) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            return jLabel;
        }
    }

    static class MyCellRenderer
    extends DefaultListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            CompilerSet compilerSet = (CompilerSet)object;
            if (compilerSet != null && compilerSet.isDefault()) {
                component.setFont(component.getFont().deriveFont(1));
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValidState {
        VALID,
        INVALID,
        UNKNOWN;

    }
}

