/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.lang.ref.WeakReference;
import java.util.Vector;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.editor.parser.CppMetaModel;
import org.netbeans.modules.cnd.editor.parser.ParsingEvent;
import org.netbeans.modules.cnd.editor.parser.ParsingListener;
import org.netbeans.modules.cnd.loaders.CndDataObject;
import org.netbeans.modules.cnd.loaders.CppEditorActivationPerformer;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.openide.ErrorManager;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Utilities;
import org.openide.windows.CloneableOpenSupport;

public class CppEditorSupport
extends DataEditorSupport
implements EditorCookie,
EditorCookie.Observable,
OpenCookie,
CloseCookie,
PrintCookie {
    private long lastModified = 0L;
    private ParsingListener wParsingL;
    private boolean parsingAttached;
    private static final ErrorManager log = ErrorManager.getDefault().getInstance("CppFoldTracer");
    private final ParsingListener listener = new ParsingListener(){

        public void objectParsed(ParsingEvent parsingEvent) {
            log.log("CES$ParserListener.objectParsed: " + parsingEvent);
        }
    };
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            CppEditorSupport.this.saveDocument();
            CppEditorSupport.this.getDataObject().setModified(false);
        }
    };
    private boolean componentsCreated = false;
    static Vector<CppEditorActivationPerformer> activationPerformers = null;

    public CppEditorSupport(DataObject dataObject) {
        super(dataObject, (CloneableEditorSupport.Env)new Environment(dataObject));
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!CppEditorSupport.this.isDocumentLoaded()) {
                    CppEditorSupport.this.notifyClose();
                }
            }
        });
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.lastModified = System.currentTimeMillis();
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    protected boolean asynchronousOpen() {
        return true;
    }

    private void addSaveCookie() {
        CndDataObject cndDataObject = (CndDataObject)this.getDataObject();
        if (cndDataObject.getCookie(SaveCookie.class) == null) {
            cndDataObject.addSaveCookie(this.saveCookie);
        }
    }

    private void removeSaveCookie() {
        CndDataObject cndDataObject = (CndDataObject)this.getDataObject();
        Node.Cookie cookie = cndDataObject.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            cndDataObject.removeSaveCookie(this.saveCookie);
        }
    }

    protected void notifyClose() {
        this.componentsCreated = false;
    }

    protected CloneableEditor createCloneableEditor() {
        return new CppEditorComponent((CloneableEditorSupport)this);
    }

    public static void addActivationPerformer(CppEditorActivationPerformer cppEditorActivationPerformer) {
        if (activationPerformers == null) {
            activationPerformers = new Vector(2);
        }
        activationPerformers.add(cppEditorActivationPerformer);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    private synchronized void attachParsingListener() {
        if (!this.parsingAttached) {
            if (this.wParsingL == null) {
                this.wParsingL = new WParsingListener(this.listener);
            }
            CppMetaModel.getDefault().addParsingListener(this.wParsingL);
            this.parsingAttached = true;
        }
    }

    private synchronized void removeParsingListener() {
        if (this.parsingAttached) {
            CppMetaModel.getDefault().removeParsingListener(this.wParsingL);
            this.parsingAttached = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WParsingListener
    extends WeakReference<ParsingListener>
    implements ParsingListener,
    Runnable {
        WParsingListener(ParsingListener parsingListener) {
            super(parsingListener, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            CppMetaModel.getDefault().removeParsingListener(this);
        }

        ParsingListener getListener() {
            Object t = this.get();
            if (t == null) {
                CppMetaModel.getDefault().removeParsingListener(this);
            }
            return (ParsingListener)t;
        }

        @Override
        public void objectParsed(ParsingEvent parsingEvent) {
            ParsingListener parsingListener = this.getListener();
            if (parsingListener != null) {
                parsingListener.objectParsed(parsingEvent);
            }
        }
    }

    public static class CppEditorComponent
    extends CloneableEditor {
        CppEditorSupport support = null;

        public CppEditorComponent() {
            this.initialize();
        }

        public CppEditorComponent(CloneableEditorSupport cloneableEditorSupport) {
            super(cloneableEditorSupport);
            this.initialize();
        }

        public CppEditorSupport getSupport() {
            return this.support;
        }

        private void initialize() {
            this.support = (CppEditorSupport)this.cloneableEditorSupport();
        }

        protected void componentActivated() {
            super.componentActivated();
            StyledDocument styledDocument = this.support.getDocument();
            if (styledDocument != null) {
                log.log("CES.componentActivated: Activating " + CppEditorComponent.getShortName(styledDocument) + " [" + Thread.currentThread().getName() + "]");
                if (activationPerformers != null) {
                    int n = activationPerformers.size();
                    for (int i = 0; i < n; ++i) {
                        CppEditorActivationPerformer cppEditorActivationPerformer = activationPerformers.get(i);
                        cppEditorActivationPerformer.performActivation(this);
                    }
                }
                CppMetaModel.getDefault().scheduleParsing(styledDocument);
                this.support.attachParsingListener();
            } else {
                log.log("CES.componentActivated: Activating without document!!! [" + Thread.currentThread().getName() + "]");
            }
        }

        private static String getShortName(Document document) {
            String string = (String)document.getProperty("title");
            string = string == null ? "" : string;
            int n = string.lastIndexOf(File.separatorChar);
            if (n != -1) {
                return string.substring(n + 1);
            }
            return string;
        }

        public int getLineNumber() {
            int n = NbDocument.findLineNumber((StyledDocument)this.support.getDocument(), (int)this.getEditorPane().getCaret().getDot());
            return n;
        }

        protected void componentDeactivated() {
            super.componentDeactivated();
            this.support.removeParsingListener();
        }

        protected boolean closeLast() {
            if (!super.closeLast()) {
                return false;
            }
            if (this.support != null) {
                this.support.componentsCreated = false;
            }
            return true;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.initialize();
        }
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(DataObject dataObject) {
            super(dataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            ReadOnlySupport readOnlySupport = (ReadOnlySupport)this.getDataObject().getLookup().lookup(ReadOnlySupport.class);
            if (readOnlySupport != null && readOnlySupport.isReadOnly()) {
                throw new IOException();
            }
            return ((CndDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(CppEditorSupport.class);
        }
    }
}

