/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.execution.NativeExecution;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class LocalNativeExecution
extends NativeExecution {
    private static ResourceBundle bundle = NbBundle.getBundle(LocalNativeExecution.class);
    private OutputReaderThread outputReaderThread = null;
    private InputReaderThread inputReaderThread = null;
    private volatile Thread executionThread = null;
    private static Logger execLog;
    private final File runDirFile;
    private final String executable;
    private final String arguments;
    private final String[] envp;
    private final boolean unbuffer;

    LocalNativeExecution(ExecutionEnvironment executionEnvironment, File file, String string, String string2, String[] stringArray, boolean bl, boolean bl2) {
        assert (executionEnvironment.isLocal());
        this.runDirFile = file;
        this.executable = string;
        this.arguments = string2;
        this.envp = stringArray;
        this.unbuffer = bl;
    }

    public int execute(PrintWriter printWriter, Reader reader) throws IOException, InterruptedException {
        int n = -1;
        if (!this.runDirFile.exists() || !this.runDirFile.isDirectory()) {
            String string = MessageFormat.format(LocalNativeExecution.getString("NOT_A_VALID_BUILD_DIRECTORY"), this.runDirFile.getPath());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return -1;
        }
        Process process = this.exec(this.executable, this.arguments, this.envp, this.runDirFile);
        this.executionThread = Thread.currentThread();
        this.outputReaderThread = new OutputReaderThread(process.getInputStream(), printWriter);
        this.outputReaderThread.start();
        if (reader != null) {
            this.inputReaderThread = new InputReaderThread(process.getOutputStream(), reader);
            this.inputReaderThread.start();
        } else {
            this.inputReaderThread = null;
        }
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            process.destroy();
            while (n < 0) {
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException interruptedException2) {}
            }
        }
        try {
            this.outputReaderThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.executionThread = null;
        return n;
    }

    private static Logger getExecLog() {
        if (execLog == null) {
            execLog = Logger.getLogger("cnd.remote.logger");
        }
        return execLog;
    }

    private static void logArgs(String[] stringArray) {
        LocalNativeExecution.getExecLog().fine("Running: " + Arrays.asList(stringArray));
    }

    private Process exec(String string, String string2, String[] stringArray, File file) throws IOException {
        String[] stringArray2 = Utilities.parseParameters((String)string2);
        String[] stringArray3 = new String[stringArray2.length + 1];
        stringArray3[0] = string;
        System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
        LocalNativeExecution.logArgs(stringArray3);
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray3);
        processBuilder.redirectErrorStream(true);
        if (stringArray != null) {
            Map<String, String> map = processBuilder.environment();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                int n = string3.indexOf(61);
                if (n == -1) {
                    throw new IOException("No equal sign in name=value: " + string3);
                }
                map.put(string3.substring(0, n), string3.substring(n + 1));
            }
        }
        if (file != null) {
            processBuilder.directory(file);
        }
        return processBuilder.start();
    }

    public void stop() {
        Thread thread = this.executionThread;
        if (thread != null) {
            thread.interrupt();
        }
        this.outputReaderThread.cancel();
    }

    private static String getString(String string) {
        return bundle.getString(string);
    }

    private static final class InputReaderThread
    extends Thread {
        private Reader in;
        private OutputStream pout;

        public InputReaderThread(OutputStream outputStream, Reader reader) {
            this.pout = outputStream;
            this.in = reader;
            this.setName("inputReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n;
                while ((n = this.in.read()) != -1) {
                    this.pout.write((char)n);
                    this.pout.flush();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                LocalNativeExecution.getExecLog().finest("Input reader thread interrupted");
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            finally {
                try {
                    this.pout.flush();
                    this.pout.close();
                }
                catch (InterruptedIOException interruptedIOException) {
                    LocalNativeExecution.getExecLog().finest("Input reader thread cleanup interrupted");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static final class OutputReaderThread
    extends Thread {
        private Reader err;
        private Writer output;
        private boolean cancel = false;

        public OutputReaderThread(InputStream inputStream, Writer writer) {
            this.err = new InputStreamReader(inputStream);
            this.output = writer;
            this.setName("OutputReaderThread");
        }

        public void run() {
            try {
                int n;
                while ((n = this.err.read()) != -1) {
                    if (this.cancel) {
                        return;
                    }
                    if (n == 10) {
                        this.output.write("\n");
                        continue;
                    }
                    this.output.write((char)n);
                }
                this.output.flush();
            }
            catch (InterruptedIOException interruptedIOException) {
                LocalNativeExecution.getExecLog().finest("Output reader thread interrupted");
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }

        public void cancel() {
            this.cancel = true;
        }
    }
}

