/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.editor.parser.CtagsTokenEvent;
import org.netbeans.modules.cnd.editor.parser.CtagsTokenListener;

public class CtagsParser {
    private static boolean exuberantCtags = false;
    private static final String PROD_CTAGS_COMMAND = "sfw/bin/ctags";
    private static final String OS_CTAGS_COMMAND = "/bin/exctags";
    private static final String CCD_CTAGS_COMMAND = "/opt/sfw/bin/ctags";
    private static final String CTAGS_COMMAND_LINUX = "/usr/bin/ctags";
    private static final String CTAGS_COMMAND_SOLARIS = "/usr/bin/ctags";
    private static final String CTAGS_OPTIONS_EX_CTAGS = "-f - --fields=+nz";
    private static final String CTAGS_OPTIONS_SO_CTAGS = "-x";
    private static String ctagsCommandPlusOptions = null;
    private String inputFileName = null;
    private CtagsTokenListener ctagsTokenListener = null;

    public CtagsParser(String string) {
        this.inputFileName = string;
    }

    public void setCtagsTokenListener(CtagsTokenListener ctagsTokenListener) {
        this.ctagsTokenListener = ctagsTokenListener;
    }

    private void parseLineExuberantCtags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        int n = 0;
        String string2 = null;
        String string3 = null;
        int n2 = -1;
        char c = ' ';
        int n3 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n4 = string4.length();
            String string5 = null;
            int n5 = 0;
            n5 = string4.indexOf(58);
            if (n5 > 0) {
                string5 = string4.substring(0, ++n5);
            }
            if (n == 0) {
                string2 = string4;
            } else if (n5 == 5) {
                if (string5.equals("kind:")) {
                    if (n4 > 5) {
                        c = string4.charAt(5);
                    }
                } else if (string5.equals("type:")) {
                    if (n4 > 5) {
                        string3 = string4.substring(5);
                        n2 = 5;
                    }
                } else if (string5.equals("data:")) {
                    if (n4 > 5) {
                        string3 = string4.substring(5);
                        n2 = 7;
                    }
                } else if (string5.equals("line:")) {
                    try {
                        Integer n6 = new Integer(string4.substring(5));
                        n3 = n6;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            } else if (n5 == 6) {
                if (string5.equals("class:")) {
                    if (n4 > 6) {
                        string3 = string4.substring(6);
                        n2 = 0;
                    }
                } else if (string5.equals("union:") && n4 > 6) {
                    string3 = string4.substring(6);
                    n2 = 2;
                }
            } else if (n5 == 7) {
                if (string5.equals("struct:")) {
                    if (n4 > 7) {
                        string3 = string4.substring(7);
                        n2 = 1;
                    }
                } else if (string5.equals("module:") && n4 > 7) {
                    string3 = string4.substring(7);
                    n2 = 4;
                }
            } else if (n5 == 10) {
                if (string5.equals("namespace:") && n4 > 10) {
                    string3 = string4.substring(10);
                    n2 = 3;
                }
            } else if (n5 == 11 && string5.equals("subroutine:") && n4 > 11) {
                string3 = string4.substring(11);
                n2 = 6;
            }
            ++n;
        }
        if (this.ctagsTokenListener != null) {
            this.ctagsTokenListener.gotToken(new CtagsTokenEvent(string2, c, string3, n2, n3));
        } else {
            System.err.println("gotToken: " + string2 + ":" + n3);
        }
    }

    private void parseLineSolarisCtags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        String string2 = null;
        int n2 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (n == 0) {
                string2 = string3;
            } else if (n == 1) {
                try {
                    Integer n3 = new Integer(string3);
                    n2 = n3;
                }
                catch (Exception exception) {
                    return;
                }
            }
            if (++n <= 1) continue;
            break;
        }
        if (this.ctagsTokenListener != null) {
            this.ctagsTokenListener.gotToken(new CtagsTokenEvent(string2, n2));
        } else {
            System.err.println("gotToken: " + string2 + ":" + n2);
        }
    }

    private String getCtagsCommand() {
        if (ctagsCommandPlusOptions == null) {
            if (System.getProperty("os.name", "").toLowerCase().indexOf("windows") >= 0) {
                String string = this.findCtagsOnWindows();
                if (this.fileExists(string)) {
                    exuberantCtags = true;
                    ctagsCommandPlusOptions = string + " " + CTAGS_OPTIONS_EX_CTAGS;
                }
            } else if (System.getProperty("os.name", "").toLowerCase().indexOf("linux") >= 0) {
                if (new File("/usr/bin/ctags").exists()) {
                    exuberantCtags = true;
                    ctagsCommandPlusOptions = "/usr/bin/ctags -f - --fields=+nz";
                }
            } else {
                String string = System.getProperty("spro.home") + File.separator + PROD_CTAGS_COMMAND;
                if (new File(string).exists()) {
                    exuberantCtags = true;
                    ctagsCommandPlusOptions = string + " " + CTAGS_OPTIONS_EX_CTAGS;
                } else if (new File(OS_CTAGS_COMMAND).exists()) {
                    exuberantCtags = true;
                    ctagsCommandPlusOptions = "/bin/exctags -f - --fields=+nz";
                } else if (new File(CCD_CTAGS_COMMAND).exists()) {
                    exuberantCtags = true;
                    ctagsCommandPlusOptions = "/opt/sfw/bin/ctags -f - --fields=+nz";
                } else if (new File("/usr/bin/ctags").exists()) {
                    exuberantCtags = false;
                    ctagsCommandPlusOptions = "/usr/bin/ctags -x";
                }
            }
        }
        if (ctagsCommandPlusOptions == null) {
            System.err.println("cpp - cannot locate ctags utility...");
        }
        return ctagsCommandPlusOptions;
    }

    private boolean fileExists(String string) {
        return string != null && new File(string).exists();
    }

    private String findCtagsOnWindows() {
        String string;
        String string2 = null;
        if (string2 == null || !this.fileExists(string2)) {
            string2 = System.getProperty("CTAGS_LOCATION");
        }
        if (string2 == null || !this.fileExists(string2)) {
            string2 = System.getenv("CTAGS_LOCATION");
        }
        if (string2 == null || !this.fileExists(string2)) {
            string2 = "C:\\cygwin\\bin\\ctags.exe ";
        }
        if (!(string2 != null && this.fileExists(string2) || (string = Path.getPathAsString()) == null)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                File file = new File(string3, "ctags.exe");
                if (!file.exists()) continue;
                string2 = file.getAbsolutePath();
                break;
            }
        }
        return this.fileExists(string2) ? string2 : null;
    }

    public int parse() throws IOException, InterruptedException {
        int n = 0;
        String string = this.getCtagsCommand();
        if (string == null) {
            return -1;
        }
        String string2 = System.getProperty("user.dir");
        Process process = Runtime.getRuntime().exec(string + " " + this.inputFileName);
        OutputMonitor outputMonitor = new OutputMonitor(new InputStreamReader(process.getErrorStream()), true);
        outputMonitor.start();
        OutputMonitor outputMonitor2 = new OutputMonitor(new InputStreamReader(process.getInputStream()), false);
        outputMonitor2.start();
        outputMonitor.join();
        outputMonitor2.join();
        n = process.waitFor();
        process.destroy();
        return n;
    }

    public class OutputMonitor
    extends Thread {
        private BufferedReader in;
        private boolean skipAll;

        public OutputMonitor(InputStreamReader inputStreamReader, boolean bl) {
            this.in = new BufferedReader(inputStreamReader);
            this.skipAll = bl;
        }

        public void run() {
            try {
                String string;
                while ((string = this.in.readLine()) != null) {
                    if (this.skipAll) continue;
                    if (exuberantCtags) {
                        CtagsParser.this.parseLineExuberantCtags(string);
                        continue;
                    }
                    CtagsParser.this.parseLineSolarisCtags(string);
                }
                this.in.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

