/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.editor.CppFoldManagerBase;
import org.netbeans.modules.cnd.editor.parser.CppFile;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.editor.parser.CppMetaModel;
import org.netbeans.modules.cnd.editor.parser.ParsingEvent;
import org.netbeans.modules.cnd.editor.parser.ParsingListener;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

final class CppFoldManager
extends CppFoldManagerBase
implements Runnable,
ParsingListener {
    private FoldOperation operation;
    private List<BlockFoldInfo> blockFoldInfos = Collections.emptyList();
    private boolean foldIncludesPreset;
    private boolean foldCommentPreset;
    private boolean foldCodeBlocksPreset;
    private boolean foldInitialCommentsPreset;
    private boolean listeningOnParsing;
    private static RequestProcessor cppFoldsRP;
    private static final Logger log;

    private CppFoldManager() {
    }

    private static synchronized RequestProcessor getCppFoldsRP() {
        if (cppFoldsRP == null) {
            cppFoldsRP = new RequestProcessor("CPP-Folds", 1);
        }
        return cppFoldsRP;
    }

    private String getFilename() {
        FoldHierarchy foldHierarchy = this.operation != null ? this.operation.getHierarchy() : null;
        JTextComponent jTextComponent = foldHierarchy != null ? foldHierarchy.getComponent() : null;
        Document document = jTextComponent != null ? jTextComponent.getDocument() : null;
        DataObject dataObject = document != null ? NbEditorUtilities.getDataObject((Document)document) : null;
        String string = dataObject != null ? FileUtil.getFileDisplayName((FileObject)dataObject.getPrimaryFile()) : null;
        return string;
    }

    private String getShortName() {
        String string = (String)this.getDocument().getProperty("title");
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    private FoldOperation getOperation() {
        return this.operation;
    }

    private void removeFoldNotify(Fold fold) {
        log.log(Level.FINE, "CppFoldManager.removeFoldNotify");
    }

    private synchronized void updateFolds() {
        UpdateFoldsRequest updateFoldsRequest;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "CFM.updateFolds: Processing " + this.getShortName() + " [" + Thread.currentThread().getName() + "]");
        }
        if ((updateFoldsRequest = this.collectFoldUpdates()) == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!CppFoldManager.this.getOperation().isReleased()) {
                    Document document = CppFoldManager.this.getDocument();
                    if (!(document instanceof AbstractDocument)) {
                        return;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "CFM.updateFolds$X1.run: Processing " + CppFoldManager.this.getShortName() + " [" + Thread.currentThread().getName() + "]");
                    }
                    AbstractDocument abstractDocument = (AbstractDocument)document;
                    abstractDocument.readLock();
                    try {
                        FoldHierarchy foldHierarchy = CppFoldManager.this.getOperation().getHierarchy();
                        foldHierarchy.lock();
                        try {
                            FoldHierarchyTransaction foldHierarchyTransaction = CppFoldManager.this.getOperation().openTransaction();
                            try {
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "CFM.updateFolds$X1.run: Calling processUpdateFoldRequest for " + CppFoldManager.this.getShortName() + " [" + Thread.currentThread().getName() + "]");
                                }
                                CppFoldManager.this.processUpdateFoldRequest(updateFoldsRequest, foldHierarchyTransaction);
                            }
                            finally {
                                foldHierarchyTransaction.commit();
                            }
                        }
                        finally {
                            foldHierarchy.unlock();
                        }
                    }
                    finally {
                        abstractDocument.readUnlock();
                    }
                }
            }
        };
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "CFM.updateFolds: Starting update for " + this.getShortName() + " on AWT thread");
        }
        SwingUtilities.invokeLater(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateFoldsRequest collectFoldUpdates() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "CFM.collectFoldUpdates: Processing " + this.getShortName() + " [" + Thread.currentThread().getName() + "]");
        }
        Document document = this.getDocument();
        if (this.getOperation().isReleased() || !(document instanceof AbstractDocument)) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "CFM.collectFoldUpdates: No doc found for " + this.getShortName());
            }
            return null;
        }
        CppFile cppFile = CppMetaModel.getDefault().get(document.getProperty("title").toString());
        if (cppFile == null) {
            return null;
        }
        cppFile.waitScanFinished(1);
        if (cppFile.isParsingFailed()) {
            return null;
        }
        UpdateFoldsRequest updateFoldsRequest = new UpdateFoldsRequest();
        AbstractDocument abstractDocument = (AbstractDocument)document;
        abstractDocument.readLock();
        try {
            updateFoldsRequest.addBlockFoldInfo(cppFile.getInitialCommentFold());
            for (CppFoldRecord cppFoldRecord : cppFile.getIncludesFolds()) {
                updateFoldsRequest.addBlockFoldInfo(cppFoldRecord);
            }
            for (CppFoldRecord cppFoldRecord : cppFile.getBlockFolds()) {
                updateFoldsRequest.addBlockFoldInfo(cppFoldRecord);
            }
        }
        finally {
            abstractDocument.readUnlock();
        }
        return updateFoldsRequest;
    }

    private void processUpdateFoldRequest(UpdateFoldsRequest updateFoldsRequest, FoldHierarchyTransaction foldHierarchyTransaction) {
        if (updateFoldsRequest != null && updateFoldsRequest.isValid()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "CFM.processUpdateFoldRequest: Processing " + this.getShortName() + " [" + Thread.currentThread().getName() + "]");
            }
            LinkedHashMap<BlockFoldInfo, BlockFoldInfo> linkedHashMap = new LinkedHashMap<BlockFoldInfo, BlockFoldInfo>();
            for (BlockFoldInfo iterator2 : this.blockFoldInfos) {
                iterator2.recalcHashCode();
                linkedHashMap.put(iterator2, iterator2);
            }
            List<BlockFoldInfo> list = updateFoldsRequest.getBlockFoldInfos();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BlockFoldInfo blockFoldInfo = (BlockFoldInfo)iterator.next();
                blockFoldInfo.recalcHashCode();
                BlockFoldInfo blockFoldInfo2 = (BlockFoldInfo)linkedHashMap.get(blockFoldInfo);
                if (blockFoldInfo2 == null || blockFoldInfo.isUpdateRequired(blockFoldInfo2)) {
                    if (blockFoldInfo2 != null) {
                        blockFoldInfo2.removeFromHierarchy(foldHierarchyTransaction);
                        linkedHashMap.remove(blockFoldInfo);
                    }
                    try {
                        blockFoldInfo.addToHierarchy(foldHierarchyTransaction);
                    }
                    catch (BadLocationException badLocationException) {}
                    continue;
                }
                linkedHashMap.remove(blockFoldInfo);
                blockFoldInfo.fold = blockFoldInfo2.fold;
            }
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                ((BlockFoldInfo)entry.getKey()).removeFromHierarchy(foldHierarchyTransaction);
            }
            this.blockFoldInfos = list;
        }
    }

    Document getDocument() {
        return this.getOperation().getHierarchy().getComponent().getDocument();
    }

    DataObject getDataObject() {
        Document document = this.getDocument();
        return document != null ? NbEditorUtilities.getDataObject((Document)document) : null;
    }

    public void run() {
        try {
            if (new File(this.getFilename()).exists()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CFM.run: Processing " + this.getShortName() + " [" + Thread.currentThread().getName() + "]");
                }
                if (!this.listeningOnParsing) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "CFM.run: Processing " + this.getShortName() + " [" + Thread.currentThread().getName() + "]");
                    }
                    this.listeningOnParsing = true;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "CFM.run: Starting WeakParsingListener [" + Thread.currentThread().getName() + "]");
                    }
                    new WeakParsingListener(this).startListening();
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CFM.run: Calling updateFolds [" + Thread.currentThread().getName() + "]");
                }
                this.updateFolds();
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
    }

    public void init(FoldOperation foldOperation) {
        Preferences preferences;
        String string;
        this.operation = foldOperation;
        BaseKit baseKit = Utilities.getKit((JTextComponent)foldOperation.getHierarchy().getComponent());
        if (baseKit instanceof NbEditorKit && (string = ((NbEditorKit)baseKit).getContentType()) != null && (preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class)) != null) {
            this.foldInitialCommentsPreset = preferences.getBoolean("code-folding-collapse-initial-comment", false);
            this.foldIncludesPreset = preferences.getBoolean("code-folding-collapse-import", false);
            this.foldCodeBlocksPreset = preferences.getBoolean("code-folding-collapse-method", false);
            this.foldCommentPreset = preferences.getBoolean("code-folding-collapse-javadoc", false);
        }
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        if (this.getFilename() != null && this.getFilename().length() > 0) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "CFM.initFolds: Posting for " + this.getShortName() + " on Cpp Folds RP [" + Thread.currentThread().getName() + "]");
            }
            CppFoldManager.getCppFoldsRP().post((Runnable)this, 1000, 1);
        }
    }

    private void scheduleParsing(Document document) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "TitleProperty: " + document.getProperty("title"));
        }
        if (document.getProperty("title") != null) {
            CppMetaModel.getDefault().scheduleParsing(document);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "FoldManager.insertUpdate: " + documentEvent.getDocument().toString());
        }
        this.scheduleParsing(documentEvent.getDocument());
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        log.log(Level.FINE, "FoldManager.removeUpdate");
        this.scheduleParsing(documentEvent.getDocument());
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        log.log(Level.FINE, "FoldManager.changeUpdate");
    }

    private void removeFoldInfo(Fold fold) {
        Iterator<BlockFoldInfo> iterator = this.blockFoldInfos.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().fold != fold) continue;
            iterator.remove();
            break;
        }
    }

    public void removeEmptyNotify(Fold fold) {
        this.removeFoldNotify(fold);
        this.removeFoldInfo(fold);
    }

    public void removeDamagedNotify(Fold fold) {
        this.removeFoldNotify(fold);
        this.removeFoldInfo(fold);
    }

    public void expandNotify(Fold fold) {
    }

    public void release() {
    }

    public void objectParsed(ParsingEvent parsingEvent) {
        FileObject fileObject;
        DataObject dataObject = (DataObject)parsingEvent.getSource();
        String string = this.getFilename();
        if (dataObject != null && (fileObject = dataObject.getPrimaryFile()) != null) {
            String string2 = FileUtil.getFileDisplayName((FileObject)fileObject);
            if (string2.equals(string)) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CFM.objectParsed: Calling updateFolds for " + this.getShortName());
                }
                this.updateFolds();
            } else {
                log.log(Level.FINE, "CFM.objectParsed: Skipping updateFolds");
            }
        }
    }

    static {
        log = Logger.getLogger(CppFoldManager.class.getName());
    }

    public static final class Factory
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new CppFoldManager();
        }
    }

    private static final class WeakParsingListener
    implements ParsingListener {
        private WeakReference<ParsingListener> ref;

        WeakParsingListener(ParsingListener parsingListener) {
            this.ref = new WeakReference<ParsingListener>(parsingListener);
        }

        public void startListening() {
            CppMetaModel.getDefault().addParsingListener(this);
        }

        public void objectParsed(ParsingEvent parsingEvent) {
            ParsingListener parsingListener = (ParsingListener)this.ref.get();
            if (parsingListener != null) {
                parsingListener.objectParsed(parsingEvent);
            } else {
                CppMetaModel.getDefault().removeParsingListener(this);
            }
        }
    }

    private final class BlockFoldInfo {
        private Fold fold = null;
        private final CppFoldManagerBase.FoldTemplate template;
        private int hash = 0;
        private final boolean collapse;
        private final int startOffset;
        private final int endOffset;

        public BlockFoldInfo(CppFoldRecord cppFoldRecord) throws BadLocationException {
            this.startOffset = cppFoldRecord.getStartOffset();
            this.endOffset = cppFoldRecord.getEndOffset();
            switch (cppFoldRecord.getType()) {
                case 1: {
                    this.template = CppFoldManagerBase.INITIAL_COMMENT_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldInitialCommentsPreset;
                    break;
                }
                case 4: {
                    this.template = CppFoldManagerBase.INCLUDES_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldIncludesPreset;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.template = CppFoldManagerBase.CODE_BLOCK_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldCodeBlocksPreset;
                    break;
                }
                case 2: {
                    this.template = CppFoldManagerBase.COMMENT_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldCommentPreset;
                    break;
                }
                case 3: {
                    this.template = CppFoldManagerBase.LINE_COMMENT_FOLD_TEMPLATE;
                    this.collapse = false;
                    break;
                }
                case 5: {
                    this.template = CppFoldManagerBase.IFDEF_FOLD_TEMPLATE;
                    this.collapse = false;
                    break;
                }
                default: {
                    assert (false) : "unsupported block type " + cppFoldRecord;
                    this.collapse = false;
                    this.template = null;
                }
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof BlockFoldInfo)) {
                return false;
            }
            BlockFoldInfo blockFoldInfo = (BlockFoldInfo)object;
            return this.template == blockFoldInfo.template && this.getRealStartOffset() == blockFoldInfo.getRealStartOffset();
        }

        private void recalcHashCode() {
            this.hash = 0;
            this.hashCode();
        }

        public int hashCode() {
            if (this.hash == 0) {
                int n = 7;
                n = 59 * n + (this.template != null ? this.template.hashCode() : 0);
                this.hash = n = 59 * n + this.getRealStartOffset();
            }
            return this.hash;
        }

        public boolean isUpdateRequired(BlockFoldInfo blockFoldInfo) {
            assert (this.equals(blockFoldInfo)) : "only equal orig can be here";
            return blockFoldInfo.fold == null || this.getRealEndOffset() != blockFoldInfo.getRealEndOffset();
        }

        private int getRealStartOffset() {
            if (this.fold != null) {
                return this.fold.getStartOffset();
            }
            return this.startOffset;
        }

        private int getRealEndOffset() {
            if (this.fold != null) {
                return this.fold.getEndOffset();
            }
            return this.endOffset;
        }

        public void addToHierarchy(FoldHierarchyTransaction foldHierarchyTransaction) throws BadLocationException {
            if (FoldOperation.isBoundsValid((int)this.startOffset, (int)this.endOffset, (int)this.template.getStartGuardedLength(), (int)this.template.getEndGuardedLength())) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CFM.BlockFoldInfo.updateHierarchy: Creating fold at (" + this.startOffset + ", " + this.endOffset + ")");
                }
                this.fold = CppFoldManager.this.getOperation().addToHierarchy(this.template.getType(), this.template.getDescription(), this.collapse, this.startOffset, this.endOffset, this.template.getStartGuardedLength(), this.template.getEndGuardedLength(), (Object)this, foldHierarchyTransaction);
            }
        }

        public void removeFromHierarchy(FoldHierarchyTransaction foldHierarchyTransaction) {
            FoldOperation foldOperation;
            if (this.fold != null && (foldOperation = CppFoldManager.this.getOperation()).isAddedOrBlocked(this.fold)) {
                foldOperation.removeFromHierarchy(this.fold, foldHierarchyTransaction);
            }
        }

        public String toString() {
            return "BlockFoldInfo:" + this.template.getType() + " at[" + this.getRealStartOffset() + "," + this.getRealEndOffset() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UpdateFoldsRequest {
        private final Document creationTimeDoc;
        private final List<BlockFoldInfo> blockFoldInfos = new LinkedList<BlockFoldInfo>();

        UpdateFoldsRequest() {
            this.creationTimeDoc = CppFoldManager.this.getDocument();
        }

        boolean isValid() {
            return this.creationTimeDoc != null && this.creationTimeDoc == CppFoldManager.this.getDocument();
        }

        List<BlockFoldInfo> getBlockFoldInfos() {
            return this.blockFoldInfos;
        }

        void addBlockFoldInfo(CppFoldRecord cppFoldRecord) {
            block3: {
                if (cppFoldRecord != null) {
                    try {
                        this.blockFoldInfos.add(new BlockFoldInfo(cppFoldRecord));
                    }
                    catch (BadLocationException badLocationException) {
                        if (!log.isLoggable(Level.FINE)) break block3;
                        log.log(Level.FINE, "CFM.addBlockFoldInfo: Got BadLocationException\n    " + badLocationException.getMessage());
                    }
                }
            }
        }
    }
}

