/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.builds;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.builds.TargetEditor;
import org.netbeans.modules.cnd.execution41.org.openide.loaders.ExecutionSupport;
import org.netbeans.modules.cnd.settings.MakeSettings;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeExecSupport
extends ExecutionSupport {
    private Sheet.Set sheetSet;
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_MAKE_COMMAND = "makeCommand";
    public static final String PROP_MAKE_OPTIONS = "makeOptions";
    public static final String PROP_MAKE_TARGETS = "makeTargets";
    private static final String PROP_ENVIRONMENT = "environment";
    private PropertySupport buildDirectoryProperty = null;
    private PropertySupport makeCommandProperty = null;
    private PropertySupport makeOptionsProperty = null;
    private PropertySupport makeTargetsProperty = null;
    private PropertySupport makeEnvironmentProperty = null;
    private File buildDir;
    private static ResourceBundle bundle = NbBundle.getBundle(MakeExecSupport.class);

    public MakeExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    public FileObject getFileObject() {
        return this.getEntry().getFile();
    }

    public void createProperties() {
        if (this.buildDirectoryProperty == null) {
            this.buildDirectoryProperty = this.createBuildDirectoryProperty();
            this.makeCommandProperty = this.createMakeCommandProperty();
            this.makeOptionsProperty = this.createMakeOptionsProperty();
            this.makeTargetsProperty = this.createMakeTargetsProperty();
            this.makeEnvironmentProperty = this.createEnvironmentProperty(PROP_ENVIRONMENT, MakeExecSupport.getString("PROP_MAKE_ENVIRONMENT"), MakeExecSupport.getString("HINT_MAKE_ENVIRONMENT"));
        }
    }

    @Override
    public void addProperties(Sheet.Set set) {
        this.createProperties();
        this.sheetSet = set;
        set.put((Node.Property)this.buildDirectoryProperty);
        set.put((Node.Property)this.makeCommandProperty);
        set.put((Node.Property)this.makeOptionsProperty);
        set.put((Node.Property)this.makeTargetsProperty);
        set.put((Node.Property)this.makeEnvironmentProperty);
    }

    private PropertySupport<String> createBuildDirectoryProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_BUILD_DIRECTORY, String.class, MakeExecSupport.getString("PROP_BUILD_DIRECTORY"), MakeExecSupport.getString("HINT_BUILD_DIRECTORY")){

            public String getValue() {
                return MakeExecSupport.this.getBuildDirectory();
            }

            public void setValue(String string) {
                MakeExecSupport.this.setBuildDirectory(string);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return MakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getBuildDirectory() {
        String string = (String)this.getEntry().getFile().getAttribute(PROP_BUILD_DIRECTORY);
        if (string == null) {
            string = MakeSettings.getDefault().getDefaultBuildDirectory();
            this.setBuildDirectory(string);
        }
        return string;
    }

    public void setBuildDirectory(String string) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_BUILD_DIRECTORY, (Object)string);
            }
            catch (IOException iOException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                iOException.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createMakeCommandProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_MAKE_COMMAND, String.class, MakeExecSupport.getString("PROP_MAKE_COMMAND"), MakeExecSupport.getString("HINT_MAKE_COMMAND")){

            public String getValue() {
                return MakeExecSupport.this.getMakeCommand();
            }

            public void setValue(String string) {
                MakeExecSupport.this.setMakeCommand(string);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return MakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getMakeCommand() {
        String string = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_COMMAND);
        if (string == null || string.equals("")) {
            string = MakeSettings.getDefault().getDefaultMakeCommand();
            this.setMakeCommand(string);
        }
        return string;
    }

    public void setMakeCommand(String string) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_MAKE_COMMAND, (Object)string);
            }
            catch (IOException iOException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                iOException.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createMakeOptionsProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_MAKE_OPTIONS, String.class, MakeExecSupport.getString("PROP_MAKE_OPTIONS"), MakeExecSupport.getString("HINT_MAKE_OPTIONS")){

            public String getValue() {
                return MakeExecSupport.this.getMakeOptions(false);
            }

            public void setValue(String string) {
                MakeExecSupport.this.setMakeOptions(string);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return MakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getMakeOptions() {
        return this.getMakeOptions(false);
    }

    public String getMakeOptions(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(256);
        String string = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_OPTIONS);
        if (string == null) {
            string = "";
            this.setMakeOptions(string);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public void setMakeOptions(String string) {
        block2: {
            FileObject fileObject = this.getEntry().getFile();
            try {
                fileObject.setAttribute(PROP_MAKE_OPTIONS, (Object)string);
            }
            catch (IOException iOException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                iOException.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createMakeTargetsProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_MAKE_TARGETS, String.class, MakeExecSupport.getString("PROP_MAKE_TARGETS"), MakeExecSupport.getString("HINT_MAKE_TARGETS")){

            public String getValue() {
                return MakeExecSupport.this.getMakeTargets();
            }

            public void setValue(String string) {
                MakeExecSupport.this.setMakeTargets(string);
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return MakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }

            public PropertyEditor getPropertyEditor() {
                return new TargetsPropertyEditor((PropertySupport)this);
            }
        };
    }

    public String getMakeTargets() {
        String string = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_TARGETS);
        if (string == null) {
            string = "";
            this.setMakeTargets(string);
        }
        return string;
    }

    private String[] tokenizeTargets(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";:,");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            int n = 0;
            String string2 = stringTokenizer.nextToken();
            while (n < string2.length() && Character.isWhitespace(string2.charAt(n)) && ++n < string2.length()) {
            }
            if (n >= string2.length()) continue;
            if (n > 0) {
                arrayList.add(string2.substring(n));
                continue;
            }
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String[] getMakeTargetsArray() {
        return this.tokenizeTargets(this.getMakeTargets());
    }

    public void setMakeTargets(String string) {
        block3: {
            FileObject fileObject = this.getEntry().getFile();
            try {
                fileObject.setAttribute(PROP_MAKE_TARGETS, (Object)string);
                if (this.sheetSet != null) {
                    this.sheetSet.remove(PROP_MAKE_TARGETS);
                    this.sheetSet.put((Node.Property)this.makeTargetsProperty);
                }
            }
            catch (IOException iOException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                iOException.printStackTrace();
            }
        }
    }

    public void addMakeTargets(String string) {
        String string2 = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_TARGETS);
        if (string == null || string.length() == 0) {
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        string2 = string2.length() == 0 ? string : string2 + ", " + string;
        this.setMakeTargets(string2);
    }

    private static String getString(String string) {
        return bundle.getString(string);
    }

    class TargetsPropertyEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertySupport prop = null;
        private PropertyEnv env;

        TargetsPropertyEditor(PropertySupport propertySupport) {
            this.prop = propertySupport;
        }

        public Component getCustomEditor() {
            String string;
            try {
                string = (String)this.prop.getValue();
            }
            catch (Exception exception) {
                string = "";
            }
            return new TargetEditor(MakeExecSupport.this.tokenizeTargets(string), this, this.env);
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv propertyEnv) {
            this.env = propertyEnv;
        }
    }
}

