/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.builds;

import java.io.IOException;
import org.netbeans.modules.cnd.execution41.org.openide.loaders.ExecutionSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMakeExecSupport
extends ExecutionSupport {
    private Sheet.Set sheetSet;
    private static final String PROP_CMAKE_COMMAND = "cmakeCommand";
    private static final String PROP_RUN_DIRECTORY = "rundirectory";
    private static final String PROP_ENVIRONMENT = "environment";
    private PropertySupport cmakeRunDirectory;
    private PropertySupport cmakeCommandProperty;
    private PropertySupport cmakeEnvironmentProperty;

    public CMakeExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    public FileObject getFileObject() {
        return this.getEntry().getFile();
    }

    private void createProperties() {
        if (this.cmakeCommandProperty == null) {
            this.cmakeCommandProperty = this.createQMakeCommandProperty();
            this.cmakeRunDirectory = this.createRunDirectoryProperty();
            this.cmakeEnvironmentProperty = this.createEnvironmentProperty(PROP_ENVIRONMENT, CMakeExecSupport.getString("PROP_CMAKE_ENVIRONMENT"), CMakeExecSupport.getString("HINT_CMAKE_ENVIRONMENT"));
        }
    }

    @Override
    public void addProperties(Sheet.Set set) {
        this.createProperties();
        this.sheetSet = set;
        set.put(this.createParamsProperty("params", CMakeExecSupport.getString("PROP_QMAKE_PARAMS"), CMakeExecSupport.getString("HINT_QMAKE_PARAMS")));
        set.put((Node.Property)this.cmakeRunDirectory);
        set.put((Node.Property)this.cmakeCommandProperty);
        set.put((Node.Property)this.cmakeEnvironmentProperty);
    }

    private PropertySupport<String> createQMakeCommandProperty() {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>(PROP_CMAKE_COMMAND, String.class, CMakeExecSupport.getString("PROP_CMAKE_COMMAND"), CMakeExecSupport.getString("HINT_CMAKE_COMMAND")){

            public String getValue() {
                return CMakeExecSupport.this.getCMakeCommand();
            }

            public void setValue(String string) {
                CMakeExecSupport.this.setCMakeCommand(string);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return CMakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
        readWrite.setValue("oneline", (Object)Boolean.TRUE);
        return readWrite;
    }

    public String getCMakeCommand() {
        String string = (String)this.getEntry().getFile().getAttribute(PROP_CMAKE_COMMAND);
        if (string == null || string.equals("")) {
            string = "cmake";
            this.setCMakeCommand(string);
        }
        return string;
    }

    public void setCMakeCommand(String string) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_CMAKE_COMMAND, (Object)string);
            }
            catch (IOException iOException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                iOException.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createRunDirectoryProperty() {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>(PROP_RUN_DIRECTORY, String.class, CMakeExecSupport.getString("PROP_RUN_CMAKE_DIRECTORY"), CMakeExecSupport.getString("HINT_RUN_CMAKE_DIRECTORY")){

            public String getValue() {
                return CMakeExecSupport.this.getRunDirectory();
            }

            public void setValue(String string) {
                CMakeExecSupport.this.setRunDirectory(string);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return CMakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
        readWrite.setValue("oneline", (Object)Boolean.TRUE);
        return readWrite;
    }

    public String getRunDirectory() {
        String string = (String)this.getEntry().getFile().getAttribute(PROP_RUN_DIRECTORY);
        if (string == null) {
            string = ".";
            this.setRunDirectory(string);
        }
        return string;
    }

    public void setRunDirectory(String string) {
        block2: {
            FileObject fileObject = this.getEntry().getFile();
            try {
                fileObject.setAttribute(PROP_RUN_DIRECTORY, (Object)string);
            }
            catch (IOException iOException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                iOException.printStackTrace();
            }
        }
    }

    private static String getString(String string) {
        return NbBundle.getBundle(CMakeExecSupport.class).getString(string);
    }
}

