/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.openide.util.NbBundle;

final class ToolchainScriptGenerator {
    private static final boolean TRACE = true;
    private static final String[] platforms = new String[]{"PLATFORM_SOLARIS_SPARC", "PLATFORM_SOLARIS_INTEL", "PLATFORM_LINUX", "PLATFORM_MACOSX", "PLATFORM_NONE"};
    private static final int[] platformsID = new int[]{0, 1, 2, 4, 6};
    private final StringBuilder buf = new StringBuilder();
    int level = 0;

    private ToolchainScriptGenerator() {
    }

    static final String generateScript(String string) {
        ToolchainScriptGenerator toolchainScriptGenerator = new ToolchainScriptGenerator();
        toolchainScriptGenerator.prefix(string);
        toolchainScriptGenerator.scanPaths();
        return toolchainScriptGenerator.buf.toString();
    }

    private void prefix(String string) {
        this.line("#!/bin/sh");
        this.lines(NbBundle.getMessage(ToolchainScriptGenerator.class, (String)"DetectHostInfo"));
        if (string != null) {
            this.line("PATHSLIST=\"" + string + "\"");
        } else {
            this.line("echo $PLATFORM_NAME");
            for (int i = 0; i < platforms.length; ++i) {
                this.line("if [ \"$PLATFORM\" = \"$" + platforms[i] + "\" ]; then");
                if (platformsID[i] == 3) {
                    this.line("PATH=$PATH;C:/WINDOWS/System32;C:/WINDOWS;C:/WINDOWS/System32/WBem");
                } else if (platformsID[i] != 6) {
                    this.line("PATH=$PATH:/bin:/usr/bin:/sbin:/usr/sbin");
                } else {
                    this.line("PATH=$PATH");
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                CompilerSetManager.appendDefaultLocations(platformsID[i], arrayList);
                for (String string2 : arrayList) {
                    this.line("PATH=$PATH:" + string2);
                }
                this.line("fi");
            }
            this.line("PATHSLIST=$PATH");
        }
        this.line("if [ \"$PLATFORM\" = \"$PLATFORM_WINDOWS\" ]; then");
        this.line(" IFS=;");
        this.line("else");
        this.line(" IFS=:");
        this.line("fi");
        this.line("foundFlavors=\";\"");
    }

    private void scanPaths() {
        this.line("for f in $PATHSLIST; do");
        this.line("  line=");
        this.line("  flavor=");
        this.line("  echo $f | egrep -e \"^/\" >/dev/null");
        this.line("  if [ \"$?\" != \"0\" ]; then");
        this.line("    continue  # skip relative directories");
        this.line("  fi");
        this.line("  echo $f | egrep -e \"^/usr/ucb\" >/dev/null");
        this.line("  if [ \"$?\" = \"0\" ]; then");
        this.line("    continue  # skip /usr/ucb (IZ #142780)");
        this.line("  fi");
        this.scanPath();
        this.line("done");
    }

    private void scanPath() {
        for (int i = 0; i < platforms.length; ++i) {
            this.line("if [ \"$PLATFORM\" = \"$" + platforms[i] + "\" ]; then");
            this.platformPath(platformsID[i]);
            this.line("fi");
        }
    }

    private void platformPath(int n) {
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getImpl().getToolchains(n)) {
            ToolchainManager.CompilerDescriptor compilerDescriptor;
            if (toolchainDescriptor.isAbstract() || toolchainDescriptor.getModuleID() != null || (compilerDescriptor = toolchainDescriptor.getC()) == null || compilerDescriptor.getNames().length == 0) continue;
            this.line("status=");
            this.line("while [ ! -n \"$status\" ]; do");
            if (compilerDescriptor.getPathPattern() != null) {
                this.line("  echo $f | egrep -e \"" + compilerDescriptor.getPathPattern() + "\" >/dev/null");
                this.line("  status=$?");
                this.line("  if [ ! \"$status\" = \"0\" ]; then");
                if (compilerDescriptor.getExistFolder() == null) {
                    this.line("    break");
                } else {
                    this.line("    if [ ! -d \"$f/" + compilerDescriptor.getExistFolder() + "\" ]; then");
                    this.line("      break");
                    this.line("    fi");
                }
                this.line("  fi");
            }
            this.line("  file=\"$f/" + compilerDescriptor.getNames()[0] + "\"");
            this.line("  if [ ! -x \"$file\" ]; then");
            if (n == 3) {
                this.line("    file=\"$f/" + compilerDescriptor.getNames()[0] + ".exe\"");
                this.line("    if [ ! -x \"$f/" + compilerDescriptor.getNames()[0] + ".exe\" ]; then");
                this.line("      break");
                this.line("    fi");
            } else {
                this.line("    break");
            }
            this.line("  fi");
            if (compilerDescriptor.getVersionFlags() != null && compilerDescriptor.getVersionPattern() != null) {
                this.line("  $file " + compilerDescriptor.getVersionFlags() + " 2>&1 | egrep -e \"" + compilerDescriptor.getVersionPattern() + "\" >/dev/null");
                this.line("  status=$?");
                this.line("  if [ ! \"$status\" = \"0\" ]; then");
                this.line("    break");
                this.line("  fi");
            }
            this.line("  line=\"" + toolchainDescriptor.getName() + ";$f\"");
            this.line("  flavor=\"" + toolchainDescriptor.getName() + ";\"");
            this.addTool("c", toolchainDescriptor.getC().getNames(), n);
            if (toolchainDescriptor.getCpp() != null) {
                this.addTool("cpp", toolchainDescriptor.getCpp().getNames(), n);
            }
            if (toolchainDescriptor.getFortran() != null) {
                this.addTool("fortran", toolchainDescriptor.getFortran().getNames(), n);
            }
            if (toolchainDescriptor.getAssembler() != null) {
                this.addTool("assembler", toolchainDescriptor.getAssembler().getNames(), n);
            }
            if (toolchainDescriptor.getMake() != null) {
                this.addTool("make", toolchainDescriptor.getMake().getNames(), n);
            }
            if (toolchainDescriptor.getDebugger() != null) {
                this.addTool("debugger", toolchainDescriptor.getDebugger().getNames(), n);
            }
            if (toolchainDescriptor.getCMake() != null) {
                this.addTool("cmake", toolchainDescriptor.getCMake().getNames(), n);
            }
            if (toolchainDescriptor.getQMake() != null) {
                this.addTool("qmake", toolchainDescriptor.getQMake().getNames(), n);
            }
            this.line("  addNewToolChain");
            this.line("  break");
            this.line("done");
        }
    }

    private void addTool(String string, String[] stringArray, int n) {
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                if (stringBuilder.length() > 0) {
                    if (n == 3) {
                        stringBuilder.append(';');
                    } else {
                        stringBuilder.append(':');
                    }
                }
                stringBuilder.append(string2);
            }
            this.line("findCompiler \"" + stringBuilder.toString() + "\" \"" + string + "\"");
        }
    }

    private void lines(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.line(stringTokenizer.nextToken());
        }
    }

    private void line(String string) {
        String string2 = string.trim();
        if (string2.equals("fi") || string2.equals("done") || string2.equals("else") || string2.equals("}")) {
            --this.level;
        }
        if (this.level >= 0) {
            for (int i = 0; i < this.level; ++i) {
                this.buf.append(' ');
                this.buf.append(' ');
            }
        }
        if (string2.startsWith("while ") || string2.startsWith("if ") || string2.startsWith("for ") || string2.equals("else") || string2.endsWith("{")) {
            ++this.level;
        }
        this.buf.append(string2).append('\n');
    }
}

