/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.compilers.CompilerProvider;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.PlatformTypes;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerSet {
    private static final String UNKNOWN = "Unknown";
    public static final String None = "None";
    private CompilerFlavor flavor;
    private String name;
    private String displayName;
    private boolean autoGenerated;
    private boolean isDefault;
    private StringBuilder directory = new StringBuilder(256);
    private final ArrayList<Tool> tools = new ArrayList();
    private String librarySearchOption;
    private String dynamicLibrarySearchOption;
    private String libraryOption;
    private CompilerProvider compilerProvider;
    private String driveLetterPrefix = "/";
    private Map<Integer, String> pathSearch;
    private boolean isSunStudioDefault;

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean bl) {
        this.autoGenerated = bl;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isUrlPointer() {
        if (this.getDirectory() == null || this.getDirectory().length() == 0) {
            return this.flavor.descriptor.getUpdateCenterUrl() != null && this.flavor.descriptor.getModuleID() != null;
        }
        return false;
    }

    void setAsDefault(boolean bl) {
        this.isDefault = bl;
    }

    public void unsetDefault() {
        this.isDefault = false;
    }

    protected CompilerSet(CompilerFlavor compilerFlavor, String string, String string2) {
        this.addDirectory(string);
        this.compilerProvider = CompilerProvider.getInstance();
        this.driveLetterPrefix = compilerFlavor.getToolchainDescriptor().getDriveLetterPrefix();
        this.name = string2 != null ? string2 : compilerFlavor.toString();
        this.displayName = compilerFlavor.getToolchainDescriptor().getDisplayName();
        this.librarySearchOption = compilerFlavor.getToolchainDescriptor().getLinker().getLibrarySearchFlag();
        this.dynamicLibrarySearchOption = compilerFlavor.getToolchainDescriptor().getLinker().getDynamicLibrarySearchFlag();
        this.libraryOption = compilerFlavor.getToolchainDescriptor().getLinker().getLibraryFlag();
        this.flavor = compilerFlavor;
        this.setAutoGenerated(true);
        this.setAsDefault(false);
    }

    protected CompilerSet(int n) {
        this.name = None;
        this.flavor = CompilerFlavor.getUnknown(n);
        this.displayName = NbBundle.getMessage(CompilerSet.class, (String)"LBL_EmptyCompilerSetDisplayName");
        this.compilerProvider = CompilerProvider.getInstance();
        this.setAutoGenerated(true);
        this.setAsDefault(false);
    }

    public CompilerSet createCopy() {
        CompilerSet compilerSet = new CompilerSet(this.flavor, this.getDirectory(), this.name);
        compilerSet.setAutoGenerated(this.isAutoGenerated());
        compilerSet.setAsDefault(this.isDefault());
        for (Tool tool : this.getTools()) {
            compilerSet.addTool(tool.createCopy());
        }
        return compilerSet;
    }

    public static CompilerSet getCompilerSet(ExecutionEnvironment executionEnvironment, String string, int n) {
        CompilerSet compilerSet = CompilerSetManager.getDefault(executionEnvironment).getCompilerSet(CompilerFlavor.toFlavor(string, n));
        if (compilerSet == null) {
            CompilerFlavor compilerFlavor = CompilerFlavor.toFlavor(string, n);
            compilerFlavor = compilerFlavor == null ? CompilerFlavor.getUnknown(n) : compilerFlavor;
            compilerSet = new CompilerSet(compilerFlavor, "", null);
        }
        return compilerSet;
    }

    public static List<CompilerFlavor> getCompilerSetFlavor(String string, int n) {
        ArrayList<CompilerFlavor> arrayList = new ArrayList<CompilerFlavor>();
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getImpl().getToolchains(n)) {
            CompilerFlavor compilerFlavor;
            if (toolchainDescriptor.isAbstract() || !ToolchainManager.getImpl().isMyFolder(string, toolchainDescriptor, n, false) || (compilerFlavor = CompilerFlavor.toFlavor(toolchainDescriptor.getName(), n)) == null) continue;
            arrayList.add(compilerFlavor);
        }
        return arrayList;
    }

    public static CompilerSet getCustomCompilerSet(String string, CompilerFlavor compilerFlavor, String string2) {
        CompilerSet compilerSet = new CompilerSet(compilerFlavor, string, string2);
        compilerSet.setAutoGenerated(false);
        return compilerSet;
    }

    public static CompilerSet getCompilerSet(String string, int n) {
        List<CompilerFlavor> list = CompilerSet.getCompilerSetFlavor(string, n);
        if (list.size() > 0) {
            return new CompilerSet(list.get(0), string, null);
        }
        return new CompilerSet(CompilerFlavor.getUnknown(n), string, null);
    }

    protected static CompilerSet createEmptyCompilerSet(int n) {
        return new CompilerSet(n);
    }

    public boolean isGnuCompiler() {
        return this.flavor.isGnuCompiler();
    }

    public boolean isSunCompiler() {
        return this.flavor.isSunStudioCompiler();
    }

    public CompilerFlavor getCompilerFlavor() {
        return this.flavor;
    }

    public void setFlavor(CompilerFlavor compilerFlavor) {
        this.flavor = compilerFlavor;
    }

    public void addDirectory(String string) {
        if (string != null) {
            if (this.directory.length() == 0) {
                this.directory.append(string);
            } else {
                this.directory.append(File.pathSeparator);
                this.directory.append(string);
            }
        }
    }

    public String getDirectory() {
        return this.directory.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Tool addTool(ExecutionEnvironment executionEnvironment, String string, String string2, int n) {
        if (this.findTool(n) != null) {
            return null;
        }
        Tool tool = this.compilerProvider.createCompiler(executionEnvironment, this.flavor, n, string, Tool.getToolDisplayName(n), string2);
        if (!this.tools.contains(tool)) {
            this.tools.add(tool);
        }
        tool.setCompilerSet(this);
        return tool;
    }

    public void addTool(Tool tool) {
        this.tools.add(tool);
        tool.setCompilerSet(this);
    }

    public Tool addNewTool(ExecutionEnvironment executionEnvironment, String string, String string2, int n) {
        Tool tool = this.compilerProvider.createCompiler(executionEnvironment, this.flavor, n, string, Tool.getToolDisplayName(n), string2);
        this.tools.add(tool);
        tool.setCompilerSet(this);
        return tool;
    }

    public void removeTool(String string, String string2, int n) {
        for (Tool tool : this.tools) {
            if (!tool.getName().equals(string) || !tool.getPath().equals(string2) || tool.getKind() != n) continue;
            this.tools.remove(tool);
            tool.setCompilerSet(null);
            return;
        }
    }

    public void reparent(String string) {
        this.directory = new StringBuilder(256);
        this.addDirectory(string);
        this.tools.clear();
    }

    public Tool getTool(String string) {
        String string2 = null;
        if (Utilities.isWindows()) {
            string2 = string + ".exe";
        }
        for (Tool tool : this.tools) {
            if (!tool.getDisplayName().equals(string) && !tool.getName().equals(string) && (string2 == null || !tool.getName().equals(string2))) continue;
            return tool;
        }
        return null;
    }

    public Tool getTool(String string, int n) {
        String string2 = null;
        if (Utilities.isWindows()) {
            string2 = string + ".exe";
        }
        for (Tool tool : this.tools) {
            if (!tool.getDisplayName().equals(string) && !tool.getName().equals(string) && (string2 == null || !tool.getName().equals(string2)) || n != tool.getKind()) continue;
            return tool;
        }
        CndUtils.assertFalse((boolean)true, (String)"Should not be here, cuz we should create empty tools in CompilerSetManager");
        return this.compilerProvider.createCompiler(ExecutionEnvironmentFactory.getLocal(), CompilerFlavor.getUnknown(PlatformTypes.getDefaultPlatform()), n, "", Tool.getToolDisplayName(n), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tool getTool(int n) {
        for (Tool object2 : this.tools) {
            if (object2.getKind() != n) continue;
            return object2;
        }
        CndUtils.assertFalse((boolean)true, (String)"Should not be here, cuz we should create empty tools in CompilerSetManager");
        Tool tool = this.compilerProvider.createCompiler(ExecutionEnvironmentFactory.getLocal(), this.getCompilerFlavor(), n, "", Tool.getToolDisplayName(n), "");
        tool.setCompilerSet(this);
        ArrayList<Tool> arrayList = this.tools;
        synchronized (arrayList) {
            this.tools.add(tool);
        }
        return tool;
    }

    public Tool findTool(int n) {
        for (Tool tool : this.tools) {
            if (tool.getKind() != n) continue;
            return tool;
        }
        return null;
    }

    @Deprecated
    public boolean isValid() {
        Tool tool = this.getTool(0);
        Tool tool2 = this.getTool(1);
        Tool tool3 = this.getTool(2);
        Tool tool4 = this.getTool(4);
        return tool != null && tool2 != null && tool3 != null && tool4 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tool> getTools() {
        ArrayList<Tool> arrayList = this.tools;
        synchronized (arrayList) {
            return (List)this.tools.clone();
        }
    }

    public String getDynamicLibrarySearchOption() {
        return this.dynamicLibrarySearchOption;
    }

    public void setDynamicLibrarySearchOption(String string) {
        this.dynamicLibrarySearchOption = string;
    }

    public String getLibrarySearchOption() {
        return this.librarySearchOption;
    }

    public void setLibrarySearchOption(String string) {
        this.librarySearchOption = string;
    }

    public String getLibraryOption() {
        return this.libraryOption;
    }

    public void setLibraryOption(String string) {
        this.libraryOption = string;
    }

    public String getDriveLetterPrefix() {
        return this.driveLetterPrefix;
    }

    public String getQmakeSpec(int n) {
        String string = this.flavor.getToolchainDescriptor().getQmakeSpec();
        if (string != null && 0 <= string.indexOf("${os}")) {
            String string2 = null;
            switch (n) {
                case 2: {
                    string2 = "linux";
                    break;
                }
                case 4: {
                    string2 = "macx";
                    break;
                }
                case 0: 
                case 1: {
                    string2 = "solaris";
                    break;
                }
                case 3: {
                    string2 = "win32";
                }
            }
            string = string2 == null ? null : string.replaceAll("\\$\\{os\\}", string2);
        }
        return string;
    }

    public String normalizeDriveLetter(String string) {
        if (string.length() > 1 && string.charAt(1) == ':') {
            return this.getDriveLetterPrefix() + string.charAt(0) + string.substring(2);
        }
        return string;
    }

    void addPathCandidate(int n, String string) {
        if (this.pathSearch == null) {
            this.pathSearch = new HashMap<Integer, String>();
        }
        this.pathSearch.put(n, string);
    }

    String getPathCandidate(int n) {
        if (this.pathSearch == null) {
            return null;
        }
        return this.pathSearch.get(n);
    }

    void setSunStudioDefault(boolean bl) {
        this.isSunStudioDefault = bl;
    }

    boolean isSunStudioDefault() {
        return this.isSunStudioDefault;
    }

    public String toString() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnknownToolchainDescriptor
    implements ToolchainManager.ToolchainDescriptor {
        private UnknownToolchainDescriptor() {
        }

        @Override
        public String getFileName() {
            return "";
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getDisplayName() {
            return "";
        }

        @Override
        public String[] getFamily() {
            return new String[0];
        }

        @Override
        public String[] getPlatforms() {
            return new String[0];
        }

        @Override
        public String getUpdateCenterUrl() {
            return null;
        }

        @Override
        public String getUpdateCenterDisplayName() {
            return null;
        }

        @Override
        public String getUpgradeUrl() {
            return null;
        }

        @Override
        public String getModuleID() {
            return null;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public String getDriveLetterPrefix() {
            return "";
        }

        @Override
        public List<ToolchainManager.BaseFolder> getBaseFolders() {
            return Collections.emptyList();
        }

        @Override
        public List<ToolchainManager.BaseFolder> getCommandFolders() {
            return Collections.emptyList();
        }

        @Override
        public String getQmakeSpec() {
            return "";
        }

        @Override
        public ToolchainManager.CompilerDescriptor getC() {
            return null;
        }

        @Override
        public ToolchainManager.CompilerDescriptor getCpp() {
            return null;
        }

        @Override
        public ToolchainManager.CompilerDescriptor getFortran() {
            return null;
        }

        @Override
        public ToolchainManager.CompilerDescriptor getAssembler() {
            return null;
        }

        @Override
        public ToolchainManager.ScannerDescriptor getScanner() {
            return null;
        }

        @Override
        public ToolchainManager.LinkerDescriptor getLinker() {
            return new ToolchainManager.LinkerDescriptor(){

                public String getLibraryPrefix() {
                    return "";
                }

                public String getLibrarySearchFlag() {
                    return "";
                }

                public String getDynamicLibrarySearchFlag() {
                    return "";
                }

                public String getLibraryFlag() {
                    return "";
                }

                public String getPICFlag() {
                    return "";
                }

                public String getStaticLibraryFlag() {
                    return "";
                }

                public String getDynamicLibraryFlag() {
                    return "";
                }

                public String getDynamicLibraryBasicFlag() {
                    return "";
                }

                public String getOutputFileFlag() {
                    return "";
                }
            };
        }

        @Override
        public ToolchainManager.MakeDescriptor getMake() {
            return null;
        }

        @Override
        public Map<String, List<String>> getDefaultLocations() {
            return Collections.emptyMap();
        }

        @Override
        public ToolchainManager.DebuggerDescriptor getDebugger() {
            return null;
        }

        @Override
        public String getMakefileWriter() {
            return null;
        }

        @Override
        public ToolchainManager.QMakeDescriptor getQMake() {
            return null;
        }

        @Override
        public ToolchainManager.CMakeDescriptor getCMake() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CompilerFlavor {
        private static final List<CompilerFlavor> flavors = new ArrayList<CompilerFlavor>();
        private static final Map<Integer, CompilerFlavor> unknown = new HashMap<Integer, CompilerFlavor>();
        private String sval;
        private ToolchainManager.ToolchainDescriptor descriptor;

        CompilerFlavor(String string, ToolchainManager.ToolchainDescriptor toolchainDescriptor) {
            this.sval = string;
            this.descriptor = toolchainDescriptor;
        }

        public ToolchainManager.ToolchainDescriptor getToolchainDescriptor() {
            return this.descriptor;
        }

        public boolean isGnuCompiler() {
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = this.getToolchainDescriptor();
            if (toolchainDescriptor != null) {
                for (String string : toolchainDescriptor.getFamily()) {
                    if (!"GNU".equals(string)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isSunStudioCompiler() {
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = this.getToolchainDescriptor();
            if (toolchainDescriptor != null) {
                for (String string : toolchainDescriptor.getFamily()) {
                    if (!"SunStudio".equals(string)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isMinGWCompiler() {
            return "MinGW".equals(this.sval);
        }

        public boolean isCygwinCompiler() {
            return "Cygwin".equals(this.sval);
        }

        public String getCommandFolder(int n) {
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = this.getToolchainDescriptor();
            if (toolchainDescriptor != null) {
                return ToolchainManager.getImpl().getCommandFolder(toolchainDescriptor, n);
            }
            return null;
        }

        public static CompilerFlavor getUnknown(int n) {
            CompilerFlavor compilerFlavor = unknown.get(n);
            if (compilerFlavor == null) {
                compilerFlavor = CompilerFlavor._getUnknown(n);
            }
            return compilerFlavor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static CompilerFlavor _getUnknown(int n) {
            CompilerFlavor compilerFlavor = null;
            Map<Integer, CompilerFlavor> map = unknown;
            synchronized (map) {
                compilerFlavor = unknown.get(n);
                if (compilerFlavor == null) {
                    List<ToolchainManager.ToolchainDescriptor> list;
                    ToolchainManager.ToolchainDescriptor toolchainDescriptor = ToolchainManager.getImpl().getToolchain("GNU", n);
                    if (toolchainDescriptor == null && (list = ToolchainManager.getImpl().getToolchains(n)).size() > 0) {
                        toolchainDescriptor = list.get(0);
                    }
                    if (toolchainDescriptor == null) {
                        toolchainDescriptor = new UnknownToolchainDescriptor();
                    }
                    compilerFlavor = new CompilerFlavor(CompilerSet.UNKNOWN, toolchainDescriptor);
                    unknown.put(n, compilerFlavor);
                }
            }
            return compilerFlavor;
        }

        public static CompilerFlavor toFlavor(String string, int n) {
            if (CompilerSet.UNKNOWN.equals(string)) {
                return CompilerFlavor.getUnknown(n);
            }
            for (CompilerFlavor compilerFlavor : flavors) {
                if (!string.equals(compilerFlavor.sval) || !ToolchainManager.getImpl().isPlatforSupported(n, compilerFlavor.getToolchainDescriptor())) continue;
                return compilerFlavor;
            }
            return null;
        }

        public static String mapOldToNew(String string, int n) {
            if (n <= 43) {
                if (string.equals("Sun")) {
                    return "SunStudio";
                }
                if (string.equals("SunExpress")) {
                    return "SunStudioExpress";
                }
                if (string.equals("Sun12")) {
                    return "SunStudio_12";
                }
                if (string.equals("Sun11")) {
                    return "SunStudio_11";
                }
                if (string.equals("Sun10")) {
                    return "SunStudio_10";
                }
                if (string.equals("Sun9")) {
                    return "SunStudio_9";
                }
                if (string.equals("Sun8")) {
                    return "SunStudio_8";
                }
                if (string.equals("DJGPP")) {
                    return "GNU";
                }
                if (string.equals("Interix")) {
                    return "GNU";
                }
                if (string.equals(CompilerSet.UNKNOWN)) {
                    return "GNU";
                }
            }
            return string;
        }

        private static boolean isPlatforSupported(CompilerFlavor compilerFlavor, int n) {
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = compilerFlavor.getToolchainDescriptor();
            if (toolchainDescriptor != null) {
                return ToolchainManager.getImpl().isPlatforSupported(n, toolchainDescriptor);
            }
            return true;
        }

        public static List<CompilerFlavor> getFlavors(int n) {
            ArrayList<CompilerFlavor> arrayList = new ArrayList<CompilerFlavor>();
            for (CompilerFlavor compilerFlavor : flavors) {
                if (!CompilerFlavor.isPlatforSupported(compilerFlavor, n)) continue;
                arrayList.add(compilerFlavor);
            }
            return arrayList;
        }

        public String toString() {
            return this.sval;
        }

        static {
            for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getImpl().getAllToolchains()) {
                flavors.add(new CompilerFlavor(toolchainDescriptor.getName(), toolchainDescriptor));
            }
        }
    }
}

