/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JPanel;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.SelectLibraryWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SelectLibraryVisualPanel
extends JPanel {
    private static final long serialVersionUID = -3903508171781536427L;
    private WizardDescriptor mySettings;
    private final LibraryChooser.Panel myInnerPanel;
    private SelectLibraryWizardPanel myPanel;

    public SelectLibraryVisualPanel(SelectLibraryWizardPanel selectLibraryWizardPanel) {
        this.myPanel = selectLibraryWizardPanel;
        this.getAccessibleContext().setAccessibleName(SelectLibraryVisualPanel.getMessage("ACS_SelectLibraryPanel"));
        this.getAccessibleContext().setAccessibleDescription(SelectLibraryVisualPanel.getMessage("ACS_SelectLibraryPanel"));
        this.myInnerPanel = LibraryChooser.createPanel(null, (LibraryChooser.Filter)new ClassLibraryFilter());
        this.myInnerPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedLibraries".equals(propertyChangeEvent.getPropertyName())) {
                    SelectLibraryVisualPanel.this.checkValidity();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.myInnerPanel.getVisualComponent(), "Center");
    }

    private void checkValidity() {
        this.mySettings.putProperty("WizardPanel_errorMessage", null);
        if (this.getSelectedLibrary() != null) {
            this.setValid(true);
        } else {
            this.setValid(false);
        }
    }

    private final void setValid(boolean bl) {
        this.myPanel.setValid(bl);
    }

    private Library getSelectedLibrary() {
        Set set = this.myInnerPanel.getSelectedLibraries();
        return set.size() == 1 ? (Library)set.iterator().next() : null;
    }

    void storeData() {
        Library library = (Library)this.mySettings.getProperty("library");
        Library library2 = this.getSelectedLibrary();
        this.mySettings.putProperty("library", (Object)library2);
        if (!library2.equals((Object)library)) {
            this.mySettings.putProperty("libName", null);
            this.mySettings.putProperty("displayName", null);
        }
    }

    void readData(WizardDescriptor wizardDescriptor) {
        this.mySettings = wizardDescriptor;
        this.checkValidity();
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(SelectLibraryVisualPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(SelectLibraryVisualPanel.class, (String)string);
    }

    private class ClassLibraryFilter
    implements LibraryChooser.Filter {
        private ClassLibraryFilter() {
        }

        public boolean accept(Library library) {
            return "j2se".equals(library.getType());
        }
    }
}

