/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.apisupport.project.ui.wizard.spi.ModuleTypePanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.CustomComponentWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DocumentAdapter;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class CustomComponentVisualPanel
extends JPanel {
    public static final String PROP_PROJECT_NAME = "projectName";
    public static final String BROWSE = "BROWSE";
    public static final String LBL_SELECT_LOCATION_DLG = "LBL_SelectProjectLocation";
    public static final String MSG_NAME_CANNOT_BE_EMPTY = "MSG_NameCannotBeEmpty";
    public static final String MSG_LOCATION_CANNOT_BE_EMPTY = "MSG_LocationCannotBeEmpty";
    public static final String MSG_LOCATION_MUST_EXIST = "MSG_LocationMustExist";
    public static final String MSG_IS_NOT_DIRECTORY = "MSG_IsNotAFolder";
    public static final String MSG_CANT_CREATE_FOLDER = "MSG_CanNotCreateFolder";
    public static final String MSG_ILLEGAL_FOLDER_PATH = "MSG_IllegalFolderPath";
    public static final String MSG_FOLDER_EXISTS = "MSG_ProjectFolderExists";
    public static final String TXT_DEFAULT_PROJECT_NAME = "TXT_DefaultProjectName";
    public static final String ACSN_PROJECT_PANEL = "ACSN_ProjectPanel";
    public static final String ACSD_PROJECT_PANEL = "ACSD_ProjectPanel";
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JPanel fillerPanel;
    private JPanel infoPanel;
    private JCheckBox mainProject;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JPanel typeChooserPanelContainer;
    private WizardDescriptor mySettings;
    private CustomComponentWizardPanel myPanel;
    private JComponent typeChooserPanel;
    private boolean locationUpdated;
    private boolean mainProjectTouched;
    private boolean listenersAttached;
    private DocumentListener nameDL;
    private DocumentListener locationDL;
    private ActionListener isMainAL;

    public CustomComponentVisualPanel(CustomComponentWizardPanel customComponentWizardPanel) {
        this.initComponents();
        this.myPanel = customComponentWizardPanel;
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"TXT_MobileDesigner"));
        this.initDocumentListeners();
        this.attachDocumentListeners();
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
        this.projectNameTextField.requestFocus();
    }

    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.createdFolderTextField.getText().trim();
        Boolean bl = this.mainProject.isSelected();
        wizardDescriptor.putProperty("projDir", (Object)new File(string2));
        wizardDescriptor.putProperty("projName", (Object)string);
        wizardDescriptor.putProperty("setAsMain", (Object)bl);
    }

    void read(WizardDescriptor wizardDescriptor) {
        if (this.mySettings == null) {
            this.mySettings = wizardDescriptor;
            this.mySettings.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (ModuleTypePanel.isPanelUpdated((PropertyChangeEvent)propertyChangeEvent)) {
                        CustomComponentVisualPanel.this.moduleTypePanelUpdated();
                    }
                }
            });
            this.initPanels(this.mySettings);
        }
        if (this.getIsMainProject() != null) {
            this.mainProject.setSelected(this.getIsMainProject());
        }
        this.setLocation(this.getProjectLocation().getAbsolutePath());
        this.projectNameTextField.setText(this.getProjectName());
        this.projectNameTextField.selectAll();
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(CustomComponentVisualPanel.class);
    }

    private void initDocumentListeners() {
        this.nameDL = new DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CustomComponentVisualPanel.this.updateTexts(documentEvent);
                CustomComponentVisualPanel.this.checkValidity();
            }
        };
        this.locationDL = new DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CustomComponentVisualPanel.this.locationUpdated = true;
                CustomComponentVisualPanel.this.updateTexts(documentEvent);
                CustomComponentVisualPanel.this.checkValidity();
            }
        };
        this.isMainAL = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomComponentVisualPanel.this.mainProjectTouched = true;
            }
        };
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.projectNameTextField.getDocument().addDocumentListener(this.nameDL);
            this.projectLocationTextField.getDocument().addDocumentListener(this.locationDL);
            this.mainProject.addActionListener(this.isMainAL);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.projectNameTextField.getDocument().removeDocumentListener(this.nameDL);
            this.projectLocationTextField.getDocument().removeDocumentListener(this.locationDL);
            this.mainProject.removeActionListener(this.isMainAL);
            this.listenersAttached = false;
        }
    }

    private void initPanels(WizardDescriptor wizardDescriptor) {
        if (this.typeChooserPanel != null) {
            this.typeChooserPanelContainer.removeAll();
            this.typeChooserPanel = null;
        }
        this.typeChooserPanel = ModuleTypePanel.createComponent((WizardDescriptor)wizardDescriptor);
        this.typeChooserPanelContainer.add((Component)this.typeChooserPanel, "Center");
        this.typeChooserPanelContainer.validate();
        this.validate();
    }

    private void moduleTypePanelUpdated() {
        boolean bl = ModuleTypePanel.isStandalone((WizardDescriptor)this.getSettings());
        boolean bl2 = ModuleTypePanel.isSuiteComponent((WizardDescriptor)this.getSettings());
        if (!bl && !bl2) {
            return;
        }
        if (!this.mainProjectTouched) {
            this.mainProject.setSelected(bl);
        }
        if (!this.locationUpdated) {
            this.setLocation(this.computeInitialLocationValue());
        }
        this.checkValidity();
    }

    private void setLocation(String string) {
        boolean bl = !this.locationUpdated;
        this.projectLocationTextField.setText(string);
        this.locationUpdated = bl ^ true;
    }

    boolean checkValidity() {
        if (!this.isProjectNameValid()) {
            return false;
        }
        if (!this.isProjectLocationValid()) {
            return false;
        }
        if (!this.isCreatedFolderValid()) {
            return false;
        }
        if (!ModuleTypePanel.validate((WizardDescriptor)this.getSettings())) {
            return false;
        }
        this.markValid();
        return true;
    }

    private boolean isProjectNameValid() {
        if (this.getProjectNameValue().trim().length() == 0) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_NAME_CANNOT_BE_EMPTY, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isProjectLocationValid() {
        String string = this.getProjectLocationValue().trim();
        File file = FileUtil.normalizeFile((File)new File(string).getAbsoluteFile());
        if (string.length() == 0) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_LOCATION_CANNOT_BE_EMPTY, new Object[0]));
            return false;
        }
        if (!file.exists()) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_LOCATION_MUST_EXIST, new Object[0]));
            return false;
        }
        if (!file.isDirectory()) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_IS_NOT_DIRECTORY, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCreatedFolderValid() {
        File file;
        File file2;
        String string = this.getCreatedFolderValue();
        for (file2 = file = FileUtil.normalizeFile((File)new File(string).getAbsoluteFile()); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null || !file2.canWrite()) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_CANT_CREATE_FOLDER, new Object[0]));
            return false;
        }
        if (FileUtil.toFileObject((File)file2) == null) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_ILLEGAL_FOLDER_PATH, new Object[0]));
            return false;
        }
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            this.setError(CustomComponentVisualPanel.getMessage(MSG_FOLDER_EXISTS, new Object[0]));
            return false;
        }
        return true;
    }

    private String getProjectNameValue() {
        return this.projectNameTextField.getText();
    }

    private String getProjectLocationValue() {
        return this.projectLocationTextField.getText();
    }

    private String getCreatedFolderValue() {
        return this.createdFolderTextField.getText();
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(CustomComponentVisualPanel.class, (String)string, (Object[])objectArray);
    }

    protected final void setError(String string) {
        assert (string != null);
        this.setMessage(string);
        this.setValid(false);
    }

    private final void setValid(boolean bl) {
        this.myPanel.setValid(bl);
    }

    private final void setMessage(String string) {
        this.getSettings().putProperty("WizardPanel_errorMessage", (Object)string);
    }

    protected final void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    File getProjectLocation() {
        File file = (File)this.getSettings().getProperty("projDir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? new File(this.computeInitialLocationValue()) : file.getParentFile();
        return file;
    }

    private String computeInitialLocationValue() {
        if (this.typeChooserPanel != null && this.isSuiteComponent().booleanValue()) {
            return this.computeLocationValue(this.getSelectedSuite());
        }
        String string = ProjectChooser.getProjectsFolder().getAbsolutePath();
        return this.computeLocationValue(string);
    }

    private String computeLocationValue(String string) {
        File file;
        if (string == null) {
            string = System.getProperty("user.home");
        }
        if (!(file = new File(string)).exists() && file.getParent() != null) {
            return this.computeLocationValue(file.getParent());
        }
        return file.exists() ? string : System.getProperty("user.home");
    }

    private Boolean isSuiteComponent() {
        if (this.getSettings() != null) {
            return ModuleTypePanel.isSuiteComponent((WizardDescriptor)this.getSettings());
        }
        return false;
    }

    private String getSelectedSuite() {
        return ModuleTypePanel.getSuiteRoot((WizardDescriptor)this.getSettings());
    }

    String getProjectName() {
        String string = (String)this.getSettings().getProperty("projName");
        if (string == null) {
            string = this.getDefaultFreeName(this.getProjectLocation());
        }
        return string;
    }

    Boolean getIsMainProject() {
        Boolean bl = (Boolean)this.getSettings().getProperty("setAsMain");
        return bl;
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    private void initComponents() {
        this.mainProject = new JCheckBox();
        this.infoPanel = new JPanel();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.createdFolderTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.createdFolderLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.typeChooserPanelContainer = new JPanel();
        this.fillerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.mainProject.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProject, (String)NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"LBL_SetAsMainProject"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.mainProject, gridBagConstraints);
        this.mainProject.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_SetAsMainProject"));
        this.mainProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSD_SetAsMainProject"));
        this.infoPanel.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.infoPanel.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_ProjectName"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSD_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.infoPanel.add((Component)this.projectNameTextField, gridBagConstraints);
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.infoPanel.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"LBL_ProjectLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.infoPanel.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_ProjectLocation"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSD_ProjectLocation"));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"LBL_ProjectFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.infoPanel.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_ProjectFolder"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSD_ProjectFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.infoPanel.add((Component)this.projectLocationTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"LBL_Browse_Button"));
        this.browseButton.setActionCommand(BROWSE);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomComponentVisualPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.infoPanel.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_Browse_Button"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)"ACSN_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.infoPanel, gridBagConstraints);
        this.typeChooserPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.typeChooserPanelContainer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPanel, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (BROWSE.equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogTitle(LBL_SELECT_LOCATION_DLG);
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                String string3 = FileUtil.normalizeFile((File)file).getAbsolutePath();
                this.projectLocationTextField.setText(this.computeLocationValue(string3));
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSN_PROJECT_PANEL));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSD_PROJECT_PANEL));
    }

    private String getDefaultFreeName(File file) {
        String string;
        int n = 1;
        while ((string = this.validFreeProjectName(file, n++)) == null) {
        }
        return string;
    }

    private String validFreeProjectName(File file, int n) {
        String string = NbBundle.getMessage(CustomComponentVisualPanel.class, (String)TXT_DEFAULT_PROJECT_NAME, (Object[])new Object[]{n});
        File file2 = new File(file, string);
        if (file2.exists()) {
            return null;
        }
        return string;
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
            this.projectFolderChanged(this.getCreatedFolderValue());
        }
    }

    private void projectFolderChanged(String string) {
        File file = FileUtil.normalizeFile((File)new File(string));
        ModuleTypePanel.setProjectFolder((WizardDescriptor)this.getSettings(), (File)file);
    }

    private WizardDescriptor getSettings() {
        return this.mySettings;
    }
}

