/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPFieldMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.Field;
import org.netbeans.modules.classfile.InvalidClassFileAttributeException;

public final class Variable
extends Field {
    private Object constValue = notLoadedConstValue;
    private static final Object notLoadedConstValue = new Object();

    static Variable[] loadFields(DataInputStream dataInputStream, ConstantPool constantPool, ClassFile classFile) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        Variable[] variableArray = new Variable[n];
        for (int i = 0; i < n; ++i) {
            variableArray[i] = new Variable(dataInputStream, constantPool, classFile);
        }
        return variableArray;
    }

    Variable(DataInputStream dataInputStream, ConstantPool constantPool, ClassFile classFile) throws IOException {
        super(dataInputStream, constantPool, classFile, false);
    }

    public final boolean isConstant() {
        return this.attributes.get("ConstantValue") != null;
    }

    @Deprecated
    public final Object getValue() {
        return this.getConstantValue();
    }

    public final Object getConstantValue() {
        DataInputStream dataInputStream;
        if (this.constValue == notLoadedConstValue && (dataInputStream = this.attributes.getStream("ConstantValue")) != null) {
            try {
                int n = dataInputStream.readUnsignedShort();
                CPEntry cPEntry = this.classFile.constantPool.get(n);
                this.constValue = cPEntry.getValue();
            }
            catch (IOException iOException) {
                throw new InvalidClassFileAttributeException("invalid ConstantValue attribute", iOException);
            }
        }
        return this.constValue;
    }

    public final String getDeclaration() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CPFieldMethodInfo.getSignature(this.getDescriptor(), false));
        stringBuffer.append(' ');
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    public final boolean isEnumConstant() {
        return (this.access & 0x4000) == 16384;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.isConstant()) {
            stringBuffer.append(", const value=");
            stringBuffer.append(this.getValue());
        }
        return stringBuffer.toString();
    }
}

