/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.projects.MainProjectManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class RunToCursorActionProvider
extends ActionsProviderSupport {
    private EditorContextDispatcher editorContext = EditorContextDispatcher.getDefault();
    private LineBreakpoint breakpoint;

    public RunToCursorActionProvider() {
        Listener listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener((PropertyChangeListener)((Object)listener));
        this.editorContext.addPropertyChangeListener("text/x-java", WeakListeners.propertyChange((PropertyChangeListener)((Object)listener), (Object)this.editorContext));
        DebuggerManager.getDebuggerManager().addDebuggerListener("debuggerEngines", (DebuggerManagerListener)listener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, RunToCursorActionProvider.this.shouldBeEnabled());
            }
        });
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }

    public void doAction(Object object) {
        this.removeBreakpoint();
        this.createBreakpoint(LineBreakpoint.create((String)this.editorContext.getCurrentURLAsString(), (int)this.editorContext.getCurrentLineNumber()));
        this.invokeAction();
    }

    public void postAction(Object object, final Runnable runnable) {
        final LineBreakpoint lineBreakpoint = LineBreakpoint.create((String)this.editorContext.getCurrentURLAsString(), (int)this.editorContext.getCurrentLineNumber());
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RunToCursorActionProvider.this.removeBreakpoint();
                RunToCursorActionProvider.this.createBreakpoint(lineBreakpoint);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            RunToCursorActionProvider.this.invokeAction();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                }
                finally {
                    runnable.run();
                }
            }
        });
    }

    private void invokeAction() {
        Collection collection;
        FileObject fileObject = (FileObject)Utilities.actionsGlobalContext().lookup(FileObject.class);
        if (fileObject != null && !(collection = SourceUtils.getMainClasses((FileObject)fileObject)).isEmpty() && RunToCursorActionProvider.debugFile(fileObject)) {
            return;
        }
        RunToCursorActionProvider.debugProject(MainProjectManager.getDefault().getMainProject());
    }

    private static void debugProject(Project project) {
        ((ActionProvider)project.getLookup().lookup(ActionProvider.class)).invokeAction("debug", project.getLookup());
    }

    private static boolean debugFile(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider.isActionEnabled("debug.single", Utilities.actionsGlobalContext())) {
            actionProvider.invokeAction("debug.single", Utilities.actionsGlobalContext());
            return true;
        }
        return false;
    }

    private boolean shouldBeEnabled() {
        int n;
        if (this.editorContext.getCurrentLineNumber() < 0) {
            return false;
        }
        FileObject fileObject = this.editorContext.getCurrentFile();
        if (fileObject == null || !fileObject.hasExt("java")) {
            return false;
        }
        Project project = MainProjectManager.getDefault().getMainProject();
        if (project == null) {
            return false;
        }
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] stringArray = actionProvider.getSupportedActions();
        int n2 = stringArray.length;
        for (n = 0; n < n2 && !"debug".equals(stringArray[n]); ++n) {
        }
        if (n == n2) {
            return false;
        }
        return actionProvider.isActionEnabled("debug", project.getLookup());
    }

    private void createBreakpoint(LineBreakpoint lineBreakpoint) {
        lineBreakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)lineBreakpoint);
        this.breakpoint = lineBreakpoint;
    }

    private void removeBreakpoint() {
        if (this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
    }

    private class Listener
    extends DebuggerManagerAdapter {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "state") {
                int n = (Integer)propertyChangeEvent.getNewValue();
                if (n == 4 || n == 3) {
                    RunToCursorActionProvider.this.removeBreakpoint();
                }
                return;
            }
            RunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, RunToCursorActionProvider.this.shouldBeEnabled());
        }

        public void engineAdded(DebuggerEngine debuggerEngine) {
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
            if (jPDADebugger == null) {
                return;
            }
            jPDADebugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
        }

        public void engineRemoved(DebuggerEngine debuggerEngine) {
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
            if (jPDADebugger == null) {
                return;
            }
            jPDADebugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
        }
    }
}

