/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.Beans;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.Util;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExClipboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManifestSection<T> {
    private final Object superclazz;
    private final String name;
    private final String className;
    private Class<?> clazz;
    private Object result;
    private Exception problem;
    private final Module module;

    protected ManifestSection(String string, Module module, Object object) throws InvalidException {
        this.name = string;
        this.module = module;
        this.superclazz = object;
        try {
            this.className = Util.createPackageName((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidException invalidException = new InvalidException(module, illegalArgumentException.toString());
            invalidException.initCause((Throwable)illegalArgumentException);
            throw invalidException;
        }
    }

    public final Module getModule() {
        return this.module;
    }

    protected final ClassLoader getClassLoader() {
        return this.module != null ? this.module.getClassLoader() : this.getClass().getClassLoader();
    }

    public final boolean isDefaultInstance() {
        return this.name.endsWith(".class");
    }

    public final Class<?> getSectionClass() throws Exception {
        if (this.clazz != null) {
            return this.clazz;
        }
        if (this.problem != null) {
            throw this.problem;
        }
        if (this.isDefaultInstance()) {
            try {
                this.clazz = this.getClassLoader().loadClass(this.className);
                if (!this.getSuperclass().isAssignableFrom(this.clazz)) {
                    throw new ClassCastException("Class " + this.clazz.getName() + " is not a subclass of " + this.getSuperclass().getName());
                }
                if (this.clazz.getClassLoader() != this.getClassLoader()) {
                    Events events = this.module.getManager().getEvents();
                    events.log("wrongClassLoader", new Object[]{this.module, this.clazz, this.getClassLoader()});
                }
                return this.clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.attachMessage((Throwable)classNotFoundException, (String)("Loader for ClassNotFoundException: " + this.getClassLoader()));
                this.problem = classNotFoundException;
                throw this.problem;
            }
            catch (Exception exception) {
                this.problem = exception;
                throw this.problem;
            }
            catch (LinkageError linkageError) {
                this.problem = new ClassNotFoundException(linkageError.toString(), linkageError);
                throw this.problem;
            }
        }
        this.clazz = this.getInstance().getClass();
        return this.clazz;
    }

    public String getSectionClassName() throws Exception {
        if (this.isDefaultInstance()) {
            return this.className;
        }
        return this.getSectionClass().getName();
    }

    protected final Object createInstance() throws Exception {
        if (!this.isDefaultInstance()) {
            try {
                Object object = Beans.instantiate(this.getClassLoader(), this.className);
                this.clazz = object.getClass();
                if (!this.getSectionClass().isAssignableFrom(this.clazz)) {
                    throw new ClassCastException("Class " + this.clazz.getName() + " is not a subclass of " + this.getSuperclass().getName());
                }
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.attachMessage((Throwable)classNotFoundException, (String)("Loader for ClassNotFoundException: " + this.getClassLoader()));
                throw classNotFoundException;
            }
            catch (LinkageError linkageError) {
                throw new ClassNotFoundException(linkageError.toString(), linkageError);
            }
        }
        this.getSectionClass();
        if (SharedClassObject.class.isAssignableFrom(this.clazz)) {
            return SharedClassObject.findObject(this.clazz.asSubclass(SharedClassObject.class), (boolean)true);
        }
        return this.clazz.newInstance();
    }

    public final Object getInstance() throws Exception {
        if (this.problem != null) {
            this.problem.fillInStackTrace();
            throw this.problem;
        }
        if (this.result == null) {
            try {
                this.result = this.createInstance();
            }
            catch (Exception exception) {
                this.problem = exception;
                throw this.problem;
            }
            catch (LinkageError linkageError) {
                this.problem = new ClassNotFoundException(linkageError.toString(), linkageError);
                throw this.problem;
            }
        }
        return this.result;
    }

    public final Class<?> getSuperclass() {
        if (this.superclazz instanceof Class) {
            return (Class)this.superclazz;
        }
        try {
            return ManifestSection.getClazz((String)this.superclazz, this.module);
        }
        catch (InvalidException invalidException) {
            throw (IllegalStateException)new IllegalStateException(this.superclazz.toString()).initCause(invalidException);
        }
    }

    public void dispose() {
        this.result = null;
        this.problem = null;
        this.clazz = null;
    }

    public String toString() {
        return "ManifestSection[" + this.className + "]";
    }

    public static ManifestSection create(String string, Attributes attributes, Module module) throws InvalidException {
        String string2 = attributes.getValue("OpenIDE-Module-Class");
        if (string2 == null) {
            return null;
        }
        if (string2.equalsIgnoreCase("Action")) {
            return new ActionSection(string, module);
        }
        if (string2.equalsIgnoreCase("Option")) {
            ManifestSection.warnObsolete(string2, module);
            return null;
        }
        if (string2.equalsIgnoreCase("Loader")) {
            ManifestSection.warnObsolete(string2, module);
            return new LoaderSection(string, attributes, module);
        }
        if (string2.equalsIgnoreCase("Filesystem")) {
            ManifestSection.warnObsolete(string2, module);
            return null;
        }
        if (string2.equalsIgnoreCase("Node")) {
            ManifestSection.warnObsolete(string2, module);
            Util.err.warning("(See http://www.netbeans.org/issues/show_bug.cgi?id=19609, last comment, for howto.)");
            return null;
        }
        if (string2.equalsIgnoreCase("Service")) {
            ManifestSection.warnObsolete(string2, module);
            return null;
        }
        if (string2.equalsIgnoreCase("Debugger")) {
            ManifestSection.warnObsolete(string2, module);
            return new DebuggerSection(string, module);
        }
        if (string2.equalsIgnoreCase("ClipboardConvertor")) {
            ManifestSection.warnObsolete(string2, module);
            return new ClipboardConvertorSection(string, module);
        }
        throw new InvalidException(module, "Illegal manifest section type: " + string2);
    }

    private static void warnObsolete(String string, Module module) {
        if (module == null) {
            return;
        }
        Util.err.warning("Use of OpenIDE-Module-Class: " + string + " in " + module.getCodeNameBase() + " is obsolete.");
        Util.err.warning("(Please use layer-based installation of objects instead.)");
    }

    static Class<?> getClazz(String string, Module module) throws InvalidException {
        try {
            return ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            InvalidException invalidException = new InvalidException(module, "Unable to locate class: " + string + " maybe you do not have its module enabled!?");
            invalidException.initCause((Throwable)classNotFoundException);
            throw invalidException;
        }
    }

    @Deprecated
    public static final class ClipboardConvertorSection
    extends ManifestSection {
        ClipboardConvertorSection(String string, Module module) throws InvalidException {
            super(string, module, ExClipboard.Convertor.class);
        }
    }

    @Deprecated
    public static final class DebuggerSection
    extends ManifestSection {
        DebuggerSection(String string, Module module) throws InvalidException {
            super(string, module, DebuggerSection.getClazz("org.openide.debugger.Debugger", module));
        }
    }

    public static final class LoaderSection
    extends ManifestSection {
        private final String[] installAfter;
        private final String[] installBefore;

        LoaderSection(String string, Attributes attributes, Module module) throws InvalidException {
            super(string, module, "org.openide.loaders.DataLoader");
            String string2;
            LinkedList<String> linkedList;
            StringTokenizer stringTokenizer;
            String string3 = attributes.getValue("Install-After");
            if (string3 != null) {
                stringTokenizer = new StringTokenizer(string3, ", ");
                linkedList = new LinkedList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals("")) continue;
                    linkedList.add(string2);
                }
                this.installAfter = linkedList.toArray(new String[linkedList.size()]);
            } else {
                this.installAfter = null;
            }
            string3 = attributes.getValue("Install-Before");
            if (string3 != null) {
                stringTokenizer = new StringTokenizer(string3, ", ");
                linkedList = new LinkedList();
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals("")) continue;
                    linkedList.add(string2);
                }
                this.installBefore = linkedList.toArray(new String[linkedList.size()]);
            } else {
                this.installBefore = null;
            }
        }

        public String[] getInstallAfter() {
            return this.installAfter;
        }

        public String[] getInstallBefore() {
            return this.installBefore;
        }
    }

    public static final class ActionSection
    extends ManifestSection {
        ActionSection(String string, Module module) throws InvalidException {
            super(string, module, SystemAction.class);
        }
    }
}

