/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.ColorsManager;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;

class LanguagesHighlightsLayer
extends AbstractHighlightsContainer {
    private Document document;

    LanguagesHighlightsLayer(Document document) {
        this.document = document;
    }

    public HighlightsSequence getHighlights(int n, int n2) {
        TokenSequence tokenSequence = TokenHierarchy.get((Document)this.document).tokenSequence();
        if (tokenSequence != null) {
            return new Highlights(tokenSequence, n, n2);
        }
        return HighlightsSequence.EMPTY;
    }

    private static class Highlights
    implements HighlightsSequence {
        private int endOffset;
        private int startOffset1;
        private int endOffset1;
        private SimpleAttributeSet attributeSet;
        private TokenSequence tokenSequence;
        private String mimeType;
        private Map<String, Map<String, Color>> tokenImportColors = new HashMap<String, Map<String, Color>>();
        private Map<String, Color> preprocessorImportColors;

        private Highlights(TokenSequence tokenSequence, int n, int n2) {
            this.tokenSequence = tokenSequence;
            this.mimeType = tokenSequence.language().mimeType();
            this.endOffset = n2;
            this.startOffset1 = n;
            this.endOffset1 = n;
        }

        public boolean moveNext() {
            if (this.tokenSequence == null) {
                return false;
            }
            this.attributeSet = new SimpleAttributeSet();
            do {
                this.startOffset1 = this.endOffset1;
                this.mark(this.tokenSequence);
                if (this.endOffset1 > this.startOffset1) {
                    return true;
                }
                this.tokenSequence.move(this.startOffset1);
                if (!this.tokenSequence.moveNext()) {
                    return false;
                }
                Token token = this.tokenSequence.token();
                this.endOffset1 = this.tokenSequence.offset() + token.length();
            } while (this.endOffset1 < this.endOffset);
            return false;
        }

        public int getStartOffset() {
            return this.startOffset1;
        }

        public int getEndOffset() {
            return this.endOffset1;
        }

        public AttributeSet getAttributes() {
            return this.attributeSet;
        }

        private void mark(TokenSequence tokenSequence) {
            Color color;
            tokenSequence.move(this.startOffset1);
            if (!tokenSequence.moveNext()) {
                return;
            }
            Token token = tokenSequence.token();
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 == null) {
                return;
            }
            String string = tokenSequence.language().mimeType();
            String string2 = tokenSequence2.language().mimeType();
            if (token.id().name().equals("PE")) {
                Color color2 = this.getPreprocessorImportsColor(string2);
                if (color2 != null) {
                    this.attributeSet.addAttribute(StyleConstants.Background, color2);
                    this.attributeSet.addAttribute(HighlightsContainer.ATTR_EXTENDS_EOL, Boolean.TRUE);
                    this.endOffset1 = this.tokenSequence.offset() + token.length();
                }
            } else if (!string.equals(string2) && (color = this.getTokenImportsColor(string, string2, token.id().name())) != null) {
                this.attributeSet.addAttribute(StyleConstants.Background, color);
                this.attributeSet.addAttribute(HighlightsContainer.ATTR_EXTENDS_EOL, Boolean.TRUE);
                this.endOffset1 = this.tokenSequence.offset() + token.length();
            }
            this.mark(tokenSequence2);
        }

        private Color getPreprocessorImportsColor(String string) {
            if (this.preprocessorImportColors == null) {
                this.preprocessorImportColors = new HashMap<String, Color>();
                try {
                    Language language = LanguagesManager.getDefault().getLanguage(this.mimeType);
                    Feature feature = language.getPreprocessorImport();
                    if (feature != null) {
                        String string2 = (String)feature.getValue("mimeType");
                        Color color = ColorsManager.readColor((String)feature.getValue("background_color"));
                        if (color != null) {
                            this.preprocessorImportColors.put(string2, color);
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return this.preprocessorImportColors.get(string);
        }

        private Color getTokenImportsColor(String string, String string2, String string3) {
            Map<String, Color> map = this.tokenImportColors.get(string);
            if (map == null) {
                map = new HashMap<String, Color>();
                this.tokenImportColors.put(string, map);
                try {
                    Language language = LanguagesManager.getDefault().getLanguage(string);
                    Map<String, Feature> map2 = language.getTokenImports();
                    for (String string4 : map2.keySet()) {
                        Feature feature = map2.get(string4);
                        Color color = ColorsManager.readColor((String)feature.getValue("background_color"));
                        if (color == null) continue;
                        map.put(string4, color);
                    }
                }
                catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                    // empty catch block
                }
            }
            if (map.containsKey(string3)) {
                return map.get(string3);
            }
            return map.get(string2);
        }
    }
}

