/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLFFilesCustomEditor
extends JPanel {
    private JButton bEdit;
    private JLabel jLabel1;
    private JList lFiles;
    private JScrollPane spFiles;

    public GLFFilesCustomEditor() {
        this.initComponents();
        List<String> list = GLFFilesCustomEditor.getSupportedMimeTypes();
        Collections.sort(list);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : list) {
            defaultListModel.addElement(string);
        }
        this.lFiles.setModel(defaultListModel);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.spFiles = new JScrollPane();
        this.lFiles = new JList();
        this.bEdit = new JButton();
        this.jLabel1.setText(NbBundle.getMessage(GLFFilesCustomEditor.class, (String)"GLFFilesCustomEditor.jLabel1.text"));
        this.spFiles.setViewportView(this.lFiles);
        this.bEdit.setText(NbBundle.getMessage(GLFFilesCustomEditor.class, (String)"GLFFilesCustomEditor.bEdit.text"));
        this.bEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GLFFilesCustomEditor.this.bEditActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.spFiles, -1, 75, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bEdit)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.bEdit).addContainerGap()).add((Component)this.spFiles, -1, 139, Short.MAX_VALUE))));
    }

    private static List<String> getSupportedMimeTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Editors");
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (fileObject2.isData()) continue;
            Enumeration enumeration2 = fileObject2.getChildren(false);
            while (enumeration2.hasMoreElements()) {
                FileObject fileObject3;
                FileObject fileObject4 = (FileObject)enumeration2.nextElement();
                if (fileObject4.isData() || (fileObject3 = fileObject4.getFileObject("language.nbs")) == null) continue;
                arrayList.add(fileObject2.getName() + '/' + fileObject4.getName());
            }
        }
        return arrayList;
    }

    private void bEditActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.lFiles.getSelectedValue();
        if (string == null) {
            return;
        }
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + string + "/language.nbs");
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            openCookie.open();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
    }
}

