/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.libs.freemarker.FreemarkerEngine;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

final class RsrcLoader
extends Configuration
implements TemplateLoader,
TemplateExceptionHandler {
    private static final Logger LOG = Logger.getLogger(FreemarkerEngine.class.getName());
    private FileObject fo;
    private ScriptContext map;
    private Bindings engineScope;

    RsrcLoader(FileObject fileObject, ScriptContext scriptContext) {
        this.fo = fileObject;
        this.map = scriptContext;
        this.engineScope = scriptContext.getBindings(100);
        this.setTemplateLoader(this);
        this.setTemplateExceptionHandler(this);
        Logger.getLogger("freemarker.runtime").setLevel(Level.OFF);
    }

    public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
        try {
            writer.append(templateException.getLocalizedMessage());
            LOG.log(Level.INFO, "Failure processing " + this.fo, templateException);
            LOG.log(Level.INFO, "Bindings:");
            for (Map.Entry entry : this.engineScope.entrySet()) {
                LOG.log(Level.INFO, "  key: " + (String)entry.getKey() + " value: " + entry.getValue());
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private FileObject getFile(String string) {
        FileObject fileObject = this.getFolder() == null ? null : this.getFolder().getFileObject(string);
        return fileObject;
    }

    private FileObject getFolder() {
        try {
            return this.fo.getFileSystem().getRoot();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return FileUtil.getConfigRoot();
        }
    }

    public Object findTemplateSource(String string) throws IOException {
        FileObject fileObject = this.getFile(string);
        return fileObject == null ? null : new Wrap(fileObject);
    }

    public long getLastModified(Object object) {
        return ((Wrap)object).fo.lastModified().getTime();
    }

    public Reader getReader(Object object, String string) throws IOException {
        Wrap wrap = (Wrap)object;
        if (wrap.reader == null) {
            Charset charset = FileEncodingQuery.getEncoding((FileObject)wrap.fo);
            wrap.reader = new InputStreamReader(wrap.fo.getInputStream(), charset);
        }
        return wrap.reader;
    }

    public void closeTemplateSource(Object object) throws IOException {
        Wrap wrap = (Wrap)object;
        if (wrap.reader != null) {
            wrap.reader.close();
        }
    }

    public Object put(String string, Object object) {
        assert (false);
        return null;
    }

    public TemplateModel getSharedVariable(String string) {
        Object object = this.map.getAttribute(string);
        if (object == null) {
            object = this.engineScope.get(string);
        }
        if (object == null && this.fo != null) {
            object = this.fo.getAttribute(string);
        }
        try {
            return this.getObjectWrapper().wrap(object);
        }
        catch (TemplateModelException templateModelException) {
            Exceptions.printStackTrace((Throwable)templateModelException);
            return null;
        }
    }

    public Set getSharedVariableNames() {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (this.map != null) {
            linkedHashSet.addAll(this.map.getBindings(100).keySet());
        }
        if (this.fo != null) {
            Enumeration enumeration = this.fo.getAttributes();
            while (enumeration.hasMoreElements()) {
                linkedHashSet.add(enumeration.nextElement());
            }
        }
        return linkedHashSet;
    }

    private static final class Wrap {
        public FileObject fo;
        public Reader reader;

        public Wrap(FileObject fileObject) {
            this.fo = fileObject;
        }
    }
}

