/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.upgrade.systemoptions.DefaultResult;
import org.netbeans.upgrade.systemoptions.PropertiesStorage;
import org.netbeans.upgrade.systemoptions.SystemOptionsParser;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Importer {
    private static final String DEFINITION_OF_FILES = "systemoptionsimport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doImport() throws IOException {
        Set<FileObject> set = Importer.getImportFiles(Importer.loadImportFilesDefinition());
        Iterator<DefaultResult> iterator = Importer.parse(set).iterator();
        while (iterator.hasNext()) {
            Importer.saveResult(iterator.next());
        }
        for (FileObject fileObject : set) {
            FileLock fileLock = fileObject.lock();
            try {
                fileObject.rename(fileLock, fileObject.getName(), "imported");
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    private static void saveResult(DefaultResult defaultResult) throws IOException {
        String string = "/" + defaultResult.getModuleName();
        PropertiesStorage propertiesStorage = PropertiesStorage.instance(string);
        Properties properties = propertiesStorage.load();
        String[] stringArray = defaultResult.getPropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = defaultResult.getProperty(stringArray[i]);
            if (string2 == null) continue;
            properties.put(stringArray[i], string2);
        }
        if (properties.size() > 0) {
            propertiesStorage.save(properties);
        }
    }

    private static Set<DefaultResult> parse(Set<FileObject> set) {
        HashSet<DefaultResult> hashSet = new HashSet<DefaultResult>();
        for (FileObject fileObject : set) {
            try {
                hashSet.add(SystemOptionsParser.parse(fileObject, false));
            }
            catch (Exception exception) {
                boolean bl = false;
                if (!$assertionsDisabled) {
                    bl = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (!bl) continue;
                Logger.getLogger("org.netbeans.upgrade.systemoptions.parse").log(Level.INFO, "importing: " + fileObject.getPath(), exception);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadImportFilesDefinition() throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = Importer.class.getResourceAsStream(DEFINITION_OF_FILES);
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        return properties;
    }

    private static Set<FileObject> getImportFiles(Properties properties) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (String string : properties.keySet()) {
            FileObject fileObject = FileUtil.getConfigFile((String)string);
            if (fileObject == null) continue;
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    private Importer() {
    }
}

