/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.netbeans.util.Util;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CopyFiles {
    private File sourceRoot;
    private File targetRoot;
    private EditableProperties currentProperties;
    private Set<String> includePatterns = new HashSet<String>();
    private Set<String> excludePatterns = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(CopyFiles.class.getName());

    private CopyFiles(File file, File file2, File file3) {
        this.sourceRoot = file;
        this.targetRoot = file2;
        try {
            FileInputStream fileInputStream = new FileInputStream(file3);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "utf-8");
            this.readPatterns(inputStreamReader);
            ((Reader)inputStreamReader).close();
        }
        catch (IOException iOException) {
            JDialog jDialog = Util.createJOptionDialog(new JOptionPane(iOException, 0), iOException.getMessage());
            jDialog.setVisible(true);
            return;
        }
    }

    public static void copyDeep(File file, File file2, File file3) throws IOException {
        CopyFiles copyFiles = new CopyFiles(file, file2, file3);
        LOGGER.fine("Copying from: " + copyFiles.sourceRoot + "\nto: " + copyFiles.targetRoot);
        copyFiles.copyFolder(copyFiles.sourceRoot);
    }

    private void copyFolder(File file) throws IOException {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                this.copyFolder(file2);
                continue;
            }
            this.copyFile(file2);
        }
    }

    private static String getRelativePath(File file, File file2) {
        String string = file2.getAbsolutePath().substring(file.getAbsolutePath().length());
        if ((string = string.replace('\\', '/')).startsWith("/") && !string.startsWith("//")) {
            string = string.substring(1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws IOException {
        CopyFiles.ensureParent(file2);
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            FileUtil.copy((InputStream)fileInputStream, (OutputStream)outputStream);
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(File file) throws IOException {
        FileOutputStream fileOutputStream;
        String string = CopyFiles.getRelativePath(this.sourceRoot, file);
        this.currentProperties = null;
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String object : this.includePatterns) {
            if (object.contains("#")) {
                hashSet.addAll(this.matchingKeys(string, object));
                continue;
            }
            if (!string.matches(object)) continue;
            bl = true;
            hashSet.clear();
            break;
        }
        if (bl || !hashSet.isEmpty()) {
            for (String string2 : this.excludePatterns) {
                if (string2.contains("#")) {
                    hashSet2.addAll(this.matchingKeys(string, string2));
                    continue;
                }
                if (!string.matches(string2)) continue;
                bl = false;
                hashSet.clear();
                break;
            }
        }
        LOGGER.log(Level.FINEST, "{0}, includeFile={1}, includeKeys={2}, excludeKeys={3}", new Object[]{string, bl, hashSet, hashSet2});
        if (!bl && hashSet.isEmpty()) {
            return;
        }
        File file2 = new File(this.targetRoot, string);
        LOGGER.log(Level.FINE, "Path: {0}", string);
        if (hashSet.isEmpty() && hashSet2.isEmpty()) {
            CopyFiles.copyFile(file, file2);
            return;
        }
        if (!hashSet.isEmpty()) {
            this.currentProperties.keySet().retainAll(hashSet);
        }
        this.currentProperties.keySet().removeAll(hashSet2);
        LOGGER.log(Level.FINE, "  Only keys: {0}", this.currentProperties.keySet());
        OutputStream outputStream = null;
        try {
            CopyFiles.ensureParent(file2);
            fileOutputStream = new FileOutputStream(file2);
            this.currentProperties.store((OutputStream)fileOutputStream);
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            if (outputStream == null) throw throwable;
            outputStream.close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    private Set<String> matchingKeys(String string, String string2) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = string2.split("#", 2);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (string.matches(string3)) {
            if (this.currentProperties == null) {
                this.currentProperties = this.getProperties(string);
            }
            for (String string5 : this.currentProperties.keySet()) {
                if (!string5.matches(string4)) continue;
                hashSet.add(string5);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableProperties getProperties(String string) throws IOException {
        EditableProperties editableProperties = new EditableProperties(false);
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(this.sourceRoot, string));
            editableProperties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return editableProperties;
    }

    private static void ensureParent(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            throw new IOException("Cannot create folder: " + file2.getAbsolutePath());
        }
    }

    private void readPatterns(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0 || string.startsWith("#")) continue;
            if (string.startsWith("include ")) {
                if ((string = string.substring(8)).length() <= 0) continue;
                this.includePatterns.addAll(CopyFiles.parsePattern(string));
                continue;
            }
            if (string.startsWith("exclude ")) {
                if ((string = string.substring(8)).length() <= 0) continue;
                this.excludePatterns.addAll(CopyFiles.parsePattern(string));
                continue;
            }
            throw new IOException("Wrong line: " + string);
        }
    }

    private static Set<String> parsePattern(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string.contains("#")) {
            StringBuilder stringBuilder = new StringBuilder();
            ParserState parserState = ParserState.START;
            int n = 0;
            block6: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (parserState) {
                    case START: {
                        if (c == '#') {
                            parserState = ParserState.IN_KEY_PATTERN;
                            stringBuilder.append(c);
                            continue block6;
                        }
                        if (c == '(') {
                            parserState = ParserState.IN_BLOCK;
                            ++n;
                            stringBuilder.append(c);
                            continue block6;
                        }
                        if (c == '|') {
                            hashSet.add(stringBuilder.toString());
                            stringBuilder = new StringBuilder();
                            continue block6;
                        }
                        stringBuilder.append(c);
                        continue block6;
                    }
                    case IN_KEY_PATTERN: {
                        if (c == '#') {
                            parserState = ParserState.AFTER_KEY_PATTERN;
                            continue block6;
                        }
                        stringBuilder.append(c);
                        continue block6;
                    }
                    case AFTER_KEY_PATTERN: {
                        if (c == '|') {
                            parserState = ParserState.START;
                            hashSet.add(stringBuilder.toString());
                            stringBuilder = new StringBuilder();
                            continue block6;
                        }
                        assert (false) : "Wrong OptionsExport pattern " + string + ". Only format like filePattern1#keyPattern#|filePattern2 is supported.";
                        continue block6;
                    }
                    case IN_BLOCK: {
                        stringBuilder.append(c);
                        if (c != ')' || --n != 0) continue block6;
                        parserState = ParserState.START;
                    }
                }
            }
            hashSet.add(stringBuilder.toString());
        } else {
            hashSet.add(string);
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParserState {
        START,
        IN_KEY_PATTERN,
        AFTER_KEY_PATTERN,
        IN_BLOCK;

    }
}

