/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BuildInfo {
    protected static final String BUILD_INFO_FILE = "build_info";
    private static final String[] order = new String[]{"Number", "Date", "Branding", "Branch", "Tag", "Hg ID"};
    private static final Pattern linePattern = Pattern.compile("(.+):\\s+((.+)\\z)");

    BuildInfo() {
    }

    static LogRecord logBuildInfoRec() {
        LogRecord logRecord = new LogRecord(Level.CONFIG, BUILD_INFO_FILE);
        List<String> list = BuildInfo.logBuildInfo();
        if (list != null) {
            logRecord.setParameters(list.toArray());
        }
        return logRecord;
    }

    static List<String> logBuildInfo() {
        List<String> list = null;
        File file = InstalledFileLocator.getDefault().locate(BUILD_INFO_FILE, null, false);
        if (file != null) {
            list = BuildInfo.logBuildInfo(file);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> logBuildInfo(File file) {
        ArrayList<String> arrayList = null;
        FileReader fileReader = null;
        try {
            String string;
            fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            while ((string = bufferedReader.readLine()) != null) {
                Matcher matcher = linePattern.matcher(string);
                if (!matcher.matches() || matcher.groupCount() <= 2) continue;
                hashtable.put(matcher.group(1), matcher.group(2));
            }
            arrayList = new ArrayList<String>();
            for (int i = 0; i < order.length; ++i) {
                String string2 = (String)hashtable.get(order[i]);
                if (string2 != null) {
                    arrayList.add(string2);
                    continue;
                }
                arrayList.add("");
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return arrayList;
    }
}

